/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal.wrappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.PacketDistributor;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.entities.EntityXRFakePlayer;
import xreliquary.network.PacketHandler;
import xreliquary.network.PacketPedestalFishHook;
import xreliquary.reference.Settings;

public class PedestalFishingRodWrapper
implements IPedestalActionItemWrapper {
    private static final int PACKET_RANGE = 50;
    private static final int RANGE = 4;
    private static final int NO_WATER_COOLDOWN = 100;
    private static final int BAD_THROW_TIMEOUT = 60;
    private static final int ABSOLUTE_TIMEOUT = 1200;
    private EntityXRFakePlayer fakePlayer;
    private boolean badThrowChecked;
    private int ticksSinceLastThrow;
    private boolean retractFail = false;

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        ++this.ticksSinceLastThrow;
        if (this.fakePlayer != null && this.fakePlayer.field_71104_cf != null) {
            this.handleHookStates(stack, pedestal);
            this.syncHookData(pedestal);
        } else {
            this.setupFakePlayer(pedestal.getTheWorld(), pedestal.getBlockPos());
            Optional<BlockPos> p = this.getBestWaterBlock(pedestal);
            if (p.isPresent()) {
                this.updateHeldItem(stack);
                this.setPitchYaw(p.get());
                this.spawnFishHook(pedestal);
                this.badThrowChecked = false;
                this.ticksSinceLastThrow = 0;
            } else {
                pedestal.setActionCoolDown(100);
            }
        }
    }

    private void handleHookStates(ItemStack stack, IPedestal pedestal) {
        if (this.retractFail) {
            if (this.getTicksCatchable(this.fakePlayer.field_71104_cf) == 0) {
                this.retractHook(pedestal, stack);
                this.retractFail = false;
            }
        } else if (!this.badThrowChecked && this.ticksSinceLastThrow > 60) {
            if (!this.fakePlayer.field_71104_cf.func_70090_H()) {
                this.retractHook(pedestal, stack);
            } else {
                this.badThrowChecked = true;
            }
        } else if (this.ticksSinceLastThrow > 1200) {
            this.retractHook(pedestal, stack);
        } else if (this.getTicksCatchable(this.fakePlayer.field_71104_cf) > 0 || this.fakePlayer.field_71104_cf.field_146043_c != null) {
            if (pedestal.getTheWorld().field_73012_v.nextInt(100) <= (Integer)Settings.COMMON.blocks.pedestal.fishingWrapperSuccessRate.get()) {
                this.retractHook(pedestal, stack);
            } else {
                this.retractFail = true;
            }
        }
    }

    private void updateHeldItem(ItemStack fishingRod) {
        ItemStack heldItem = this.fakePlayer.func_184614_ca();
        if (heldItem.func_190926_b()) {
            this.fakePlayer.func_184611_a(Hand.MAIN_HAND, fishingRod);
            return;
        }
        if (!heldItem.func_185136_b(fishingRod)) {
            this.fakePlayer.func_184611_a(Hand.MAIN_HAND, fishingRod);
        }
    }

    private void retractHook(IPedestal pedestal, ItemStack stack) {
        int i = this.fakePlayer.field_71104_cf.func_146034_e(stack);
        stack.func_222118_a(i, (LivingEntity)this.fakePlayer, p -> {});
        if (stack.func_190916_E() == 0) {
            pedestal.destroyItem();
        }
        pedestal.setActionCoolDown((Integer)Settings.COMMON.blocks.pedestal.fishingWrapperRetractDelay.get() * 20);
    }

    private Optional<BlockPos> getBestWaterBlock(IPedestal pedestal) {
        ArrayList<List<BlockPos>> connectedGroups = new ArrayList<List<BlockPos>>();
        ArrayList<BlockPos> visitedBlocks = new ArrayList<BlockPos>();
        BlockPos pos = pedestal.getBlockPos();
        int pedestalX = pos.func_177958_n();
        int pedestalY = pos.func_177956_o();
        int pedestalZ = pos.func_177952_p();
        for (int y = pedestalY - 4; y < pedestalY; ++y) {
            for (int r = 1; r <= 4; ++r) {
                int x;
                int z = pedestalZ - r;
                for (x = pedestalX - r; x <= pedestalX + r; ++x) {
                    this.checkForAndAddWaterBlocks(pedestal, visitedBlocks, connectedGroups, pos, x, y, z);
                }
                --x;
                while (z <= pedestalZ + r) {
                    this.checkForAndAddWaterBlocks(pedestal, visitedBlocks, connectedGroups, pos, x, y, z);
                    ++z;
                }
                --z;
                while (x >= pedestalX - r) {
                    this.checkForAndAddWaterBlocks(pedestal, visitedBlocks, connectedGroups, pos, x, y, z);
                    --x;
                }
                ++x;
                while (z >= pedestalZ - r) {
                    this.checkForAndAddWaterBlocks(pedestal, visitedBlocks, connectedGroups, pos, x, y, z);
                    --z;
                }
            }
        }
        BlockPos closestBlockInLargestGroup = null;
        int closestSqDistance = Integer.MAX_VALUE;
        int mostBlocks = 0;
        for (List list : connectedGroups) {
            if (list.size() <= mostBlocks) continue;
            mostBlocks = list.size();
            for (BlockPos waterPos : list) {
                int zDiff;
                int yDiff;
                int xDiff = waterPos.func_177958_n() - pedestalX;
                int sqDistance = xDiff * xDiff + (yDiff = waterPos.func_177956_o() - pedestalY) * yDiff + (zDiff = waterPos.func_177952_p() - pedestalZ) * zDiff;
                if (sqDistance >= closestSqDistance) continue;
                closestSqDistance = sqDistance;
                closestBlockInLargestGroup = waterPos;
            }
        }
        return Optional.ofNullable(closestBlockInLargestGroup);
    }

    private void checkForAndAddWaterBlocks(IPedestal pedestal, List<BlockPos> visitedBlocks, List<List<BlockPos>> connectedGroups, BlockPos pedestalPos, int x, int y, int z) {
        BlockPos blockPos = new BlockPos(x, y, z);
        if (!visitedBlocks.contains(blockPos)) {
            ArrayList<BlockPos> group = new ArrayList<BlockPos>();
            this.checkForWaterAndSearchNeighbors(pedestal, visitedBlocks, pedestalPos, blockPos, group);
            if (!group.isEmpty()) {
                connectedGroups.add(group);
            }
        }
    }

    private void checkForWaterAndSearchNeighbors(IPedestal pedestal, List<BlockPos> visitedBlocks, BlockPos pedestalPos, BlockPos blockPos, List<BlockPos> group) {
        visitedBlocks.add(blockPos);
        BlockState blockState = pedestal.getTheWorld().func_180495_p(blockPos);
        if (blockState.func_177230_c() == Blocks.field_150355_j) {
            int x = blockPos.func_177958_n();
            int y = blockPos.func_177956_o();
            int z = blockPos.func_177952_p();
            double startX = this.fakePlayer.field_70165_t;
            double startY = this.fakePlayer.field_70163_u;
            double startZ = this.fakePlayer.field_70161_v;
            BlockRayTraceResult raytraceresult = pedestal.getTheWorld().func_217299_a(new RayTraceContext(new Vec3d(startX, startY, startZ), new Vec3d((double)x + 0.5, (double)y + 0.8, (double)z + 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)this.fakePlayer));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && raytraceresult.func_216350_a().equals((Object)blockPos)) {
                group.add(blockPos);
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos neighborPos = blockPos.func_177972_a(direction);
                    if (neighborPos.func_177958_n() > pedestalPos.func_177958_n() + 4 || neighborPos.func_177958_n() < pedestalPos.func_177958_n() - 4 || neighborPos.func_177956_o() > pedestalPos.func_177956_o() + 4 || neighborPos.func_177956_o() < pedestalPos.func_177956_o() - 4) continue;
                    this.addNeighboringWater(pedestal, visitedBlocks, group, pedestalPos, neighborPos);
                }
            }
        }
    }

    private void addNeighboringWater(IPedestal pedestal, List<BlockPos> visitedBlocks, List<BlockPos> group, BlockPos pedestalPos, BlockPos blockPos) {
        if (!visitedBlocks.contains(blockPos)) {
            this.checkForWaterAndSearchNeighbors(pedestal, visitedBlocks, pedestalPos, blockPos, group);
        }
    }

    private void spawnFishHook(IPedestal pedestal) {
        World world = pedestal.getTheWorld();
        world.func_184133_a(null, pedestal.getBlockPos(), SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
        world.func_217376_c((Entity)new FishingBobberEntity((PlayerEntity)this.fakePlayer, world, 0, 0));
    }

    private void syncHookData(IPedestal pedestal) {
        FishingBobberEntity hook = this.fakePlayer.field_71104_cf;
        BlockPos pedestalPos = pedestal.getBlockPos();
        if (hook == null) {
            PacketHandler.sendToAllAround(new PacketPedestalFishHook(pedestal.getBlockPos(), -1.0, -1.0, -1.0), new PacketDistributor.TargetPoint((double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p(), 50.0, pedestal.getTheWorld().func_201675_m().func_186058_p()));
        } else {
            PacketHandler.sendToAllAround(new PacketPedestalFishHook(pedestal.getBlockPos(), hook.field_70165_t, hook.field_70163_u, hook.field_70161_v), new PacketDistributor.TargetPoint((double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p(), 50.0, pedestal.getTheWorld().func_201675_m().func_186058_p()));
        }
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
        if (this.fakePlayer != null && this.fakePlayer.field_71104_cf != null) {
            this.fakePlayer.field_71104_cf.func_70106_y();
        }
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
        if (this.fakePlayer != null && this.fakePlayer.field_71104_cf != null) {
            this.fakePlayer.field_71104_cf.func_70106_y();
            this.syncHookData(pedestal);
        }
    }

    private void setupFakePlayer(World world, BlockPos pos) {
        if (this.fakePlayer == null) {
            this.fakePlayer = new EntityXRFakePlayer((ServerWorld)world);
            this.fakePlayer.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5);
        }
    }

    private int getTicksCatchable(@Nullable FishingBobberEntity hook) {
        return (Integer)ObfuscationReflectionHelper.getPrivateValue(FishingBobberEntity.class, (Object)hook, (String)"field_146045_ax");
    }

    private void setPitchYaw(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        double degree = 57.29577951308232;
        double dx = this.fakePlayer.field_70165_t - ((double)x + 0.5);
        double dy = this.fakePlayer.field_70163_u - (double)y;
        double dz = this.fakePlayer.field_70161_v - ((double)z + 0.5);
        this.fakePlayer.field_70177_z = (float)(-(Math.atan2(dx, dz) * degree + 180.0));
        this.fakePlayer.field_70125_A = (float)(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) * degree);
    }
}

