/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal.wrappers;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.reference.Settings;

public class PedestalMeleeWeaponWrapper
implements IPedestalActionItemWrapper {
    private int cooldownAfterSwing;

    public PedestalMeleeWeaponWrapper() {
        this.cooldownAfterSwing = (Integer)Settings.COMMON.blocks.pedestal.meleeWrapperCooldown.get();
    }

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        FakePlayer fakePlayer = pedestal.getFakePlayer();
        World world = pedestal.getTheWorld();
        BlockPos pos = pedestal.getBlockPos();
        int meleeRange = (Integer)Settings.COMMON.blocks.pedestal.meleeWrapperRange.get();
        List entities = world.func_217357_a(MobEntity.class, new AxisAlignedBB((double)pos.func_177958_n() - (double)meleeRange, (double)pos.func_177956_o() - (double)meleeRange, (double)pos.func_177952_p() - (double)meleeRange, (double)pos.func_177958_n() + (double)meleeRange, (double)pos.func_177956_o() + (double)meleeRange, (double)pos.func_177952_p() + (double)meleeRange));
        if (entities.isEmpty()) {
            pedestal.setActionCoolDown(40);
            return;
        }
        MobEntity entityToAttack = (MobEntity)entities.get(world.field_73012_v.nextInt(entities.size()));
        while (!entities.isEmpty() && !this.canAttackEntity(entityToAttack)) {
            entities.remove(entityToAttack);
            if (entities.isEmpty()) continue;
            entityToAttack = (MobEntity)entities.get(world.field_73012_v.nextInt(entities.size()));
        }
        if (entities.isEmpty()) {
            pedestal.setActionCoolDown(40);
            return;
        }
        fakePlayer.func_70107_b((double)pos.func_177958_n(), 0.0, (double)pos.func_177952_p());
        fakePlayer.func_184611_a(Hand.MAIN_HAND, stack);
        fakePlayer.func_70071_h_();
        fakePlayer.func_71059_n((Entity)entityToAttack);
        pedestal.setActionCoolDown((int)fakePlayer.func_184818_cX() + this.cooldownAfterSwing);
        if (stack.func_190926_b()) {
            pedestal.destroyItem();
        }
    }

    private boolean canAttackEntity(MobEntity entityToAttack) {
        return !(!entityToAttack.func_184222_aU() || entityToAttack instanceof VillagerEntity || entityToAttack instanceof AnimalEntity && entityToAttack.func_70631_g_() || entityToAttack instanceof HorseEntity && ((HorseEntity)entityToAttack).func_110248_bS() || entityToAttack instanceof TameableEntity && ((TameableEntity)entityToAttack).func_70909_n());
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }
}

