/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import xreliquary.blocks.PedestalBlock;
import xreliquary.items.ToggleableItem;
import xreliquary.items.util.ILeftClickableItem;
import xreliquary.items.util.VoidTearItemStackHandler;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.NoPlayerBlockItemUseContext;
import xreliquary.util.RandHelper;
import xreliquary.util.StackHelper;
import xreliquary.util.WorldHelper;

public class VoidTearItem
extends ToggleableItem
implements ILeftClickableItem {
    private static final String CONTENTS_TAG = "contents";
    private static final String TOOLTIP_PREFIX = "tooltip.";

    public VoidTearItem() {
        super("void_tear", new Item.Properties());
        MinecraftForge.EVENT_BUS.addListener(this::onItemPickup);
        this.func_185043_a(new ResourceLocation("empty"), (stack, world, entity) -> this.isEmpty(stack, true) ? 1.0f : 0.0f);
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.isEmpty(stack) ? 16 : 1;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilitySerializable<CompoundNBT>(){
            VoidTearItemStackHandler itemHandler = new VoidTearItemStackHandler();

            public CompoundNBT serializeNBT() {
                return this.itemHandler.serializeNBT();
            }

            public void deserializeNBT(CompoundNBT nbt) {
                this.itemHandler.deserializeNBT(nbt);
            }

            public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, LazyOptional.of(() -> this.itemHandler));
            }
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return !Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_151470_d() && super.func_77636_d(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack voidTear, @Nullable World world, List<ITextComponent> tooltip) {
        ItemStack contents = this.getContainerItem(voidTear, true);
        if (this.isEmpty(voidTear, true)) {
            return;
        }
        if (this.isEnabled(voidTear)) {
            LanguageHelper.formatTooltip("tooltip.xreliquary.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.YELLOW + contents.func_200301_q().getString())), tooltip);
            tooltip.add((ITextComponent)new StringTextComponent(LanguageHelper.getLocalization("tooltip.xreliquary.absorb_tear", new Object[0])));
        }
        LanguageHelper.formatTooltip("tooltip.xreliquary.tear_quantity", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)contents.func_200301_q().getString(), (Object)"amount", (Object)Integer.toString(contents.func_190916_E())), tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return !this.isEmpty(stack, true);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack voidTear = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            RayTraceResult rayTraceResult = VoidTearItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
            if (rayTraceResult != null && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && (InventoryHelper.hasItemHandler(world, ((BlockRayTraceResult)rayTraceResult).func_216350_a()) && player.func_225608_bj_() || this.hasPlaceableBlock(voidTear))) {
                return new ActionResult(ActionResultType.PASS, (Object)voidTear);
            }
            if (this.isEmpty(voidTear)) {
                return this.rightClickEmpty(voidTear, player);
            }
            if (this.getItemQuantity(voidTear) == 0) {
                this.setEmpty(voidTear);
                return new ActionResult(ActionResultType.SUCCESS, (Object)voidTear);
            }
            if (player.func_225608_bj_()) {
                return super.func_77659_a(world, player, hand);
            }
            if (Boolean.TRUE.equals(InventoryHelper.getItemHandlerFrom(player).map(h -> this.attemptToEmptyIntoInventory(voidTear, player, (IItemHandler)h)).orElse((Object)false))) {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.7f + 1.2f));
                this.setEmpty(voidTear);
                return new ActionResult(ActionResultType.SUCCESS, (Object)voidTear);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)voidTear);
    }

    private boolean hasPlaceableBlock(ItemStack voidTear) {
        return !this.isEmpty(voidTear) && this.getContainerItem(voidTear, false).func_77973_b() instanceof BlockItem;
    }

    private ActionResult<ItemStack> rightClickEmpty(ItemStack emptyVoidTear, PlayerEntity player) {
        return (ActionResult)InventoryHelper.getItemHandlerFrom(player).map(playerInventory -> {
            ItemStack target = InventoryHelper.getTargetItem(emptyVoidTear, playerInventory);
            if (!target.func_190926_b()) {
                ItemStack filledTear;
                if (emptyVoidTear.func_190916_E() > 1) {
                    emptyVoidTear.func_190918_g(1);
                    filledTear = new ItemStack((IItemProvider)this);
                } else {
                    filledTear = emptyVoidTear;
                }
                this.buildTear(filledTear, target, player, (IItemHandler)playerInventory, true);
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.7f + 1.2f));
                if (emptyVoidTear.func_190916_E() == 1) {
                    return new ActionResult(ActionResultType.SUCCESS, (Object)filledTear);
                }
                InventoryHelper.addItemToPlayerInventory(player, filledTear);
                return new ActionResult(ActionResultType.SUCCESS, (Object)emptyVoidTear);
            }
            return new ActionResult(ActionResultType.PASS, (Object)emptyVoidTear);
        }).orElse((Object)new ActionResult(ActionResultType.PASS, (Object)emptyVoidTear));
    }

    private void buildTear(ItemStack voidTear, ItemStack target, PlayerEntity player, IItemHandler inventory, boolean isPlayerInventory) {
        int quantity = InventoryHelper.getItemQuantity(target, inventory);
        if (isPlayerInventory) {
            if (quantity - target.func_77976_d() > 0) {
                InventoryHelper.consumeItem(target, player, target.func_77976_d(), quantity - target.func_77976_d());
                quantity -= target.func_77976_d();
            } else {
                InventoryHelper.consumeItem(target, player, 0, 1);
                quantity = 1;
            }
        } else {
            quantity = InventoryHelper.tryToRemoveFromInventory(target, inventory, (Integer)Settings.COMMON.items.voidTear.itemLimit.get());
        }
        this.setItemStack(voidTear, target);
        this.setItemQuantity(voidTear, quantity);
        NBTHelper.putBoolean("enabled", voidTear, (Boolean)Settings.COMMON.items.voidTear.absorbWhenCreated.get());
    }

    public void func_77663_a(ItemStack voidTear, World world, Entity entity, int slotNumber, boolean isSelected) {
        if (!world.field_72995_K) {
            if (!(entity instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)entity;
            if (this.isEnabled(voidTear)) {
                if (this.isEmpty(voidTear)) {
                    this.setEmpty(voidTear);
                    return;
                }
                ItemStack contents = this.getContainerItem(voidTear);
                if (!contents.func_190926_b()) {
                    this.fillTear(voidTear, player, contents);
                } else {
                    this.setEmpty(voidTear);
                }
            }
        }
    }

    private void fillTear(ItemStack voidTear, PlayerEntity player, ItemStack contents) {
        int itemQuantity = (Integer)InventoryHelper.getItemHandlerFrom(player).map(h -> InventoryHelper.getItemQuantity(contents, h)).orElse((Object)9);
        if (this.getItemQuantity(voidTear) <= (Integer)Settings.COMMON.items.voidTear.itemLimit.get() && itemQuantity > this.getKeepQuantity(voidTear) && InventoryHelper.consumeItem(contents, player, this.getKeepQuantity(voidTear), itemQuantity - this.getKeepQuantity(voidTear)) && !player.func_184812_l_()) {
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) + itemQuantity - this.getKeepQuantity(voidTear));
        }
        if (this.getMode(voidTear) != Mode.NO_REFILL) {
            this.attemptToReplenish(player, voidTear);
        }
    }

    private void attemptToReplenish(PlayerEntity player, ItemStack voidTear) {
        int slot;
        if (Boolean.TRUE.equals(InventoryHelper.getItemHandlerFrom(player).map(h -> this.fillFirstFirstStackFound(voidTear, (IItemHandler)h)).orElse((Object)false))) {
            return;
        }
        while (this.getItemQuantity(voidTear) > 1 && (slot = player.field_71071_by.func_70447_i()) != -1) {
            ItemStack newStack = this.getContainerItem(voidTear).func_77946_l();
            int quantityToDecrease = Math.min(newStack.func_77976_d(), this.getItemQuantity(voidTear) - 1);
            newStack.func_190920_e(quantityToDecrease);
            player.field_71071_by.func_70299_a(slot, newStack);
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - quantityToDecrease);
            if (this.getMode(voidTear) == Mode.FULL_INVENTORY) continue;
            return;
        }
    }

    private boolean fillFirstFirstStackFound(ItemStack voidTear, IItemHandler h) {
        for (int slot = 0; slot < h.getSlots(); ++slot) {
            ItemStack stackFound = h.getStackInSlot(slot);
            if (!StackHelper.isItemAndNbtEqual(stackFound, this.getContainerItem(voidTear))) continue;
            int quantityToDecrease = Math.min(stackFound.func_77976_d() - stackFound.func_190916_E(), this.getItemQuantity(voidTear) - 1);
            stackFound.func_190917_f(quantityToDecrease);
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - quantityToDecrease);
            if (this.getMode(voidTear) == Mode.FULL_INVENTORY) continue;
            return true;
        }
        return false;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        Direction face;
        ItemStack containerItem;
        BlockItem itemBlock;
        NoPlayerBlockItemUseContext noPlayerBlockItemUseContext;
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack voidTear = player.func_184586_b(hand);
        if (world.func_180495_p(pos).func_177230_c() instanceof PedestalBlock) {
            return ActionResultType.PASS;
        }
        LazyOptional handler = WorldHelper.getTile((IBlockReader)world, pos).map(InventoryHelper::getItemHandlerFrom).orElse(LazyOptional.empty());
        if (handler.isPresent()) {
            return (ActionResultType)handler.map(h -> this.processItemHandlerInteraction(player, hand, world, voidTear, (IItemHandler)h)).orElse((Object)ActionResultType.FAIL);
        }
        if (!world.field_72995_K && this.hasPlaceableBlock(voidTear) && this.getItemQuantity(voidTear) > 0 && (noPlayerBlockItemUseContext = new NoPlayerBlockItemUseContext(world, pos, new ItemStack((IItemProvider)(itemBlock = (BlockItem)(containerItem = this.getContainerItem(voidTear)).func_77973_b())), face = context.func_196000_l())).func_196011_b()) {
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - 1);
            itemBlock.func_195942_a((BlockItemUseContext)noPlayerBlockItemUseContext);
        }
        return ActionResultType.PASS;
    }

    private ActionResultType processItemHandlerInteraction(PlayerEntity player, Hand hand, World world, ItemStack voidTear, IItemHandler itemHandler) {
        if (!world.field_72995_K) {
            if (this.isEmpty(voidTear)) {
                return this.onItemUseFirstEmpty(voidTear, itemHandler, player, hand);
            }
            if (this.isEnabled(voidTear)) {
                this.drainInventory(voidTear, player, itemHandler);
            } else {
                this.emptyIntoInventory(player, hand, voidTear, itemHandler);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void emptyIntoInventory(PlayerEntity player, Hand hand, ItemStack voidTear, IItemHandler itemHandler) {
        this.attemptToEmptyIntoInventory(voidTear, player, itemHandler);
        if (this.getItemQuantity(voidTear) <= 0) {
            this.setEmpty(voidTear);
            player.func_184611_a(hand, voidTear);
        }
    }

    private ActionResultType onItemUseFirstEmpty(ItemStack emptyVoidTear, IItemHandler inventory, PlayerEntity player, Hand hand) {
        ItemStack target = InventoryHelper.getTargetItem(emptyVoidTear, inventory);
        if (!target.func_190926_b()) {
            ItemStack filledTear;
            if (emptyVoidTear.func_190916_E() > 1) {
                emptyVoidTear.func_190918_g(1);
                filledTear = new ItemStack((IItemProvider)this);
            } else {
                filledTear = emptyVoidTear;
            }
            this.buildTear(filledTear, target, player, inventory, false);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.7f + 1.2f));
            if (emptyVoidTear.func_190916_E() == 1) {
                player.func_184611_a(hand, filledTear);
            } else {
                InventoryHelper.addItemToPlayerInventory(player, filledTear);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private boolean attemptToEmptyIntoInventory(ItemStack stack, PlayerEntity player, IItemHandler inventory) {
        ItemStack contents = this.getContainerItem(stack).func_77946_l();
        contents.func_190920_e(1);
        int quantity = this.getItemQuantity(stack);
        int maxNumberToEmpty = player.func_225608_bj_() ? quantity : Math.min(contents.func_77976_d(), quantity);
        this.setItemQuantity(stack, quantity -= InventoryHelper.tryToAddToInventory(contents, inventory, maxNumberToEmpty));
        if (quantity == 0) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.7f + 1.8f));
            return true;
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.7f + 1.2f));
        return false;
    }

    private void drainInventory(ItemStack stack, PlayerEntity player, IItemHandler inventory) {
        ItemStack contents = this.getContainerItem(stack);
        int quantity = this.getItemQuantity(stack);
        int quantityDrained = InventoryHelper.tryToRemoveFromInventory(contents, inventory, (Integer)Settings.COMMON.items.voidTear.itemLimit.get() - quantity);
        if (quantityDrained <= 0) {
            return;
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.7f + 1.2f));
        this.setItemQuantity(stack, quantity + quantityDrained);
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack voidTear) {
        CompoundNBT nbt = super.getShareTag(voidTear);
        if (this.isEmpty(voidTear)) {
            return nbt;
        }
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74768_a("count", this.getItemQuantity(voidTear));
        nbt.func_218657_a(CONTENTS_TAG, (INBT)this.getContainerItem(voidTear).func_77955_b(new CompoundNBT()));
        return nbt;
    }

    public ItemStack getContainerItem(ItemStack voidTear) {
        return this.getContainerItem(voidTear, false);
    }

    public ItemStack getContainerItem(ItemStack voidTear, boolean isClient) {
        if (isClient) {
            CompoundNBT nbt = voidTear.func_77978_p();
            if (nbt == null || !nbt.func_74764_b(CONTENTS_TAG)) {
                return ItemStack.field_190927_a;
            }
            ItemStack contents = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l(CONTENTS_TAG));
            contents.func_190920_e(nbt.func_74762_e("count"));
            return contents;
        }
        return this.getFromHandler(voidTear, VoidTearItemStackHandler::getTotalAmountStack).orElse(ItemStack.field_190927_a);
    }

    private <T> Optional<T> getFromHandler(ItemStack voidTear, Function<VoidTearItemStackHandler, T> get) {
        return InventoryHelper.getFromHandler(voidTear, get, VoidTearItemStackHandler.class);
    }

    private void runOnHandler(ItemStack voidTear, Consumer<VoidTearItemStackHandler> run) {
        InventoryHelper.runOnItemHandler(voidTear, run, VoidTearItemStackHandler.class);
    }

    private void setItemStack(ItemStack voidTear, ItemStack stack) {
        this.runOnHandler(voidTear, h -> h.setContainedStack(stack));
    }

    private void setItemQuantity(ItemStack voidTear, int quantity) {
        this.runOnHandler(voidTear, h -> h.setContainedStackAmount(quantity));
    }

    private int getItemQuantity(ItemStack voidTear) {
        return this.getFromHandler(voidTear, VoidTearItemStackHandler::getContainedAmount).orElse(0);
    }

    @Override
    public ActionResultType onLeftClickItem(ItemStack voidTear, LivingEntity entityLiving) {
        if (!entityLiving.func_225608_bj_()) {
            return ActionResultType.CONSUME;
        }
        if (entityLiving.field_70170_p.field_72995_K) {
            return ActionResultType.PASS;
        }
        this.cycleMode(voidTear);
        return ActionResultType.SUCCESS;
    }

    public Mode getMode(ItemStack voidTear) {
        if (NBTHelper.getString("mode", voidTear).isEmpty()) {
            this.setMode(voidTear, Mode.ONE_STACK);
        }
        return Mode.valueOf(NBTHelper.getString("mode", voidTear));
    }

    private void setMode(ItemStack voidTear, Mode mode) {
        NBTHelper.putString("mode", voidTear, mode.toString());
    }

    private void cycleMode(ItemStack voidTear) {
        if (this.isEmpty(voidTear)) {
            return;
        }
        Mode mode = this.getMode(voidTear);
        switch (mode) {
            case ONE_STACK: {
                this.setMode(voidTear, Mode.FULL_INVENTORY);
                break;
            }
            case FULL_INVENTORY: {
                this.setMode(voidTear, Mode.NO_REFILL);
                break;
            }
            case NO_REFILL: {
                this.setMode(voidTear, Mode.ONE_STACK);
            }
        }
    }

    private int getKeepQuantity(ItemStack voidTear) {
        Mode mode = this.getMode(voidTear);
        if (mode == Mode.NO_REFILL) {
            return 0;
        }
        if (mode == Mode.ONE_STACK) {
            return this.getContainerItem(voidTear).func_77976_d();
        }
        return Integer.MAX_VALUE;
    }

    private void onItemPickup(EntityItemPickupEvent event) {
        ItemStack tearStack;
        ItemStack pickedUpStack = event.getItem().func_92059_d();
        PlayerEntity player = event.getPlayer();
        ItemEntity itemEntity = event.getItem();
        for (int slot = 0; !(slot >= player.field_71071_by.func_70302_i_() || (tearStack = player.field_71071_by.func_70301_a(slot)).func_77973_b() == this && this.isEnabled(tearStack) && this.tryToPickupWithTear(event, pickedUpStack, player, itemEntity, tearStack)); ++slot) {
        }
    }

    private boolean tryToPickupWithTear(EntityItemPickupEvent event, ItemStack pickedUpStack, PlayerEntity player, ItemEntity itemEntity, ItemStack tearStack) {
        int playerItemQuantity;
        int tearItemQuantity = this.getItemQuantity(tearStack);
        if (this.canAbsorbStack(pickedUpStack, tearStack) && ((playerItemQuantity = ((Integer)InventoryHelper.getItemHandlerFrom(player).map(h -> InventoryHelper.getItemQuantity(pickedUpStack, h)).orElse((Object)0)).intValue()) + pickedUpStack.func_190916_E() >= this.getKeepQuantity(tearStack) || player.field_71071_by.func_70447_i() == -1)) {
            this.setItemQuantity(tearStack, tearItemQuantity + pickedUpStack.func_190916_E());
            if (!itemEntity.func_174814_R()) {
                Random rand = itemEntity.field_70170_p.field_73012_v;
                itemEntity.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne(rand) * 0.7f + 1.0f) * 2.0f);
            }
            itemEntity.func_70106_y();
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    boolean canAbsorbStack(ItemStack pickedUpStack, ItemStack tearStack) {
        return StackHelper.isItemAndNbtEqual(this.getContainerItem(tearStack), pickedUpStack) && this.getItemQuantity(tearStack) + pickedUpStack.func_190916_E() <= (Integer)Settings.COMMON.items.voidTear.itemLimit.get();
    }

    public boolean isEmpty(ItemStack voidTear) {
        return this.isEmpty(voidTear, false);
    }

    public boolean isEmpty(ItemStack voidTear, boolean isClient) {
        if (isClient) {
            return this.getContainerItem(voidTear, true).func_190926_b();
        }
        return this.getFromHandler(voidTear, h -> h.getBigStackSlots() <= 0 || h.getContainedAmount() <= 0).orElse(true);
    }

    private void setEmpty(ItemStack voidTear) {
        voidTear.func_77982_d(null);
        this.setItemStack(voidTear, ItemStack.field_190927_a);
        this.setItemQuantity(voidTear, 0);
    }

    public static enum Mode implements IStringSerializable
    {
        ONE_STACK,
        FULL_INVENTORY,
        NO_REFILL;


        public String func_176610_l() {
            return this.name();
        }
    }
}

