/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.potions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import xreliquary.init.ModItems;
import xreliquary.reference.Settings;
import xreliquary.util.LogHelper;
import xreliquary.util.StackHelper;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.PotionEssenceComparator;
import xreliquary.util.potions.PotionIngredient;
import xreliquary.util.potions.XRPotionHelper;

public class PotionMap {
    public static List<PotionIngredient> ingredients = new ArrayList<PotionIngredient>();
    public static List<PotionEssence> potionCombinations = new ArrayList<PotionEssence>();
    public static List<PotionEssence> uniquePotionEssences = new ArrayList<PotionEssence>();
    public static List<PotionEssence> uniquePotions = new ArrayList<PotionEssence>();

    private PotionMap() {
    }

    public static void initPotionMap() {
        PotionMap.setDefaultInConfigIfEmpty();
        PotionMap.loadPotionMapFromSettings();
        LogHelper.debug("Starting calculation of potion combinations");
        PotionMap.loadPotionCombinations();
        PotionMap.loadUniquePotions();
        LogHelper.debug("Done with potion combinations");
    }

    private static void setDefaultInConfigIfEmpty() {
        if (((List)Settings.COMMON.potions.potionMap.get()).isEmpty()) {
            Settings.COMMON.potions.potionMap.set(PotionMap.getDefaultConfigPotionMap());
        }
    }

    private static void loadUniquePotions() {
        uniquePotionEssences.clear();
        uniquePotions.clear();
        for (PotionEssence essence : potionCombinations) {
            boolean found = false;
            for (PotionEssence uniqueEssence : uniquePotionEssences) {
                if (!PotionMap.effectsEqual(essence.getEffects(), uniqueEssence.getEffects())) continue;
                found = true;
                break;
            }
            if (found) continue;
            uniquePotionEssences.add(essence);
            PotionMap.addUniquePotions(essence);
        }
        uniquePotionEssences.sort(new PotionEssenceComparator());
        uniquePotions.sort(new PotionEssenceComparator());
    }

    private static void addUniquePotions(PotionEssence essence) {
        uniquePotions.add(essence);
        if (((Boolean)Settings.COMMON.potions.redstoneAndGlowstone.get()).booleanValue()) {
            PotionEssence redstone = essence.copy();
            redstone.setEffects(XRPotionHelper.augmentPotionEffects(redstone.getEffects(), 1, 0));
            redstone.setRedstoneCount(1);
            uniquePotions.add(redstone);
            PotionEssence glowstone = essence.copy();
            glowstone.setEffects(XRPotionHelper.augmentPotionEffects(redstone.getEffects(), 0, 1));
            glowstone.setGlowstoneCount(1);
            uniquePotions.add(glowstone);
            PotionEssence redstoneGlowstone = essence.copy();
            redstoneGlowstone.setEffects(XRPotionHelper.augmentPotionEffects(redstone.getEffects(), 1, 1));
            redstoneGlowstone.setRedstoneCount(1);
            redstoneGlowstone.setGlowstoneCount(1);
            uniquePotions.add(redstoneGlowstone);
        }
    }

    private static void loadPotionCombinations() {
        potionCombinations.clear();
        for (PotionIngredient ingredient1 : ingredients) {
            for (PotionIngredient ingredient2 : ingredients) {
                PotionEssence twoEssence;
                if (ingredient1.getItem().func_77973_b() == ingredient2.getItem().func_77973_b() || (twoEssence = new PotionEssence.Builder().setIngredients(ingredient1, ingredient2).setEffects(XRPotionHelper.combineIngredients(ingredient1, ingredient2)).build()).getEffects().size() <= 0 || twoEssence.getEffects().size() > (Integer)Settings.COMMON.potions.maxEffectCount.get()) continue;
                PotionMap.addPotionCombination(twoEssence);
                if (!((Boolean)Settings.COMMON.potions.threeIngredients.get()).booleanValue()) continue;
                for (PotionIngredient ingredient3 : ingredients) {
                    if (ingredient3.getItem().func_77973_b() == ingredient1.getItem().func_77973_b() || ingredient3.getItem().func_77973_b() == ingredient2.getItem().func_77973_b()) continue;
                    PotionEssence threeEssence = new PotionEssence.Builder().setIngredients(ingredient1, ingredient2, ingredient3).setEffects(XRPotionHelper.combineIngredients(ingredient1, ingredient2, ingredient3)).build();
                    if (PotionMap.effectsEqual(twoEssence.getEffects(), threeEssence.getEffects())) continue;
                    PotionMap.addPotionCombination(threeEssence);
                }
            }
        }
    }

    private static void addPotionCombination(PotionEssence newEssence) {
        for (PotionEssence essence : potionCombinations) {
            if (PotionMap.ingredientsEqual(essence.getIngredients(), newEssence.getIngredients())) {
                return;
            }
            if (!PotionMap.effectsEqual(essence.getEffects(), newEssence.getEffects(), (Boolean)Settings.COMMON.potions.differentDurations.get()) || PotionMap.effectsEqual(essence.getEffects(), newEssence.getEffects())) continue;
            return;
        }
        potionCombinations.add(newEssence);
    }

    private static boolean ingredientsEqual(List<PotionIngredient> a, List<PotionIngredient> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (PotionIngredient ingredientA : a) {
            boolean found = false;
            for (PotionIngredient ingredientB : b) {
                if (ingredientA.getItem().func_77973_b() != ingredientB.getItem().func_77973_b()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static boolean effectsEqual(List<EffectInstance> a, List<EffectInstance> b) {
        return PotionMap.effectsEqual(a, b, true);
    }

    private static boolean effectsEqual(List<EffectInstance> a, List<EffectInstance> b, boolean compareDuration) {
        if (a.size() != b.size()) {
            return false;
        }
        for (EffectInstance effectA : a) {
            boolean found = false;
            for (EffectInstance effectB : b) {
                if (!effectA.func_76453_d().equals(effectB.func_76453_d()) || compareDuration && effectA.func_76459_b() != effectB.func_76459_b() || effectA.func_76458_c() != effectB.func_76458_c()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static void loadPotionMapFromSettings() {
        ingredients.clear();
        Pattern validEntry = Pattern.compile("[a-z_:0-9]+=[a-z_0-9:\\.\\|;]+");
        for (String entry : (List)Settings.COMMON.potions.potionMap.get()) {
            if (validEntry.matcher(entry).matches()) {
                String[] entryParts = entry.split("=");
                String name = entryParts[0];
                String[] effects = entryParts[1].split(";");
                PotionMap.addItemEffectsToPotionMap(name, effects);
                continue;
            }
            LogHelper.error("Potion map entry \"" + entry + "\" is not valid.\nNeeds to be mod:item_or_block_registry_name=potion_effect_name|duration_multiplier|amplifier\nPotion effect part (\"potion_effect_name|...|amplifier\") can be optionally repeated if there are multiple effects on item, the individual potion sections are delimited by semicolon \";\"\nDuration multiplier is multiples of 15 seconds the potion will last");
        }
    }

    private static void addItemEffectsToPotionMap(String name, String[] effects) {
        StackHelper.getItemStackFromName(name).ifPresent(stack -> {
            PotionIngredient ingredient = new PotionIngredient((ItemStack)stack);
            for (String effect : effects) {
                String[] effectValues = effect.split("\\|");
                String potionName = effectValues[0];
                if (potionName.isEmpty()) continue;
                short durationWeight = Short.parseShort(effectValues[1]);
                short ampWeight = Short.parseShort(effectValues[2]);
                ingredient.addEffect(potionName, durationWeight, ampWeight);
            }
            if (!ingredient.getEffects().isEmpty()) {
                ingredients.add(ingredient);
            }
        });
    }

    public static List<String> getDefaultConfigPotionMap() {
        ArrayList<String> potionMap = new ArrayList<String>();
        PotionMap.addPotionIngredient(potionMap, Items.field_151102_aT, PotionMap.speed(3, 0), PotionMap.haste(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151034_e, PotionMap.heal(0), PotionMap.hboost(3, 0), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151044_h, PotionMap.blind(1), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151044_h, PotionMap.invis(1), PotionMap.wither(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151008_G, PotionMap.jump(3, 0), PotionMap.weak(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151014_N, PotionMap.harm(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151015_O, PotionMap.heal(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151145_ak, PotionMap.harm(0), PotionMap.dboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151147_al, PotionMap.slow(1, 0), PotionMap.fatigue(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151116_aA, PotionMap.resist(3, 0), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151119_aD, PotionMap.slow(1, 0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151110_aK, PotionMap.absorb(3, 0), PotionMap.regen(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_222078_li, PotionMap.heal(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_222081_ls, PotionMap.jump(3, 0), PotionMap.weak(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_222079_lj, PotionMap.resist(3, 0), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_196106_bc, PotionMap.weak(1, 0), PotionMap.fatigue(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151080_bb, PotionMap.invis(1), PotionMap.fireres(1));
        PotionMap.addPotionIngredient(potionMap, Items.field_151082_bd, PotionMap.slow(1, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151076_bf, PotionMap.nausea(1), PotionMap.poison(1));
        PotionMap.addPotionIngredient(potionMap, Items.field_151078_bh, PotionMap.nausea(1), PotionMap.hunger(1), PotionMap.wither(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151074_bl, PotionMap.dboost(0, 0), PotionMap.haste(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151172_bF, PotionMap.vision(3), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151174_bG, PotionMap.hboost(3, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.field_196086_aW, PotionMap.satur(0), PotionMap.breath(1));
        PotionMap.addPotionIngredient(potionMap, Items.field_151070_bp, PotionMap.vision(4), PotionMap.poison(2));
        PotionMap.addPotionIngredient(potionMap, Items.field_151065_br, PotionMap.dboost(4, 0), PotionMap.harm(0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151042_j, PotionMap.resist(4, 0), PotionMap.slow(2, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151007_F, PotionMap.slow(2, 0), PotionMap.fatigue(2, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151025_P, PotionMap.hboost(4, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151157_am, PotionMap.fatigue(2, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151123_aH, PotionMap.resist(4, 0), PotionMap.fireres(2));
        PotionMap.addPotionIngredient(potionMap, Items.field_196102_ba, PotionMap.satur(0), PotionMap.breath(2));
        PotionMap.addPotionIngredient(potionMap, Items.field_196128_bn, PotionMap.haste(4, 0), PotionMap.dboost(4, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_196136_br, PotionMap.blind(2), PotionMap.invis(2));
        PotionMap.addPotionIngredient(potionMap, Items.field_151103_aS, PotionMap.weak(2, 0), PotionMap.fatigue(2, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151106_aX, PotionMap.heal(0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.field_221794_dg, PotionMap.heal(0), PotionMap.speed(4, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151083_be, PotionMap.resist(4, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151077_bg, PotionMap.jump(4, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151168_bH, PotionMap.satur(0), PotionMap.regen(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151170_bI, PotionMap.poison(2), PotionMap.wither(1, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151128_bU, PotionMap.harm(0), PotionMap.dboost(4, 0));
        PotionMap.addPotionIngredient(potionMap, ModItems.ZOMBIE_HEART, PotionMap.nausea(2), PotionMap.hunger(2), PotionMap.wither(1, 0));
        PotionMap.addPotionIngredient(potionMap, ModItems.SQUID_BEAK, PotionMap.hunger(2), PotionMap.breath(2));
        PotionMap.addPotionIngredient(potionMap, Items.field_151158_bO, PotionMap.invis(1), PotionMap.fireres(1), PotionMap.speed(3, 0), PotionMap.haste(3, 0), PotionMap.absorb(3, 0), PotionMap.regen(0, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151064_bs, PotionMap.dboost(4, 0), PotionMap.harm(0), PotionMap.resist(4, 0), PotionMap.fireres(2));
        PotionMap.addPotionIngredient(potionMap, Items.field_151060_bw, PotionMap.dboost(3, 0), PotionMap.haste(3, 0), PotionMap.heal(0), PotionMap.speed(4, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151073_bk, PotionMap.regen(3, 0), PotionMap.absorb(5, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151071_bq, PotionMap.vision(4), PotionMap.poison(2), PotionMap.speed(3, 0), PotionMap.haste(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151150_bK, PotionMap.dboost(3, 0), PotionMap.haste(3, 0), PotionMap.hboost(3, 0), PotionMap.vision(3));
        PotionMap.addPotionIngredient(potionMap, Items.field_151043_k, PotionMap.dboost(4, 0), PotionMap.haste(4, 0), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, ModItems.RIB_BONE, PotionMap.weak(3, 0), PotionMap.fatigue(3, 0), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151079_bi, PotionMap.invis(5), PotionMap.speed(5, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151072_bj, PotionMap.dboost(8, 0), PotionMap.harm(0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151059_bz, PotionMap.dboost(4, 0), PotionMap.harm(0), PotionMap.blind(1), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient(potionMap, ModItems.CATALYZING_GLAND, PotionMap.regen(3, 0), PotionMap.hboost(5, 0));
        PotionMap.addPotionIngredient(potionMap, ModItems.CHELICERAE, PotionMap.poison(3), PotionMap.weak(3, 0));
        PotionMap.addPotionIngredient(potionMap, ModItems.SLIME_PEARL, PotionMap.resist(5, 0), PotionMap.absorb(5, 0));
        PotionMap.addPotionIngredient(potionMap, ModItems.KRAKEN_SHELL_FRAGMENT, PotionMap.absorb(5, 0), PotionMap.breath(5));
        PotionMap.addPotionIngredient(potionMap, ModItems.BAT_WING, PotionMap.jump(5, 0), PotionMap.weak(3, 0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151153_ao, PotionMap.cure(1));
        PotionMap.addPotionIngredient(potionMap, Items.field_151153_ao, PotionMap.cure(2));
        PotionMap.addPotionIngredient(potionMap, Items.field_151045_i, PotionMap.resist(6, 1), PotionMap.absorb(6, 1), PotionMap.fireres(6), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, ModItems.WITHERED_RIB, PotionMap.wither(2, 1), PotionMap.weak(3, 1), PotionMap.slow(3, 1), PotionMap.fatigue(3, 1), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, Items.field_151061_bv, PotionMap.dboost(6, 1), PotionMap.invis(6), PotionMap.speed(6, 1), PotionMap.harm(1));
        PotionMap.addPotionIngredient(potionMap, Items.field_151166_bC, PotionMap.haste(6, 1), PotionMap.speed(6, 1), PotionMap.hboost(6, 1), PotionMap.cure(1));
        PotionMap.addPotionIngredient(potionMap, Items.field_151156_bN, PotionMap.hboost(24, 1), PotionMap.regen(24, 1), PotionMap.absorb(24, 1), PotionMap.cure(2));
        PotionMap.addPotionIngredient(potionMap, ModItems.MOLTEN_CORE, PotionMap.dboost(6, 1), PotionMap.fireres(6), PotionMap.harm(1));
        PotionMap.addPotionIngredient(potionMap, ModItems.EYE_OF_THE_STORM, PotionMap.haste(24, 1), PotionMap.speed(24, 1), PotionMap.jump(24, 1), PotionMap.harm(1), PotionMap.cure(1));
        PotionMap.addPotionIngredient(potionMap, ModItems.FERTILE_ESSENCE, PotionMap.hboost(8, 1), PotionMap.regen(3, 1), PotionMap.heal(1), PotionMap.satur(1), PotionMap.weak(9, 1), PotionMap.fatigue(9, 1), PotionMap.cure(0));
        PotionMap.addPotionIngredient(potionMap, ModItems.FROZEN_CORE, PotionMap.absorb(6, 1), PotionMap.slow(3, 1), PotionMap.fatigue(3, 1), PotionMap.harm(1), PotionMap.fireres(6));
        PotionMap.addPotionIngredient(potionMap, ModItems.NEBULOUS_HEART, PotionMap.vision(6), PotionMap.invis(6), PotionMap.harm(1), PotionMap.hboost(6, 1), PotionMap.dboost(6, 1), PotionMap.speed(6, 1), PotionMap.haste(6, 1));
        PotionMap.addPotionIngredient(potionMap, ModItems.INFERNAL_CLAW, PotionMap.harm(1), PotionMap.resist(6, 1), PotionMap.fireres(6), PotionMap.dboost(6, 1), PotionMap.satur(1), PotionMap.heal(1));
        return potionMap;
    }

    private static String harm(int potency) {
        return PotionMap.effectString("instant_damage", Integer.toString(0), Integer.toString(potency));
    }

    private static String heal(int potency) {
        return PotionMap.effectString("instant_health", Integer.toString(0), Integer.toString(potency));
    }

    private static String satur(int potency) {
        return PotionMap.effectString("saturation", Integer.toString(0), Integer.toString(potency));
    }

    private static String invis(int duration) {
        return PotionMap.effectString("invisibility", Integer.toString(duration), Integer.toString(0));
    }

    private static String absorb(int duration, int potency) {
        return PotionMap.effectString("absorption", Integer.toString(duration), Integer.toString(potency));
    }

    private static String hboost(int duration, int potency) {
        return PotionMap.effectString("health_boost", Integer.toString(duration), Integer.toString(potency));
    }

    private static String dboost(int duration, int potency) {
        return PotionMap.effectString("strength", Integer.toString(duration), Integer.toString(potency));
    }

    private static String speed(int duration, int potency) {
        return PotionMap.effectString("speed", Integer.toString(duration), Integer.toString(potency));
    }

    private static String haste(int duration, int potency) {
        return PotionMap.effectString("haste", Integer.toString(duration), Integer.toString(potency));
    }

    private static String slow(int duration, int potency) {
        return PotionMap.effectString("slowness", Integer.toString(duration), Integer.toString(potency));
    }

    private static String fatigue(int duration, int potency) {
        return PotionMap.effectString("mining_fatigue", Integer.toString(duration), Integer.toString(potency));
    }

    private static String breath(int duration) {
        return PotionMap.effectString("water_breathing", Integer.toString(duration), Integer.toString(0));
    }

    private static String vision(int duration) {
        return PotionMap.effectString("night_vision", Integer.toString(duration), Integer.toString(0));
    }

    private static String resist(int duration, int potency) {
        return PotionMap.effectString("resistance", Integer.toString(duration), Integer.toString(potency));
    }

    private static String fireres(int duration) {
        return PotionMap.effectString("fire_resistance", Integer.toString(duration), Integer.toString(0));
    }

    private static String weak(int duration, int potency) {
        return PotionMap.effectString("weakness", Integer.toString(duration), Integer.toString(potency));
    }

    private static String jump(int duration, int potency) {
        return PotionMap.effectString("jump_boost", Integer.toString(duration), Integer.toString(potency));
    }

    private static String nausea(int duration) {
        return PotionMap.effectString("nausea", Integer.toString(duration), Integer.toString(0));
    }

    private static String hunger(int duration) {
        return PotionMap.effectString("hunger", Integer.toString(duration), Integer.toString(0));
    }

    private static String regen(int duration, int potency) {
        return PotionMap.effectString("regeneration", Integer.toString(duration), Integer.toString(potency));
    }

    private static String poison(int duration) {
        return PotionMap.effectString("poison", Integer.toString(duration), Integer.toString(0));
    }

    private static String wither(int duration, int potency) {
        return PotionMap.effectString("wither", Integer.toString(duration), Integer.toString(potency));
    }

    private static String blind(int duration) {
        return PotionMap.effectString("blindness", Integer.toString(duration), Integer.toString(0));
    }

    private static String cure(int potency) {
        return PotionMap.effectString("xreliquary:cure", Integer.toString(1), Integer.toString(potency));
    }

    private static String effectString(String name, String duration, String potency) {
        return name + "|" + duration + "|" + potency;
    }

    private static void addPotionIngredient(List<String> potionMap, Item ingredient, String ... effects) {
        PotionMap.addPotionIngredient(potionMap, ingredient.getRegistryName().toString(), effects);
    }

    private static void addPotionIngredient(List<String> potionMap, String itemRegistryName, String ... effects) {
        StringJoiner effectsString = new StringJoiner(";");
        Arrays.stream(effects).forEach(effectsString::add);
        potionMap.add(String.format("%s=%s", itemRegistryName, effectsString.toString()));
    }
}

