/*
 * Decompiled with CFR 0.152.
 */
package baguchan.revampedwolf.mixin;

import baguchan.revampedwolf.container.WolfInventoryContainer;
import baguchan.revampedwolf.entity.GroupData;
import baguchan.revampedwolf.entity.HowlingEntity;
import baguchan.revampedwolf.entity.IEatable;
import baguchan.revampedwolf.entity.IWolfArmor;
import baguchan.revampedwolf.entity.IWolfInventory;
import baguchan.revampedwolf.entity.IWolfType;
import baguchan.revampedwolf.entity.LeaderEntity;
import baguchan.revampedwolf.entity.goal.FollowLeaderGoal;
import baguchan.revampedwolf.entity.goal.GoToEatGoal;
import baguchan.revampedwolf.entity.goal.HowlGoal;
import baguchan.revampedwolf.entity.goal.SafeLeapAtTargetGoal;
import baguchan.revampedwolf.entity.goal.WolfAvoidEntityGoal;
import baguchan.revampedwolf.item.WolfArmorItem;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BegGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WolfEntity.class})
public abstract class MixinWolfEntity
extends TameableEntity
implements HowlingEntity,
LeaderEntity,
IAngerable,
IEatable,
IWolfType,
IWolfArmor,
IWolfInventory,
IInventoryChangedListener {
    private static final DataParameter<Boolean> HOWLING = EntityDataManager.func_187226_a(WolfEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> LEADER_UUID_SECONDARY = EntityDataManager.func_187226_a(WolfEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Optional<UUID>> LEADER_UUID_MAIN = EntityDataManager.func_187226_a(WolfEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> EAT_COUNTER = EntityDataManager.func_187226_a(WolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> WOLF_TYPE = EntityDataManager.func_187226_a(WolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Map<Integer, String> TEXTURE_BY_STRING = (Map)Util.func_200696_a((Object)Maps.newHashMap(), p_213410_0_ -> {
        p_213410_0_.put(0, "textures/entity/wolf/wolf");
        p_213410_0_.put(1, "textures/entity/wolf/wolf_brown");
    });
    private float howlAnimationProgress;
    private float lastHowlAnimationProgress;
    private int eatCooldownTicks;
    protected Inventory wolfInventory;
    private LazyOptional<?> itemHandler = null;

    protected MixinWolfEntity(EntityType<? extends WolfEntity> type, World world) {
        super(type, world);
    }

    @Inject(method={"<init>(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V"}, at={@At(value="RETURN")})
    public void onConstructor(CallbackInfo info) {
        this.initWolfInventory();
        this.func_98053_h(true);
    }

    @Inject(method={"registerData"}, at={@At(value="TAIL")}, cancellable=true)
    protected void onRegisterData(CallbackInfo callbackInfo) {
        this.field_70180_af.func_187214_a(HOWLING, (Object)false);
        this.field_70180_af.func_187214_a(LEADER_UUID_MAIN, Optional.empty());
        this.field_70180_af.func_187214_a(LEADER_UUID_SECONDARY, Optional.empty());
        this.field_70180_af.func_187214_a(EAT_COUNTER, (Object)0);
        this.field_70180_af.func_187214_a(WOLF_TYPE, (Object)0);
    }

    @Inject(method={"registerGoals"}, at={@At(value="HEAD")}, cancellable=true)
    protected void registerGoals(CallbackInfo callbackInfo) {
        WolfEntity wolfEntity = (WolfEntity)this;
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, new WolfAvoidEntityGoal<LlamaEntity>(wolfEntity, LlamaEntity.class, 24.0f, 1.5, 1.5));
        this.field_70714_bg.func_75776_a(4, (Goal)new SafeLeapAtTargetGoal((MobEntity)this, 5));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(6, new FollowLeaderGoal<MixinWolfEntity>(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, new GoToEatGoal<MixinWolfEntity>(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new BegGoal(wolfEntity, 8.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new HowlGoal(wolfEntity));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)wolfEntity, PlayerEntity.class, 10, true, false, arg_0 -> ((MixinWolfEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(5, (Goal)new NonTamedTargetGoal(this, AnimalEntity.class, false, WolfEntity.field_213441_bD){

            public boolean func_75250_a() {
                return MixinWolfEntity.this.eatCooldownTicks <= 0 && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(6, (Goal)new NonTamedTargetGoal((TameableEntity)this, TurtleEntity.class, false, TurtleEntity.field_203029_bx));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, false));
        this.field_70715_bh.func_75776_a(8, (Goal)new ResetAngerGoal((MobEntity)this, true));
        callbackInfo.cancel();
    }

    public ItemStack func_213803_dV() {
        return this.func_184582_a(EquipmentSlotType.CHEST);
    }

    private void setChestArmor(ItemStack p_213805_1_) {
        this.func_184201_a(EquipmentSlotType.CHEST, p_213805_1_);
        this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
    }

    protected void setEquipArmor() {
        if (!this.field_70170_p.field_72995_K) {
            this.setArmor(this.wolfInventory.func_70301_a(0));
            this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
        }
    }

    private void setArmor(ItemStack p_213804_1_) {
        this.setChestArmor(p_213804_1_);
    }

    public void func_76316_a(IInventory invBasic) {
        ItemStack itemstack = this.func_213803_dV();
        ItemStack itemstack1 = this.func_213803_dV();
        if (this.field_70173_aa > 20 && this.isWolfArmor(itemstack1) && itemstack != itemstack1) {
            this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
        }
        this.setEquipArmor();
    }

    @Override
    public boolean isWolfArmor(ItemStack stack) {
        return stack.func_77973_b() instanceof WolfArmorItem;
    }

    protected int getInventorySize() {
        return 1;
    }

    @Override
    public Inventory getWolfInventory() {
        return this.wolfInventory;
    }

    protected void initWolfInventory() {
        Inventory inventory = this.wolfInventory;
        this.wolfInventory = new Inventory(this.getInventorySize());
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inventory.func_70302_i_(), this.wolfInventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.wolfInventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.wolfInventory.func_110134_a((IInventoryChangedListener)this);
        this.setEquipArmor();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.wolfInventory));
    }

    @Inject(method={"func_230254_b_"}, at={@At(value="HEAD")}, cancellable=true)
    public void func_230254_b_(PlayerEntity player, Hand hand, CallbackInfoReturnable<ActionResultType> callbackInfo) {
        if (!this.func_70631_g_() && this.func_70909_n() && this.func_233685_eM_() && player.func_226563_dT_()) {
            if (player instanceof ServerPlayerEntity && !(player instanceof FakePlayer) && !player.field_70170_p.field_72995_K) {
                ServerPlayerEntity entityPlayerMP = (ServerPlayerEntity)player;
                NetworkHooks.openGui((ServerPlayerEntity)entityPlayerMP, (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
                        return new WolfInventoryContainer(windowId, inventory, MixinWolfEntity.this.func_145782_y());
                    }

                    public ITextComponent func_145748_c_() {
                        return MixinWolfEntity.this.func_200200_C_();
                    }
                }, buf -> buf.writeInt(this.func_145782_y()));
            }
            callbackInfo.setReturnValue((Object)ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K));
        }
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (super.func_174820_d(inventorySlot, itemStackIn)) {
            return true;
        }
        int i = inventorySlot - 300;
        if (i >= 0 && i < this.wolfInventory.func_70302_i_()) {
            this.wolfInventory.func_70299_a(i, itemStackIn);
            return true;
        }
        return false;
    }

    protected void func_230294_b_(DamageSource damageSource, float damage) {
        super.func_230294_b_(damageSource, damage);
        if (!(damage <= 0.0f)) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            ItemStack itemstack = this.wolfInventory.func_70301_a(0);
            if (!(damageSource.func_76347_k() && itemstack.func_77973_b().func_234687_u_() || !(itemstack.func_77973_b() instanceof WolfArmorItem))) {
                itemstack.func_222118_a((int)damage, (LivingEntity)this, p_214023_1_ -> p_214023_1_.func_213361_c(EquipmentSlotType.CHEST));
            }
        }
    }

    @Override
    public String getWolfTypeName() {
        String state = null;
        if (this.func_70909_n()) {
            state = "_tame";
        } else if (this.func_233678_J__()) {
            state = "_angry";
        }
        if (state != null) {
            return TEXTURE_BY_STRING.getOrDefault(this.getWolfType(), TEXTURE_BY_STRING.get(0)) + state + ".png";
        }
        return TEXTURE_BY_STRING.getOrDefault(this.getWolfType(), TEXTURE_BY_STRING.get(0)) + ".png";
    }

    @Override
    public int getWolfType() {
        return (Integer)this.field_70180_af.func_187225_a(WOLF_TYPE);
    }

    @Override
    public void setWolfType(int type) {
        if (type < 0 || type >= 2) {
            type = this.field_70146_Z.nextInt(2);
        }
        this.field_70180_af.func_187227_b(WOLF_TYPE, (Object)type);
    }

    @Inject(method={"handleStatusUpdate"}, at={@At(value="HEAD")}, cancellable=true)
    public void handleStatusUpdate(byte status, CallbackInfo callbackInfo) {
        if (status == 64) {
            this.setHowling(true);
            callbackInfo.cancel();
        } else {
            this.setHowling(false);
        }
    }

    @Override
    public List<UUID> getLeaderUUIDs() {
        ArrayList list = Lists.newArrayList();
        list.add(((Optional)this.field_70180_af.func_187225_a(LEADER_UUID_SECONDARY)).orElse(null));
        list.add(((Optional)this.field_70180_af.func_187225_a(LEADER_UUID_MAIN)).orElse(null));
        return list;
    }

    @Override
    public void addLeaderUUID(@Nullable UUID uuidIn) {
        if (((Optional)this.field_70180_af.func_187225_a(LEADER_UUID_SECONDARY)).isPresent()) {
            this.field_70180_af.func_187227_b(LEADER_UUID_MAIN, Optional.ofNullable(uuidIn));
        } else {
            this.field_70180_af.func_187227_b(LEADER_UUID_SECONDARY, Optional.ofNullable(uuidIn));
        }
    }

    @Override
    public boolean isLeader() {
        return this.getLeaderUUIDs().contains(this.func_110124_au());
    }

    @Override
    public boolean hasLeader() {
        return this.getLeader() != null && this.getLeader().func_70089_S();
    }

    @Override
    @Nullable
    public TameableEntity getLeader() {
        if (this.field_70170_p instanceof ServerWorld) {
            for (UUID uuid : this.getLeaderUUIDs()) {
                Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(uuid);
                if (!(entity instanceof WolfEntity)) continue;
                return (TameableEntity)entity;
            }
        }
        return null;
    }

    private int getEatCounter() {
        return (Integer)this.field_70180_af.func_187225_a(EAT_COUNTER);
    }

    private void setEatCounter(int p_213571_1_) {
        this.field_70180_af.func_187227_b(EAT_COUNTER, (Object)p_213571_1_);
    }

    @Inject(method={"writeAdditional"}, at={@At(value="TAIL")}, cancellable=true)
    public void onWriteAdditional(CompoundNBT compound, CallbackInfo callbackInfo) {
        List<UUID> list = this.getLeaderUUIDs();
        ListNBT listnbt = new ListNBT();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            listnbt.add((Object)NBTUtil.func_240626_a_((UUID)uuid));
        }
        if (!this.wolfInventory.func_70301_a(0).func_190926_b()) {
            compound.func_218657_a("ArmorItem", (INBT)this.wolfInventory.func_70301_a(0).func_77955_b(new CompoundNBT()));
        }
        compound.func_218657_a("Leader", (INBT)listnbt);
        compound.func_74768_a("EatCooldown", this.eatCooldownTicks);
        compound.func_74768_a("WolfType", this.getWolfType());
    }

    @Inject(method={"readAdditional"}, at={@At(value="TAIL")}, cancellable=true)
    public void onReadAdditional(CompoundNBT compound, CallbackInfo callbackInfo) {
        ListNBT listnbt = compound.func_150295_c("Leader", 11);
        for (int i = 0; i < listnbt.size(); ++i) {
            this.addLeaderUUID(NBTUtil.func_186860_b((INBT)listnbt.get(i)));
        }
        this.eatCooldownTicks = compound.func_74762_e("EatCooldown");
        this.setWolfType(compound.func_74762_e("WolfType"));
        if (compound.func_150297_b("ArmorItem", 10)) {
            ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("ArmorItem"));
            this.wolfInventory.func_70299_a(0, itemstack);
        }
        this.setEquipArmor();
        this.func_98053_h(true);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, cancellable=true)
    public void onTick(CallbackInfo callbackInfo) {
        if (this.func_70089_S()) {
            this.lastHowlAnimationProgress = this.howlAnimationProgress;
            this.howlAnimationProgress = this.isHowling() ? (this.howlAnimationProgress += (1.0f - this.howlAnimationProgress) * 0.4f) : (this.howlAnimationProgress += (0.0f - this.howlAnimationProgress) * 0.4f);
            if (this.eatCooldownTicks > 0) {
                this.eatCooldownTicks = MathHelper.func_76125_a((int)(--this.eatCooldownTicks), (int)0, (int)1200);
            }
            this.eatTick();
        }
    }

    private void eatTick() {
        if (!this.isEating() && !this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() && this.field_70146_Z.nextInt(80) == 0) {
            this.setEating(true);
        } else if (this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() && this.isEating()) {
            this.setEating(false);
        }
        if (this.isEating()) {
            this.makeEatParticle();
            if (!this.field_70170_p.field_72995_K && this.getEatCounter() > 60) {
                if (this.func_70877_b(this.func_184582_a(EquipmentSlotType.MAINHAND)) && this.func_184582_a(EquipmentSlotType.MAINHAND).func_222117_E() && !this.field_70170_p.field_72995_K) {
                    this.func_70691_i(this.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b().func_219967_s().func_221466_a());
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                }
                this.setEating(false);
                return;
            }
            this.setEatCounter(this.getEatCounter() + 1);
        }
    }

    private void makeEatParticle() {
        if (this.getEatCounter() % 5 == 0) {
            this.func_184185_a(SoundEvents.field_187537_bA, 0.5f + 0.1f * this.field_70146_Z.nextFloat(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemstack.func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vector3d vector3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, itemstack), this.func_226277_ct_() + this.func_70040_Z().field_72450_a / 1.85, this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_() + this.func_70040_Z().field_72449_c / 1.85, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
                }
            }
        }
    }

    @Override
    public boolean canEatableFood() {
        return this.eatCooldownTicks <= 0;
    }

    public boolean isEating() {
        return (Integer)this.field_70180_af.func_187225_a(EAT_COUNTER) > 0;
    }

    public void setEating(boolean p_213534_1_) {
        this.field_70180_af.func_187227_b(EAT_COUNTER, (Object)(p_213534_1_ ? 1 : 0));
    }

    private void spitOutItem(ItemStack stackIn) {
        if (!stackIn.func_190926_b() && !this.field_70170_p.field_72995_K) {
            ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + this.func_70040_Z().field_72450_a, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + this.func_70040_Z().field_72449_c, stackIn);
            itementity.func_174867_a(40);
            itementity.func_200216_c(this.func_110124_au());
            this.field_70170_p.func_217376_c((Entity)itementity);
        }
    }

    private void spawnItem(ItemStack stackIn) {
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stackIn);
        this.field_70170_p.func_217376_c((Entity)itementity);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        if (!this.func_70909_n() && this.eatCooldownTicks <= 0 && this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() && itemEntity.func_92059_d().func_222117_E() && itemEntity.func_92059_d().func_77973_b().func_219967_s().func_221467_c()) {
            ItemStack itemstack = itemEntity.func_92059_d();
            int i = itemstack.func_190916_E();
            if (i > 1) {
                this.spawnItem(itemstack.func_77979_a(i - 1));
            }
            this.spitOutItem(this.func_184582_a(EquipmentSlotType.MAINHAND));
            this.func_233630_a_(itemEntity);
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack.func_77979_a(1));
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
            this.eatCooldownTicks = 1200;
        }
    }

    @Inject(method={"setTamed"}, at={@At(value="HEAD")}, cancellable=true)
    public void setTamed(boolean tamed, CallbackInfo info) {
        super.func_70903_f(tamed);
        if (tamed && this.func_110148_a(Attributes.field_233823_f_).func_111125_b() < 20.0) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
            this.func_70606_j(this.func_110138_aP());
        }
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(4.0);
        info.cancel();
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (worldIn.func_226691_t_(this.func_233580_cy_()).func_225486_c(this.func_233580_cy_()) <= 0.15f) {
            this.setWolfType(0);
        } else {
            this.setWolfType(this.field_70146_Z.nextInt(2));
        }
        if (reason != SpawnReason.BREEDING && reason != SpawnReason.STRUCTURE && reason != SpawnReason.COMMAND && reason != SpawnReason.SPAWN_EGG) {
            if (spawnDataIn == null) {
                spawnDataIn = new GroupData(this);
                this.addLeaderUUID(this.func_110124_au());
            } else {
                this.addLeaderUUID(((GroupData)((Object)spawnDataIn)).groupLeader.func_110124_au());
                if (((GroupData)((Object)spawnDataIn)).groupLeader instanceof IWolfType) {
                    this.setWolfType(((IWolfType)((GroupData)((Object)spawnDataIn)).groupLeader).getWolfType());
                }
            }
        }
        if (!this.func_70909_n() && this.isLeader()) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(10.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(4.0);
            this.func_70606_j(this.func_110138_aP());
        }
        return spawnDataIn;
    }

    @Override
    public void setHowling(boolean howling) {
        if (howling) {
            this.howlAnimationProgress = 0.0f;
            this.lastHowlAnimationProgress = 0.0f;
        }
        this.field_70180_af.func_187227_b(HOWLING, (Object)howling);
    }

    @Override
    public boolean isHowling() {
        return (Boolean)this.field_70180_af.func_187225_a(HOWLING);
    }

    @Override
    public float getHowlAnimationProgress(float delta) {
        return this.lastHowlAnimationProgress + (this.howlAnimationProgress - this.lastHowlAnimationProgress) * delta;
    }

    @Inject(method={"func_241840_a"}, at={@At(value="HEAD")}, cancellable=true)
    public void func_241840_a(ServerWorld p_241840_1_, AgeableEntity ageable, CallbackInfoReturnable<WolfEntity> callbackInfo) {
        WolfEntity wolfentity = (WolfEntity)EntityType.field_200724_aC.func_200721_a(this.field_70170_p);
        if (ageable instanceof WolfEntity && ageable instanceof IWolfType && wolfentity instanceof IWolfType) {
            if (this.field_70146_Z.nextBoolean()) {
                ((IWolfType)wolfentity).setWolfType(this.getWolfType());
            } else {
                ((IWolfType)wolfentity).setWolfType(((IWolfType)ageable).getWolfType());
            }
            if (this.func_70909_n()) {
                UUID uuid = this.func_184753_b();
                if (uuid != null) {
                    wolfentity.func_184754_b(this.func_184753_b());
                    wolfentity.func_70903_f(true);
                }
                if (this.field_70146_Z.nextBoolean()) {
                    wolfentity.func_175547_a(this.func_175546_cu());
                } else {
                    wolfentity.func_175547_a(((WolfEntity)ageable).func_175546_cu());
                }
            }
        }
        callbackInfo.setReturnValue((Object)wolfentity);
        callbackInfo.cancel();
    }

    @Shadow
    public DyeColor func_175546_cu() {
        return null;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!keepData && this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }
}

