/*
 * Decompiled with CFR 0.152.
 */
package appleting.classes.blocks;

import appleting.classes.blocks.TileEntityBlock;
import appleting.classes.tile_entites.EnchantedBookTileEntity;
import appleting.registries.RegisterBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnchantedBookBlock
extends TileEntityBlock {
    public EnchantedBookBlock(Block.Properties properties) {
        super(RegisterBlocks.Shapes.BOOK, properties);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new EnchantedBookTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        VoxelShape voxelshape = this.func_220053_a(stateIn, (IBlockReader)worldIn, pos, ISelectionContext.func_216377_a());
        Vec3d vec3d = voxelshape.func_197752_a().func_189972_c();
        double d0 = (double)pos.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)pos.func_177952_p() + vec3d.field_72449_c;
        for (int i = 0; i < 3; ++i) {
            if (!rand.nextBoolean()) continue;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197623_p, d0 + (double)(rand.nextFloat() / 5.0f), (double)pos.func_177956_o() + (0.5 - (double)rand.nextFloat()), d1 + (double)(rand.nextFloat() / 5.0f), 0.0, 0.0, 0.0);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof EnchantedBookTileEntity) {
            ((EnchantedBookTileEntity)tileentity).setBook(stack.func_77946_l());
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity;
        if (state != newState && (tileentity = world.func_175625_s(pos)) instanceof EnchantedBookTileEntity) {
            EnchantedBookBlock.dropItem(world, pos, EnchantedBookBlock.getBookStack(world, pos));
            ((EnchantedBookTileEntity)tileentity).clear();
        }
    }

    private static ItemStack getBookStack(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof EnchantedBookTileEntity) {
            ItemStack book = ((EnchantedBookTileEntity)tileentity).getBook().func_77946_l();
            book.func_190920_e(1);
            return book;
        }
        return new ItemStack((IItemProvider)Items.field_151168_bH);
    }
}

