/*
 * Decompiled with CFR 0.152.
 */
package appleting.classes.blocks;

import appleting.classes.blocks.TileEntityBlock;
import appleting.classes.tile_entites.FireworkRocketTileEntity;
import appleting.registries.RegisterBlocks;
import appleting.registries.RegisterItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class FireworkRocketBlock
extends TileEntityBlock {
    public FireworkRocketBlock(Block.Properties properties) {
        super(RegisterBlocks.Shapes.FIREWORK, properties);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        this.activateFirework(pos, world);
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (world.func_175640_z(pos) || world.func_175640_z(pos.func_177984_a())) {
            this.activateFirework(pos, world);
        }
    }

    private void activateFirework(BlockPos pos, World world) {
        if (!world.field_72995_K) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof FireworkRocketTileEntity) {
                ((FireworkRocketTileEntity)tileentity).setCanDropFalse();
                this.summonEntity(pos, world, this.getFireWorkStack(world, pos));
                ((FireworkRocketTileEntity)tileentity).clear();
            } else {
                ItemStack stack = new ItemStack((IItemProvider)Items.field_190931_a);
                this.summonEntity(pos, world, stack);
            }
        }
    }

    private void summonEntity(BlockPos pos, World world, ItemStack rocket) {
        world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        world.func_217376_c((Entity)new FireworkRocketEntity(world, (double)pos.func_177958_n() + 0.5 + (double)Direction.UP.func_82601_c() * 0.15, (double)pos.func_177956_o() + (double)Direction.UP.func_96559_d() * 0.15, (double)pos.func_177952_p() + 0.5 + (double)Direction.UP.func_82599_e() * 0.15, rocket));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof FireworkRocketTileEntity) {
            ((FireworkRocketTileEntity)tileentity).setFirework(stack.func_77946_l());
            ((FireworkRocketTileEntity)tileentity).setCanDropTrue();
        }
    }

    private ItemStack getFireWorkStack(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof FireworkRocketTileEntity) {
            ItemStack firework = ((FireworkRocketTileEntity)tileentity).getFirework().func_77946_l();
            firework.func_190920_e(1);
            try {
                return firework;
            }
            catch (Exception e) {
                return new ItemStack((IItemProvider)RegisterItems.firework_rocket);
            }
        }
        return new ItemStack((IItemProvider)RegisterItems.firework_rocket);
    }

    private boolean canDrop(World world, BlockPos pos) {
        if (world.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof FireworkRocketTileEntity) {
                return ((FireworkRocketTileEntity)tileentity).getCanDrop();
            }
            return true;
        }
        return false;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new FireworkRocketTileEntity();
    }
}

