/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.detail;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.BlockItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.event.ColorHandlerEvent;
import wile.rsgauges.ModContent;
import wile.rsgauges.ModRsGauges;

public final class ModColors {
    public static final void registerBlockColourHandlers(ColorHandlerEvent.Block event) {
        IBlockColor blockSpecifiedColorHandler = (state, world, pos, tintIndex) -> ((ColorTintSupport)state.func_177230_c()).getColorMultiplierRGBA(state, world, pos);
        BlockColors bc = event.getBlockColors();
        int n = 0;
        for (Block e : ModContent.getRegisteredBlocks()) {
            if (!(e instanceof ColorTintSupport) || !((ColorTintSupport)e).hasColorMultiplierRGBA()) continue;
            bc.func_186722_a(blockSpecifiedColorHandler, new Block[]{e});
            ++n;
        }
        ModRsGauges.logger().info("Registered " + Integer.toString(n) + " block color handlers.");
    }

    public static final void registerItemColourHandlers(ColorHandlerEvent.Item event) {
        ItemColors ic = event.getItemColors();
        IItemColor constantBlockColorHandler = (stack, tintIndex) -> ((ColorTintSupport)((BlockItem)stack.func_77973_b()).func_179223_d()).getColorMultiplierRGBA(null, null, null);
        for (Block e : ModContent.getRegisteredBlocks()) {
            if (!(e instanceof ColorTintSupport) || !((ColorTintSupport)e).hasColorMultiplierRGBA()) continue;
            ic.func_199877_a(constantBlockColorHandler, new IItemProvider[]{e});
        }
    }

    public static interface ColorTintSupport {
        default public boolean hasColorMultiplierRGBA() {
            return false;
        }

        default public int getColorMultiplierRGBA(@Nullable BlockState state, @Nullable IEnviromentBlockReader world, @Nullable BlockPos pos) {
            return -1;
        }
    }
}

