/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import wile.rsgauges.blocks.BlockIntervalTimerSwitch;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.items.ItemSwitchLinkPearl;

public abstract class BlockAutoSwitch
extends BlockSwitch {
    public BlockAutoSwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public BlockAutoSwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
    }

    @Override
    public boolean onLinkRequest(ItemSwitchLinkPearl.SwitchLink link, long req, World world, BlockPos pos, @Nullable PlayerEntity player) {
        if (world == null || (this.config & 0x200000000000000L) == 0L || world.field_72995_K) {
            return false;
        }
        if ((this.config & 0x200000000L) == 0L) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (state == null || !(state.func_177230_c() instanceof BlockAutoSwitch)) {
            return false;
        }
        TileEntityAutoSwitch te = this.getTe((IWorldReader)world, pos);
        if (te == null || !te.check_link_request(link)) {
            return false;
        }
        te.updateSwitchState(state, this, (Boolean)state.func_177229_b((IProperty)POWERED) == false, 0);
        return true;
    }

    @Override
    public TileEntityAutoSwitch getTe(IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityAutoSwitch)) {
            return null;
        }
        return (TileEntityAutoSwitch)te;
    }

    public static abstract class TileEntityAutoSwitch
    extends BlockSwitch.TileEntitySwitch {
        public TileEntityAutoSwitch(TileEntityType<?> te_type) {
            super(te_type);
        }

        protected final void updateSwitchState(BlockState state, BlockAutoSwitch block, boolean active, int hold_time) {
            if (active) {
                this.on_timer_reset(hold_time);
                if (!((Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED)).booleanValue()) {
                    if (this instanceof BlockIntervalTimerSwitch.TileEntityIntervalTimerSwitch) {
                        ((BlockIntervalTimerSwitch.TileEntityIntervalTimerSwitch)this).restart();
                    }
                    state = (BlockState)state.func_206870_a((IProperty)BlockSwitch.POWERED, (Comparable)Boolean.valueOf(true));
                    this.field_145850_b.func_180501_a(this.field_174879_c, state, 3);
                    block.power_on_sound.play(this.field_145850_b, this.field_174879_c);
                    this.field_145850_b.func_195593_d(this.field_174879_c, (Block)block);
                    this.field_145850_b.func_195593_d(this.field_174879_c.func_177972_a(((Direction)state.func_177229_b((IProperty)RsDirectedBlock.FACING)).func_176734_d()), (Block)block);
                    if ((block.config & 0x100000000000000L) != 0L && !this.activate_links(1)) {
                        ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(this.field_145850_b, this.field_174879_c);
                    }
                }
            } else if (((Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED)).booleanValue() && (hold_time <= 0 || this.on_time_remaining() <= 0)) {
                state = (BlockState)state.func_206870_a((IProperty)BlockSwitch.POWERED, (Comparable)Boolean.valueOf(false));
                this.field_145850_b.func_175656_a(this.field_174879_c, state);
                block.power_off_sound.play(this.field_145850_b, this.field_174879_c);
                this.field_145850_b.func_195593_d(this.field_174879_c, (Block)block);
                this.field_145850_b.func_195593_d(this.field_174879_c.func_177972_a(((Direction)state.func_177229_b((IProperty)RsDirectedBlock.FACING)).func_176734_d()), (Block)block);
                if ((block.config & 0x100000000000000L) != 0L && !this.activate_links(2)) {
                    ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(this.field_145850_b, this.field_174879_c);
                }
            }
        }
    }
}

