/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.BlockAutoSwitch;
import wile.rsgauges.blocks.BlockEnvironmentalSensorSwitch;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModResources;

public class BlockDayTimerSwitch
extends BlockAutoSwitch {
    public BlockDayTimerSwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public BlockDayTimerSwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityDayTimerSwitch(ModContent.TET_DAYTIMER_SWITCH);
    }

    public static class TileEntityDayTimerSwitch
    extends BlockEnvironmentalSensorSwitch.TileEntityEnvironmentalSensorSwitch
    implements ITickableTileEntity {
        public TileEntityDayTimerSwitch(TileEntityType<?> te_type) {
            super(te_type);
        }

        public TileEntityDayTimerSwitch() {
            super(ModContent.TET_DAYTIMER_SWITCH);
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable PlayerEntity player, double x, double y) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            BlockSwitch block = (BlockSwitch)state.func_177230_c();
            int n = y >= 13.0 ? 1 : (direction = y <= 2.0 ? -1 : 0);
            int n2 = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (field = x >= 11.0 && x <= 13.0 ? 4 : 0)));
            if (direction == 0 || field == 0) {
                return false;
            }
            double time_scaling = 0.3125;
            switch (field) {
                case 1: {
                    double v = this.threshold0_on() + 0.3125 * (double)direction;
                    if (v < 0.0) {
                        v += 15.0;
                    } else if (v > 15.0) {
                        v = 0.0;
                    }
                    this.threshold0_on(v);
                    break;
                }
                case 2: {
                    double v = this.threshold0_off() + 0.3125 * (double)direction;
                    if (v < 0.0) {
                        v += 15.0;
                    } else if (v > 15.0) {
                        v = 0.0;
                    }
                    this.threshold0_off(v);
                    break;
                }
                case 3: {
                    this.debounce(this.debounce() + direction);
                    break;
                }
                case 4: {
                    this.on_power(this.on_power() + direction);
                }
            }
            if (this.on_power() < 1) {
                this.on_power(1);
            }
            StringTextComponent separator = new StringTextComponent(" | ");
            separator.func_150256_b().func_150238_a(TextFormatting.GRAY);
            ArrayList<Object> tr = new ArrayList<Object>();
            tr.add(ModAuxiliaries.localizable("switchconfig.daytimerclock.daytime_on", TextFormatting.BLUE, ModAuxiliaries.daytimeToString((long)(this.threshold0_on() * 24000.0 / 15.0))));
            tr.add(separator.func_212638_h().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.daytimerclock.daytime_off", TextFormatting.YELLOW, ModAuxiliaries.daytimeToString((long)(this.threshold0_off() * 24000.0 / 15.0)))));
            tr.add(separator.func_212638_h().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.daytimerclock.output_power", TextFormatting.RED, this.on_power())));
            if (this.debounce() > 0) {
                tr.add(separator.func_212638_h().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.daytimerclock.random", TextFormatting.DARK_GREEN, this.debounce())));
            } else {
                tr.add(new StringTextComponent(""));
            }
            tr.add(separator.func_212638_h().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.daytimerclock.output_power", TextFormatting.RED, this.on_power())));
            ModAuxiliaries.playerStatusMessage(player, (ITextComponent)ModAuxiliaries.localizable("switchconfig.daytimerclock", TextFormatting.RESET, tr.toArray()));
            this.func_70296_d();
            return true;
        }

        @Override
        public void func_73660_a() {
            boolean active_setpoint;
            if (ModConfig.without_environmental_switch_update) {
                return;
            }
            if (!this.func_145830_o() || this.func_145831_w().field_72995_K || --this.update_timer_ > 0) {
                return;
            }
            if (this.update_interval_ < 10) {
                this.update_interval_ = 10;
            }
            this.update_timer_ = this.update_interval_ + (int)(Math.random() * 5.0);
            BlockState state = this.func_195044_w();
            if (!(state.func_177230_c() instanceof BlockDayTimerSwitch)) {
                return;
            }
            boolean active = (Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED);
            long wt = this.field_145850_b.func_72820_D() % 24000L;
            double t = 6.25E-4 * (double)wt;
            if (this.threshold0_on() == this.threshold0_off()) {
                active_setpoint = false;
            } else if (this.threshold0_on() < this.threshold0_off()) {
                active_setpoint = t >= this.threshold0_on() && t <= this.threshold0_off();
            } else {
                boolean bl = active_setpoint = t >= this.threshold0_on() && t <= 15.0 || t >= 0.0 && t <= this.threshold0_off();
            }
            if (active != active_setpoint) {
                if (this.debounce() <= 0) {
                    active = active_setpoint;
                } else {
                    double d1 = (1.0 - (double)this.debounce() / 9.0) * 0.7;
                    d1 *= d1;
                    if (Math.random() <= d1) {
                        active = active_setpoint;
                    }
                }
            }
            this.updateSwitchState(state, (BlockDayTimerSwitch)state.func_177230_c(), active, 0);
        }
    }
}

