/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModResources;

public class BlockDimmerSwitch
extends BlockSwitch {
    public static final IntegerProperty POWER = IntegerProperty.func_177719_a((String)"power", (int)0, (int)15);

    public BlockDimmerSwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config | 0xFFL, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{POWER});
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        boolean was_powered;
        if (!(state.func_177230_c() instanceof BlockDimmerSwitch)) {
            return ActionResultType.FAIL;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockSwitch.TileEntitySwitch te = this.getTe((IWorldReader)world, pos);
        if (te == null) {
            return ActionResultType.FAIL;
        }
        te.click_config(null, false);
        BlockSwitch.ClickInteraction ck = BlockSwitch.ClickInteraction.get(state, world, pos, player, hand, hit);
        boolean bl = was_powered = te.on_power() != 0;
        if (ck.touch_configured) {
            int p = (int)ck.y;
            if (p != te.on_power()) {
                te.on_power(p);
                p = te.on_power();
                ModAuxiliaries.playerStatusMessage(player, (ITextComponent)ModAuxiliaries.localizable("switchconfig.dimmerswitch.output_power", TextFormatting.RED, p));
                int state_p = (Integer)state.func_177229_b((IProperty)POWER);
                if (state_p != p) {
                    world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(p))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(p > 0)), 3);
                    this.notifyNeighbours(world, pos, state, te, false);
                    te.func_70296_d();
                }
                if (was_powered && p == 0) {
                    this.power_off_sound.play(world, pos);
                } else {
                    this.power_on_sound.play(world, pos);
                }
                if (was_powered == (p == 0) && (this.config & 0x100000000000000L) != 0L && !was_powered && !te.activate_links(1)) {
                    ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (ck.wrenched && te.click_config(this, false)) {
            ModAuxiliaries.playerStatusMessage(player, (ITextComponent)te.configStatusTextComponentTranslation((BlockSwitch)state.func_177230_c()));
        }
        return ActionResultType.SUCCESS;
    }
}

