/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.BlockAutoSwitch;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModResources;

public class BlockIntervalTimerSwitch
extends BlockAutoSwitch {
    public BlockIntervalTimerSwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public BlockIntervalTimerSwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityIntervalTimerSwitch(ModContent.TET_TIMER_SWITCH);
    }

    public static class TileEntityIntervalTimerSwitch
    extends BlockAutoSwitch.TileEntityAutoSwitch
    implements ITickableTileEntity {
        private static final int ramp_max = 5;
        private static final int t_max = 12000;
        private static final int t_min = 5;
        private int p_set_ = 15;
        private int t_on_ = 20;
        private int t_off_ = 20;
        private int ramp_ = 0;
        private int update_timer_ = 0;
        private int p_ = 0;
        private boolean s_ = false;

        public TileEntityIntervalTimerSwitch(TileEntityType<?> te_type) {
            super(te_type);
        }

        public TileEntityIntervalTimerSwitch() {
            super(ModContent.TET_TIMER_SWITCH);
        }

        public void restart() {
            this.update_timer_ = 0;
            this.p_ = 0;
            this.s_ = false;
        }

        public int p_set() {
            return this.p_set_;
        }

        public int t_on() {
            return this.t_on_;
        }

        public int t_off() {
            return this.t_off_;
        }

        public int ramp() {
            return this.ramp_;
        }

        public void p_set(int v) {
            this.p_set_ = v < 1 ? 1 : (v > 15 ? 15 : v);
        }

        public void t_on(int v) {
            this.t_on_ = v < 0 ? 0 : (v > 12000 ? 12000 : v);
        }

        public void t_off(int v) {
            this.t_off_ = v < 0 ? 0 : (v > 12000 ? 12000 : v);
        }

        public void ramp(int v) {
            this.ramp_ = v < 0 ? 0 : (v > 5 ? 5 : v);
        }

        @Override
        public void writeNbt(CompoundNBT nbt, boolean updatePacket) {
            super.writeNbt(nbt, updatePacket);
            nbt.func_74768_a("pset", this.p_set());
            nbt.func_74768_a("toff", this.t_off());
            nbt.func_74768_a("ton", this.t_on());
            nbt.func_74768_a("ramp", this.ramp());
        }

        @Override
        public void readNbt(CompoundNBT nbt, boolean updatePacket) {
            super.readNbt(nbt, updatePacket);
            this.p_set(nbt.func_74762_e("pset"));
            this.t_off(nbt.func_74762_e("toff"));
            this.t_on(nbt.func_74762_e("ton"));
            this.ramp(nbt.func_74762_e("ramp"));
        }

        private int next_higher_interval_setting(int ticks) {
            ticks = ticks < 100 ? (ticks += 5) : (ticks < 200 ? (ticks += 10) : (ticks < 400 ? (ticks += 20) : (ticks < 600 ? (ticks += 40) : (ticks < 800 ? (ticks += 100) : (ticks < 2400 ? (ticks += 200) : (ticks += 600))))));
            return ticks > 12000 ? 12000 : ticks;
        }

        private int next_lower_interval_setting(int ticks) {
            ticks = ticks < 100 ? (ticks -= 5) : (ticks < 200 ? (ticks -= 10) : (ticks < 400 ? (ticks -= 20) : (ticks < 600 ? (ticks -= 40) : (ticks < 800 ? (ticks -= 100) : (ticks < 2400 ? (ticks -= 200) : (ticks -= 600))))));
            return ticks < 5 ? 5 : ticks;
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable PlayerEntity player, double x, double y) {
            boolean selected;
            int direction;
            if (state == null || !(state.func_177230_c() instanceof BlockSwitch)) {
                return false;
            }
            int n = y >= 13.0 ? 1 : (direction = y <= 2.0 ? -1 : 0);
            int field = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (x >= 11.0 && x <= 13.0 ? 4 : 0)));
            boolean bl = selected = direction != 0 && field != 0;
            if (selected) {
                switch (field) {
                    case 1: {
                        this.t_on(direction > 0 ? this.next_higher_interval_setting(this.t_on()) : this.next_lower_interval_setting(this.t_on()));
                        break;
                    }
                    case 2: {
                        this.t_off(direction > 0 ? this.next_higher_interval_setting(this.t_off()) : this.next_lower_interval_setting(this.t_off()));
                        break;
                    }
                    case 3: {
                        this.ramp(this.ramp() + direction);
                        break;
                    }
                    case 4: {
                        this.p_set((this.p_set() <= 0 ? 15 : this.p_set()) + direction);
                    }
                }
                this.func_70296_d();
            }
            boolean switch_state = (Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED);
            if (!selected) {
                switch_state = !switch_state;
            }
            this.updateSwitchState(state, (BlockAutoSwitch)state.func_177230_c(), switch_state, 0);
            StringTextComponent separator = new StringTextComponent(" | ");
            separator.func_150256_b().func_150238_a(TextFormatting.GRAY);
            ArrayList<Object> tr = new ArrayList<Object>();
            tr.add(ModAuxiliaries.localizable("switchconfig.intervaltimer.t_on", TextFormatting.BLUE, ModAuxiliaries.ticksToSecondsString(this.t_on())));
            tr.add(separator.func_212638_h().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.intervaltimer.t_off", TextFormatting.YELLOW, ModAuxiliaries.ticksToSecondsString(this.t_off()))));
            tr.add(separator.func_212638_h().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.intervaltimer.output_power", TextFormatting.RED, this.p_set())));
            if (this.ramp() > 0) {
                tr.add(separator.func_212638_h().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.intervaltimer.ramp", TextFormatting.DARK_GREEN, this.ramp())));
            }
            if (!switch_state) {
                tr.add(separator.func_212638_h().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.intervaltimer.standby", TextFormatting.AQUA, new Object[0])));
            }
            while (tr.size() < 5) {
                tr.add(new StringTextComponent(""));
            }
            ModAuxiliaries.playerStatusMessage(player, (ITextComponent)ModAuxiliaries.localizable("switchconfig.intervaltimer", TextFormatting.RESET, tr.toArray()));
            return selected;
        }

        @Override
        public int power(BlockState state, boolean strong) {
            return this.nooutput() || (Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED) == false || strong && this.weak() ? 0 : this.on_power();
        }

        public void func_73660_a() {
            if (ModConfig.without_timer_switch_update || !this.func_145830_o() || this.func_145831_w().field_72995_K || --this.update_timer_ > 0) {
                return;
            }
            int p = this.p_;
            if (this.t_on() <= 0 || this.t_off() <= 0 || this.p_set() <= 0) {
                this.p_ = 0;
                this.update_timer_ = 20;
            } else if (!this.s_) {
                this.update_timer_ = this.t_on();
                if (this.ramp() <= 0 || (this.p_ += this.ramp()) >= this.p_set()) {
                    this.p_ = this.p_set();
                    this.s_ = true;
                } else {
                    this.update_timer_ = 5;
                }
            } else {
                this.update_timer_ = this.t_off();
                if (this.ramp() <= 0 || (this.p_ -= this.ramp()) <= 0) {
                    this.p_ = 0;
                    this.s_ = false;
                } else {
                    this.update_timer_ = 5;
                }
            }
            if (p != this.p_) {
                this.on_power(this.inverted() ? 15 - this.p_ : this.p_);
                BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                if (state == null || !(state.func_177230_c() instanceof BlockAutoSwitch) || !((Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED)).booleanValue()) {
                    this.update_timer_ = 200 + (int)(Math.random() * 10.0);
                    this.on_power(this.inverted() ? 15 : 0);
                }
                this.field_145850_b.func_195593_d(this.field_174879_c, state.func_177230_c());
                this.field_145850_b.func_195593_d(this.field_174879_c.func_177972_a(((Direction)state.func_177229_b((IProperty)RsDirectedBlock.FACING)).func_176734_d()), state.func_177230_c());
            }
        }
    }
}

