/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.rsgauges.ModConfig;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModColors;

public abstract class RsBlock
extends Block
implements ModColors.ColorTintSupport,
IWaterLoggable {
    public static final long RSBLOCK_CONFIG_SOLID = 0L;
    public static final long RSBLOCK_CONFIG_CUTOUT = 0x1000000000000000L;
    public static final long RSBLOCK_CONFIG_CUTOUT_MIPPED = 0x2000000000000000L;
    public static final long RSBLOCK_CONFIG_TRANSLUCENT = 0x3000000000000000L;
    public static final long RSBLOCK_CONFIG_COLOR_TINT_SUPPORT = 0x4000000000000L;
    public static final long RSBLOCK_NOT_WATERLOGGABLE = 0x8000000000000L;
    private static final RenderTypeHint[] render_layer_map_ = new RenderTypeHint[]{RenderTypeHint.SOLID, RenderTypeHint.CUTOUT, RenderTypeHint.CUTOUT_MIPPED, RenderTypeHint.TRANSLUCENT};
    public final long config;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public RsBlock(long config, Block.Properties properties) {
        this(config, properties, ModAuxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0));
    }

    public RsBlock(long config, Block.Properties properties, AxisAlignedBB aabb) {
        this(config, properties, VoxelShapes.func_197881_a((AxisAlignedBB)aabb));
    }

    public RsBlock(long config, Block.Properties properties, VoxelShape vshape) {
        super(properties);
        this.config = config;
    }

    public RenderTypeHint getRenderTypeHint() {
        return render_layer_map_[(int)(this.config >> 60 & 3L)];
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        ModAuxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasCustomBreakingProgress(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.func_220053_a(state, world, pos, selectionContext);
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_181623_g() {
        return false;
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{WATERLOGGED});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = (BlockState)super.func_196258_a(context).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        if ((this.config & 0x8000000000000L) == 0L) {
            IFluidState fs = context.func_195991_k().func_204610_c(context.func_195995_a());
            state = (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fs.func_206886_c() == Fluids.field_204546_a));
        }
        return state;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (this.config & 0x8000000000000L) == 0L ? (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue() ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state)) : super.func_204507_t(state);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        if ((this.config & 0x8000000000000L) == 0L && ((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            return false;
        }
        return super.func_200123_i(state, reader, pos);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c() && state.func_177230_c() instanceof RsBlock) {
            AxisAlignedBB aabb;
            RsBlock block = (RsBlock)state.func_177230_c();
            if (state.hasTileEntity()) {
                block.onRsBlockDestroyed(state, world, pos, false);
                world.func_175713_t(pos);
                world.func_175666_e(pos, (Block)this);
                world.func_195592_c(pos, state.func_177230_c());
            }
            if (newState.func_177230_c() == Blocks.field_150355_j && (aabb = block.func_220053_a(state, (IBlockReader)world, pos, ISelectionContext.func_216377_a()).func_197752_a()).func_216364_b() * aabb.func_216360_c() * aabb.func_216362_d() >= 0.6) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Collections.singletonList(new ItemStack((IItemProvider)state.func_177230_c().func_199767_j()));
    }

    public boolean hasTileEntity(BlockState state) {
        return false;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return ActionResultType.PASS;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rnd) {
    }

    public int func_149750_m(BlockState state) {
        return super.func_149750_m(state);
    }

    @Override
    public boolean hasColorMultiplierRGBA() {
        return !ModConfig.without_color_tinting && (this.config & 0x4000000000000L) != 0L;
    }

    @Override
    public int getColorMultiplierRGBA(@Nullable BlockState state, @Nullable ILightReader world, @Nullable BlockPos pos) {
        if (!(world instanceof IWorldReader)) {
            return -1;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof RsTileEntity)) {
            return -1;
        }
        return ModAuxiliaries.DyeColorFilters.lightTintByIndex(((RsTileEntity)te).color_tint());
    }

    protected void onRsBlockDestroyed(BlockState state, World world, BlockPos pos, boolean isUpdateEvent) {
    }

    protected boolean onBlockPlacedByCheck(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        return true;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if ((this.config & 0x8000000000000L) == 0L && ((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return state;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.neighborUpdated(state, world, pos, fromPos);
    }

    protected void neighborUpdated(BlockState state, World world, BlockPos pos, BlockPos facingPos) {
    }

    public static abstract class RsTileEntity
    extends TileEntity {
        private static final int NBT_ENTITY_TYPE = 1;

        public RsTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public void writeNbt(CompoundNBT nbt, boolean updatePacket) {
        }

        public void readNbt(CompoundNBT nbt, boolean updatePacket) {
        }

        public int color_tint() {
            return -1;
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writeNbt(nbt, false);
            return nbt;
        }

        public void func_145839_a(CompoundNBT nbt) {
            super.func_145839_a(nbt);
            this.readNbt(nbt, false);
        }
    }

    public static enum RenderTypeHint {
        SOLID,
        CUTOUT,
        CUTOUT_MIPPED,
        TRANSLUCENT;

    }
}

