/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.detail;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class OptionalRecipeCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("rsgauges", "optional");
    private final List<ResourceLocation> all_required;
    private final List<ResourceLocation> any_missing;
    @Nullable
    private final ResourceLocation result;

    public OptionalRecipeCondition(ResourceLocation result, List<ResourceLocation> required, List<ResourceLocation> missing) {
        this.all_required = required;
        this.any_missing = missing;
        this.result = result;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Optional recipe, all-required: [");
        for (ResourceLocation e : this.all_required) {
            sb.append(e.toString()).append(",");
        }
        sb.delete(sb.length() - 1, sb.length()).append("], any-missing: [");
        for (ResourceLocation e : this.any_missing) {
            sb.append(e.toString()).append(",");
        }
        sb.delete(sb.length() - 1, sb.length()).append("]");
        return sb.toString();
    }

    public boolean test() {
        IForgeRegistry block_registry = ForgeRegistries.BLOCKS;
        IForgeRegistry item_registry = ForgeRegistries.ITEMS;
        if (this.result != null && !block_registry.containsKey(this.result) && !item_registry.containsKey(this.result)) {
            return false;
        }
        if (!this.all_required.isEmpty()) {
            for (ResourceLocation rl : this.all_required) {
                if (block_registry.containsKey(rl) || item_registry.containsKey(rl)) continue;
                return false;
            }
        }
        if (!this.any_missing.isEmpty()) {
            for (ResourceLocation rl : this.any_missing) {
                if (block_registry.containsKey(rl) || item_registry.containsKey(rl)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static class Serializer
    implements IConditionSerializer<OptionalRecipeCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public ResourceLocation getID() {
            return NAME;
        }

        public void write(JsonObject json, OptionalRecipeCondition condition) {
            JsonArray required = new JsonArray();
            JsonArray missing = new JsonArray();
            for (ResourceLocation e : condition.all_required) {
                required.add(e.toString());
            }
            for (ResourceLocation e : condition.any_missing) {
                missing.add(e.toString());
            }
            json.add("required", (JsonElement)required);
            json.add("missing", (JsonElement)missing);
            if (condition.result != null) {
                json.addProperty("result", condition.result.toString());
            }
        }

        public OptionalRecipeCondition read(JsonObject json) {
            ArrayList<ResourceLocation> required = new ArrayList<ResourceLocation>();
            ArrayList<ResourceLocation> missing = new ArrayList<ResourceLocation>();
            ResourceLocation result = null;
            if (json.has("result")) {
                result = new ResourceLocation(json.get("result").getAsString());
            }
            if (json.has("required")) {
                for (JsonElement e : JSONUtils.func_151214_t((JsonObject)json, (String)"required")) {
                    required.add(new ResourceLocation(e.getAsString()));
                }
            }
            if (json.has("missing")) {
                for (JsonElement e : JSONUtils.func_151214_t((JsonObject)json, (String)"missing")) {
                    missing.add(new ResourceLocation(e.getAsString()));
                }
            }
            return new OptionalRecipeCondition(result, required, missing);
        }
    }
}

