/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges;

import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import wile.rsgauges.ModContent;
import wile.rsgauges.ModRsGauges;
import wile.rsgauges.blocks.BistableKnockSwitchBlock;
import wile.rsgauges.blocks.BistableSwitchBlock;
import wile.rsgauges.blocks.ComparatorSwitchBlock;
import wile.rsgauges.blocks.DimmerSwitchBlock;
import wile.rsgauges.blocks.DoorSensorSwitchBlock;
import wile.rsgauges.blocks.GaugeBlock;
import wile.rsgauges.blocks.IndicatorBlock;
import wile.rsgauges.blocks.LinkReceiverSwitchBlock;
import wile.rsgauges.blocks.LinkRelaySwitchBlock;
import wile.rsgauges.blocks.PulseKnockSwitchBlock;
import wile.rsgauges.blocks.PulseSwitchBlock;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.blocks.SensitiveGlassBlock;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.items.ItemSwitchLinkPearl;

public class ModConfig {
    private static final Logger LOGGER = ModRsGauges.logger();
    private static final String MODID = "rsgauges";
    public static final CommonConfig COMMON;
    public static final ServerConfig SERVER;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    public static final ForgeConfigSpec SERVER_CONFIG_SPEC;
    public static final ForgeConfigSpec CLIENT_CONFIG_SPEC;
    private static final CompoundNBT server_config_;
    private static HashSet<String> optouts_;
    public static boolean status_overlay_disabled;
    public static boolean without_switch_linking;
    public static boolean without_color_tinting;
    public static boolean without_detector_switch_update;
    public static boolean without_environmental_switch_update;
    public static boolean without_timer_switch_update;
    public static boolean without_gauge_weak_power_measurement;
    public static boolean without_pulsetime_config;
    public static boolean without_switch_nooutput;
    public static boolean without_indicators;
    public static boolean without_blinking_indicators;
    public static boolean without_sound_indicators;
    public static boolean without_gauges;
    public static boolean without_bistable_switches;
    public static boolean without_pulse_switches;
    public static boolean without_contact_switches;
    public static boolean without_automatic_switches;
    public static boolean without_linkrelay_switches;
    public static boolean without_decorative;
    public static boolean without_analog_switches;
    public static boolean without_rightclick_item_switchconfig;
    public static int max_switch_linking_distance;
    public static int autoswitch_linear_update_interval;
    public static int autoswitch_volumetric_update_interval;
    public static int gauge_update_interval;
    public static int config_left_click_timeout;
    public static double switch_status_overlay_y;
    public static String accepted_wrenches;
    public static boolean with_experimental;

    public static void onLoad(net.minecraftforge.fml.config.ModConfig config) {
        try {
            LOGGER.info("Loading config file {}", (Object)config.getFileName());
            ModConfig.apply();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to apply config file data {}", (Object)config.getFileName());
        }
    }

    public static void onFileChange(net.minecraftforge.fml.config.ModConfig config) {
        try {
            LOGGER.info("Config file changed {}", (Object)config.getFileName());
            ModConfig.apply();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to apply config file data {}", (Object)config.getFileName());
        }
    }

    public static final boolean isOptedOut(@Nullable Block block) {
        return ModConfig.isOptedOut(block.func_199767_j());
    }

    public static final boolean isOptedOut(@Nullable Item item) {
        return item != null && optouts_.contains(item.getRegistryName().func_110623_a());
    }

    public static boolean withExperimental() {
        return with_experimental;
    }

    public static final CompoundNBT getServerConfig() {
        return server_config_;
    }

    private static final void updateOptouts() {
        int i;
        ArrayList<String> includes_ = new ArrayList<String>();
        ArrayList<String> excludes_ = new ArrayList<String>();
        String inc = ((String)ModConfig.SERVER.pattern_includes.get()).toLowerCase().replaceAll("rsgauges:", "").replaceAll("[^*_,a-z0-9]", "");
        if (ModConfig.SERVER.pattern_includes.get() != inc) {
            ModConfig.SERVER.pattern_includes.set((Object)inc);
        }
        if (!inc.isEmpty()) {
            LOGGER.info("Config pattern includes: '" + inc + "'");
        }
        String[] incl = inc.split(",");
        includes_.clear();
        for (i = 0; i < incl.length; ++i) {
            incl[i] = incl[i].replaceAll("[*]", ".*?");
            if (incl[i].isEmpty()) continue;
            includes_.add(incl[i]);
        }
        String exc = ((String)ModConfig.SERVER.pattern_excludes.get()).toLowerCase().replaceAll("rsgauges:", "").replaceAll("[^*_,a-z0-9]", "");
        if (!exc.isEmpty()) {
            LOGGER.info("Config pattern excludes: '" + exc + "'");
        }
        String[] excl = exc.split(",");
        excludes_.clear();
        for (i = 0; i < excl.length; ++i) {
            excl[i] = excl[i].replaceAll("[*]", ".*?");
            if (excl[i].isEmpty()) continue;
            excludes_.add(excl[i]);
        }
        boolean with_log_details = false;
        HashSet optouts = new HashSet();
        ModContent.getRegisteredItems().stream().filter(item -> {
            if (item == null) {
                return true;
            }
            return without_switch_linking && item instanceof ItemSwitchLinkPearl;
        }).forEach(e -> optouts.add(e.getRegistryName().func_110623_a()));
        ModContent.getRegisteredBlocks().stream().filter(block -> {
            if (block == null) {
                return true;
            }
            try {
                RsDirectedBlock bl;
                if (!((Boolean)ModConfig.SERVER.with_experimental.get()).booleanValue()) {
                    if (block instanceof ModAuxiliaries.IExperimentalFeature) {
                        return true;
                    }
                    if (ModContent.isExperimentalBlock(block)) {
                        return true;
                    }
                }
                String rn = block.getRegistryName().func_110623_a();
                try {
                    for (String e : includes_) {
                        if (!rn.matches(e)) continue;
                        if (with_log_details) {
                            LOGGER.info("Optout force include: " + rn);
                        }
                        return false;
                    }
                    for (String e : excludes_) {
                        if (!rn.matches(e)) continue;
                        if (with_log_details) {
                            LOGGER.info("Optout force exclude: " + rn);
                        }
                        return true;
                    }
                }
                catch (Throwable ex) {
                    LOGGER.error("optout include pattern failed, disabling.");
                    includes_.clear();
                    excludes_.clear();
                }
                if (block instanceof IndicatorBlock) {
                    bl = (IndicatorBlock)block;
                    if (without_indicators) {
                        return true;
                    }
                    if (without_blinking_indicators && (bl.config & 0x100L) > 0L) {
                        return true;
                    }
                    if (without_sound_indicators && (bl.power_on_sound != null || bl.power_off_sound != null)) {
                        return true;
                    }
                }
                if (block instanceof GaugeBlock) {
                    bl = (GaugeBlock)block;
                    if (without_gauges) {
                        return true;
                    }
                } else if (block instanceof SwitchBlock) {
                    bl = (SwitchBlock)block;
                    if (without_bistable_switches && ((((SwitchBlock)bl).config & 0x10000000L) != 0L || bl instanceof BistableSwitchBlock)) {
                        return true;
                    }
                    if (without_pulse_switches && ((((SwitchBlock)bl).config & 0x20000000L) != 0L || bl instanceof PulseSwitchBlock)) {
                        return true;
                    }
                    if (without_contact_switches && (((SwitchBlock)bl).config & 0x40000000L) != 0L) {
                        return true;
                    }
                    if (without_analog_switches && bl instanceof DimmerSwitchBlock) {
                        return true;
                    }
                    if (without_linkrelay_switches && ((((SwitchBlock)bl).config & 0x400000000000000L) != 0L || bl instanceof LinkRelaySwitchBlock)) {
                        return true;
                    }
                    if (without_automatic_switches) {
                        if ((((SwitchBlock)bl).config & 0xFF00000000L) != 0L) {
                            return true;
                        }
                        if (bl instanceof PulseKnockSwitchBlock) {
                            return true;
                        }
                        if (bl instanceof BistableKnockSwitchBlock) {
                            return true;
                        }
                        if (bl instanceof ComparatorSwitchBlock) {
                            return true;
                        }
                        if (bl instanceof DoorSensorSwitchBlock) {
                            return true;
                        }
                    }
                    if (without_switch_linking) {
                        if (bl instanceof LinkReceiverSwitchBlock) {
                            return true;
                        }
                        if (bl instanceof LinkRelaySwitchBlock) {
                            return true;
                        }
                    }
                    if (without_decorative) {
                        if (bl == ModContent.ELEVATOR_BUTTON) {
                            return true;
                        }
                        if (bl == ModContent.ARROW_TARGET_SWITCH) {
                            return true;
                        }
                    }
                } else if (block instanceof SensitiveGlassBlock && without_decorative) {
                    return true;
                }
            }
            catch (Exception ex) {
                LOGGER.error("Exception evaluating the optout config: '" + ex.getMessage() + "'");
            }
            return false;
        }).forEach(e -> optouts.add(e.getRegistryName().func_110623_a()));
        optouts_ = optouts;
    }

    public static final void apply() {
        if (SERVER == null) {
            return;
        }
        status_overlay_disabled = (Boolean)ModConfig.SERVER.without_switch_status_overlay.get();
        without_switch_linking = (Boolean)ModConfig.SERVER.without_switch_linking.get();
        max_switch_linking_distance = (Integer)ModConfig.SERVER.max_switch_linking_distance.get();
        without_color_tinting = (Boolean)ModConfig.SERVER.without_color_tinting.get();
        without_detector_switch_update = (Boolean)ModConfig.SERVER.without_detector_switch_update.get();
        autoswitch_linear_update_interval = (Integer)ModConfig.SERVER.autoswitch_linear_update_interval.get();
        autoswitch_volumetric_update_interval = (Integer)ModConfig.SERVER.autoswitch_volumetric_update_interval.get();
        without_environmental_switch_update = (Boolean)ModConfig.SERVER.without_environmental_switch_update.get();
        without_timer_switch_update = (Boolean)ModConfig.SERVER.without_timer_switch_update.get();
        gauge_update_interval = (Integer)ModConfig.SERVER.gauge_update_interval.get();
        without_gauge_weak_power_measurement = (Boolean)ModConfig.SERVER.without_gauge_weak_power_measurement.get();
        without_pulsetime_config = (Boolean)ModConfig.SERVER.without_pulsetime_config.get();
        config_left_click_timeout = (Integer)ModConfig.SERVER.config_left_click_timeout.get();
        without_switch_nooutput = (Boolean)ModConfig.SERVER.without_switch_nooutput.get();
        accepted_wrenches = (String)ModConfig.SERVER.accepted_wrenches.get();
        without_indicators = (Boolean)ModConfig.SERVER.without_indicators.get();
        without_blinking_indicators = (Boolean)ModConfig.SERVER.without_blinking_indicators.get();
        without_sound_indicators = (Boolean)ModConfig.SERVER.without_sound_indicators.get();
        without_gauges = (Boolean)ModConfig.SERVER.without_gauges.get();
        without_bistable_switches = (Boolean)ModConfig.SERVER.without_bistable_switches.get();
        without_pulse_switches = (Boolean)ModConfig.SERVER.without_pulse_switches.get();
        without_contact_switches = (Boolean)ModConfig.SERVER.without_contact_switches.get();
        without_automatic_switches = (Boolean)ModConfig.SERVER.without_automatic_switches.get();
        without_linkrelay_switches = (Boolean)ModConfig.SERVER.without_linkrelay_switches.get();
        without_analog_switches = (Boolean)ModConfig.SERVER.without_analog_switches.get();
        without_decorative = (Boolean)ModConfig.SERVER.without_decorative.get();
        switch_status_overlay_y = (Double)ModConfig.SERVER.switch_status_overlay_y.get();
        without_rightclick_item_switchconfig = (Boolean)ModConfig.SERVER.without_rightclick_item_switchconfig.get();
        with_experimental = (Boolean)ModConfig.SERVER.with_experimental.get();
        accepted_wrenches = accepted_wrenches.toLowerCase().replaceAll("[\\s]", "").replaceAll(",,", ",");
        accepted_wrenches = ("," + accepted_wrenches + ",").replaceAll(",air,", ",redstone_torch,");
        accepted_wrenches = accepted_wrenches.replaceAll("[,]+$", "").replaceAll("^[,]+", "");
        ModConfig.updateOptouts();
    }

    static {
        Pair common_ = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)common_.getRight();
        COMMON = (CommonConfig)common_.getLeft();
        Pair server_ = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_CONFIG_SPEC = (ForgeConfigSpec)server_.getRight();
        SERVER = (ServerConfig)server_.getLeft();
        Pair client_ = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_CONFIG_SPEC = (ForgeConfigSpec)client_.getRight();
        CLIENT = (ClientConfig)client_.getLeft();
        server_config_ = new CompoundNBT();
        optouts_ = new HashSet();
        status_overlay_disabled = false;
        without_switch_linking = false;
        without_color_tinting = false;
        without_detector_switch_update = false;
        without_environmental_switch_update = false;
        without_timer_switch_update = false;
        without_gauge_weak_power_measurement = false;
        without_pulsetime_config = false;
        without_switch_nooutput = false;
        without_indicators = false;
        without_blinking_indicators = false;
        without_sound_indicators = false;
        without_gauges = false;
        without_bistable_switches = false;
        without_pulse_switches = false;
        without_contact_switches = false;
        without_automatic_switches = false;
        without_linkrelay_switches = false;
        without_decorative = false;
        without_analog_switches = false;
        without_rightclick_item_switchconfig = false;
        max_switch_linking_distance = 16;
        autoswitch_linear_update_interval = 4;
        autoswitch_volumetric_update_interval = 4;
        gauge_update_interval = 4;
        config_left_click_timeout = 600;
        switch_status_overlay_y = 0.75;
        accepted_wrenches = "";
        with_experimental = false;
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.ConfigValue<String> pattern_excludes;
        public final ForgeConfigSpec.ConfigValue<String> pattern_includes;
        public final ForgeConfigSpec.BooleanValue without_gauges;
        public final ForgeConfigSpec.BooleanValue without_indicators;
        public final ForgeConfigSpec.BooleanValue without_blinking_indicators;
        public final ForgeConfigSpec.BooleanValue without_sound_indicators;
        public final ForgeConfigSpec.BooleanValue without_pulse_switches;
        public final ForgeConfigSpec.BooleanValue without_bistable_switches;
        public final ForgeConfigSpec.BooleanValue without_contact_switches;
        public final ForgeConfigSpec.BooleanValue without_automatic_switches;
        public final ForgeConfigSpec.BooleanValue without_linkrelay_switches;
        public final ForgeConfigSpec.BooleanValue without_analog_switches;
        public final ForgeConfigSpec.BooleanValue without_decorative;
        public final ForgeConfigSpec.BooleanValue without_pulsetime_config;
        public final ForgeConfigSpec.BooleanValue without_color_tinting;
        public final ForgeConfigSpec.BooleanValue without_switch_nooutput;
        public final ForgeConfigSpec.BooleanValue without_switch_linking;
        public final ForgeConfigSpec.BooleanValue without_rightclick_item_switchconfig;
        public final ForgeConfigSpec.BooleanValue without_tooltips;
        public final ForgeConfigSpec.DoubleValue switch_status_overlay_y;
        public final ForgeConfigSpec.BooleanValue with_experimental;
        public final ForgeConfigSpec.BooleanValue without_recipes;
        public final ForgeConfigSpec.BooleanValue without_switch_status_overlay;
        public final ForgeConfigSpec.BooleanValue without_detector_switch_update;
        public final ForgeConfigSpec.BooleanValue without_environmental_switch_update;
        public final ForgeConfigSpec.BooleanValue without_timer_switch_update;
        public final ForgeConfigSpec.IntValue max_switch_linking_distance;
        public final ForgeConfigSpec.ConfigValue<String> accepted_wrenches;
        public final ForgeConfigSpec.BooleanValue without_gauge_weak_power_measurement;
        public final ForgeConfigSpec.IntValue gauge_update_interval;
        public final ForgeConfigSpec.IntValue autoswitch_volumetric_update_interval;
        public final ForgeConfigSpec.IntValue autoswitch_linear_update_interval;
        public final ForgeConfigSpec.IntValue config_left_click_timeout;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side, but are also configurable in single player.").push("server");
            builder.comment("Opt-out settings").push("optout");
            this.pattern_excludes = builder.translation("rsgauges.config.pattern_excludes").comment("Opt-out any block by its registry name ('*' wildcard matching, comma separated list, whitespaces ignored. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' excludes everything that has 'wood' or 'steel' in the registry name. The matching result is also traced in the log file. ").define("pattern_excludes", (Object)"");
            this.pattern_includes = builder.translation("rsgauges.config.pattern_includes").comment("Prevent blocks from being opt'ed by registry name ('*' wildcard matching, comma separated list, whitespaces ignored. Evaluated before all other opt-out checks. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' includes everything that has 'wood' or 'steel' in the registry name.The matching result is also traced in the log file.").define("pattern_includes", (Object)"");
            this.without_gauges = builder.translation("rsgauges.config.without_gauges").comment("Completely disable all (power metering) gauges.").define("without_gauges", false);
            this.without_indicators = builder.translation("rsgauges.config.without_indicators").comment("Completely disable all (blinking and steady) indicator lamps/LEDs.").define("without_indicators", false);
            this.without_blinking_indicators = builder.translation("rsgauges.config.without_blinking_indicators").comment("Completely disable all blinking indicator lamps/LEDs.").define("without_blinking_indicators", false);
            this.without_sound_indicators = builder.translation("rsgauges.config.without_sound_indicators").comment("Completely disable all sound emmitting indicators.").define("without_sound_indicators", false);
            this.without_pulse_switches = builder.translation("rsgauges.config.without_pulse_switches").comment("Completely disable all (button like) pulse switches.").define("without_pulse_switches", false);
            this.without_bistable_switches = builder.translation("rsgauges.config.without_bistable_switches").comment("Completely disable all (lever like) bistable switches.").define("without_bistable_switches", false);
            this.without_contact_switches = builder.translation("rsgauges.config.without_contact_switches").comment("Completely disable all contact switches.").define("without_contact_switches", false);
            this.without_automatic_switches = builder.translation("rsgauges.config.without_automatic_switches").comment("Completely disable all automatic switches.").define("without_automatic_switches", false);
            this.without_linkrelay_switches = builder.translation("rsgauges.config.without_linkrelay_switches").comment("Completely disable all link relay switches.").define("without_linkrelay_switches", false);
            this.without_analog_switches = builder.translation("rsgauges.config.without_analog_switches").comment("Completely disable all analog switches, such as dimmers.").define("without_analog_switches", false);
            this.without_decorative = builder.translation("rsgauges.config.without_decorative").comment("Completely disable all decorative blocks.").define("without_decorative", false);
            this.without_pulsetime_config = builder.translation("rsgauges.config.without_pulsetime_config").comment("Disable pulse time configuration of switches using redstone dust stack clicking.").define("without_pulsetime_config", false);
            this.without_color_tinting = builder.translation("rsgauges.config.without_color_tinting").comment("Disable color tinting for switches and gauges.").define("without_color_tinting", false);
            this.without_switch_nooutput = builder.translation("rsgauges.config.without_switch_nooutput").comment("Disable the 'no output' config option for switches.").define("without_switch_nooutput", false);
            this.without_switch_linking = builder.translation("rsgauges.config.without_switch_linking").comment("Disables switch remote linking.").define("without_switch_linking", false);
            this.without_recipes = builder.translation("rsgauges.config.without_recipes").comment("Disable all internal recipes, allowing to use alternative pack recipes.").define("without_recipes", false);
            this.without_rightclick_item_switchconfig = builder.translation("rsgauges.config.without_rightclick_item_switchconfig").comment("Disables the possibility to right click switches with Redstone Dust, Ender Pearls or Switch Link pearls for configuration or linking. Can be useful if it is important to the players that no unforseen switch configuration happens when activating a switch was intended. Affects server side only. Can be changed during operation.").define("without_rightclick_item_switchconfig", false);
            builder.pop();
            builder.comment("Miscellaneous settings").push("miscellaneous");
            this.with_experimental = builder.translation("rsgauges.config.with_experimental").comment("Enables experimental features. Use at own risk.").define("with_experimental", false);
            this.without_switch_status_overlay = builder.translation("rsgauges.config.without_switch_status_overlay").comment("Disable the status overlay for switches and use chat messages instead.").define("without_switch_status_overlay", false);
            this.without_detector_switch_update = builder.translation("rsgauges.config.without_detector_switch_update").comment("Disable tile entity update() for detector switches(for performance testing only, don't do this at home).").define("without_detector_switch_update", false);
            this.without_environmental_switch_update = builder.translation("rsgauges.config.without_environmental_switch_update").comment(new String[]{"Disable tile entity update() for environmental sensor switches.", "(for performance testing only, don't do this at home)"}).define("without_environmental_switch_update", false);
            this.without_timer_switch_update = builder.translation("rsgauges.config.without_timer_switch_update").comment("Disable tile entity update() for time based switches.(for performance testing only, don't do this at home)").define("without_timer_switch_update", false);
            this.max_switch_linking_distance = builder.translation("rsgauges.config.max_switch_linking_distance").comment("Defines how far you or a link source switch can be away from the target to activate it. The value 0 means 'no limitation',  as long as the target chunk is loaded.").defineInRange("max_switch_linking_distance", 48, 0, 64);
            this.accepted_wrenches = builder.translation("rsgauges.config.accepted_wrenches").comment("Comma sepatated list of items names that can be used alter configurable blocks of this mod. This applies when the display side of the block is right click (activated) with the item in the main hand.").define("accepted_wrenches", (Object)"redstone_torch");
            builder.pop();
            builder.comment("Settings to tweak the performance, or use cases normally no change should be required here.").push("tweaks");
            this.without_gauge_weak_power_measurement = builder.translation("rsgauges.config.without_gauge_weak_power_measurement").comment("Gauges shall not frequently lookup weak power provided to the block they are attached to.").define("without_gauge_weak_power_measurement", false);
            this.gauge_update_interval = builder.translation("rsgauges.config.gauge_update_interval").comment("Sample interval of the gauges in ticks. Lower values decrease the display latency for indirect weak power measurements. Minor performance impact for values >= 5.").defineInRange("gauge_update_interval", 8, 2, 100);
            this.autoswitch_volumetric_update_interval = builder.translation("rsgauges.config.autoswitch_volumetric_update_interval").comment("Sample interval of volume sensing automatic switches in ticks (e.g infrared motion detector). Lower values make the switches reacting faster, but also have an impact on the server performance due to ray tracing.").defineInRange("autoswitch_volumetric_update_interval", 10, 5, 50);
            this.autoswitch_linear_update_interval = builder.translation("rsgauges.config.autoswitch_linear_update_interval").comment(new String[]{"Sample interval of the linear switches in ticks (like laser pointer based sensors). Lower values make the switches reacting faster, but also have an impact on the server performance due to ray tracing. Has much less impact", "as the volumetric autoswitch interval."}).defineInRange("autoswitch_linear_update_interval", 4, 1, 50);
            this.config_left_click_timeout = builder.translation("rsgauges.config.config_left_click_timeout").comment("Timeout in milliseconds defining the timeout for left clicking switches or devices in order to configure them. If the device can be opened, it will be opened on 'double-left-click' and closed again on 'single-left-click'. The item in the hand must be a valid wrench (see 'Accepted wrenches'). For switches/devices that cannot be opened, multi-clicking cycles through the configuration options. The block has to be at least clicked two times withing the timeout to differ configuration from block breaking, and prevent misconfiguration on unintended left-clicking.").defineInRange("config_left_click_timeout", 700, 500, 1200);
            this.without_tooltips = builder.translation("rsgauges.config.without_tooltips").comment("Disable CTRL-SHIFT item tooltip display.").define("without_tooltips", false);
            this.switch_status_overlay_y = builder.translation("rsgauges.config.switch_status_overlay_y").comment("Vertial position of the switch status overlay message.").defineInRange("switch_status_overlay_y", 0.75, 0.1, 0.8);
            builder.pop();
        }
    }

    public static class CommonConfig {
        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("!Server side config had to be moved to the 'serverconfig' directory of the game!").push("server");
            builder.pop();
        }
    }

    public static class ClientConfig {
        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings not loaded on servers.").push("client");
            builder.pop();
        }
    }
}

