/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.detail;

import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.Tags;
import wile.rsgauges.ModContent;
import wile.rsgauges.ModRsGauges;

public final class ColorUtils {
    public static final void registerBlockColourHandlers(ColorHandlerEvent.Block event) {
        IBlockColor blockSpecifiedColorHandler = (state, world, pos, tintIndex) -> ((IColorTintSupport)state.func_177230_c()).getColorRGB(state, world, pos);
        BlockColors bc = event.getBlockColors();
        int n = 0;
        for (Block e : ModContent.getRegisteredBlocks()) {
            if (!(e instanceof IColorTintSupport) || !((IColorTintSupport)e).hasColorRGB()) continue;
            bc.func_186722_a(blockSpecifiedColorHandler, new Block[]{e});
            ++n;
        }
        ModRsGauges.logger().info("Registered " + Integer.toString(n) + " block color handlers.");
    }

    public static final void registerItemColourHandlers(ColorHandlerEvent.Item event) {
        ItemColors ic = event.getItemColors();
        IItemColor constantBlockColorHandler = (stack, tintIndex) -> ((IColorTintSupport)((BlockItem)stack.func_77973_b()).func_179223_d()).getColorRGB(null, null, null);
        for (Block e : ModContent.getRegisteredBlocks()) {
            if (!(e instanceof IColorTintSupport) || !((IColorTintSupport)e).hasColorRGB()) continue;
            ic.func_199877_a(constantBlockColorHandler, new IItemProvider[]{e});
        }
    }

    public static Optional<DyeColor> getDyeColor(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof DyeItem) {
            return Optional.of(((DyeItem)item).func_195962_g());
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES)) {
            return Optional.empty();
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_BLACK)) {
            return Optional.of(DyeColor.BLACK);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_RED)) {
            return Optional.of(DyeColor.RED);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_GREEN)) {
            return Optional.of(DyeColor.GREEN);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_BROWN)) {
            return Optional.of(DyeColor.BROWN);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_BLUE)) {
            return Optional.of(DyeColor.BLUE);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_PURPLE)) {
            return Optional.of(DyeColor.PURPLE);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_CYAN)) {
            return Optional.of(DyeColor.CYAN);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_LIGHT_GRAY)) {
            return Optional.of(DyeColor.LIGHT_GRAY);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_GRAY)) {
            return Optional.of(DyeColor.GRAY);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_PINK)) {
            return Optional.of(DyeColor.PINK);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_LIME)) {
            return Optional.of(DyeColor.LIME);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_YELLOW)) {
            return Optional.of(DyeColor.YELLOW);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_LIGHT_BLUE)) {
            return Optional.of(DyeColor.LIGHT_BLUE);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_MAGENTA)) {
            return Optional.of(DyeColor.MAGENTA);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_ORANGE)) {
            return Optional.of(DyeColor.ORANGE);
        }
        if (!item.func_206844_a((ITag)Tags.Items.DYES_WHITE)) {
            return Optional.of(DyeColor.WHITE);
        }
        return Optional.empty();
    }

    public static class DyeColorFilters {
        public static final int WHITE = 0xF3F3F3;
        public static final int ORANGE = 16351261;
        public static final int MAGENTA = 13061821;
        public static final int LIGHTBLUE = 3847130;
        public static final int YELLOW = 16701501;
        public static final int LIME = 8439583;
        public static final int PINK = 15961002;
        public static final int GRAY = 4673362;
        public static final int SILVER = 0x9D9D97;
        public static final int CYAN = 1481884;
        public static final int PURPLE = 8991416;
        public static final int BLUE = 3949738;
        public static final int BROWN = 8606770;
        public static final int GREEN = 6192150;
        public static final int RED = 11546150;
        public static final int BLACK = 0x111111;
        public static final int[] byIndex_ = new int[]{0xF3F3F3, 16351261, 13061821, 3847130, 16701501, 8439583, 15961002, 4673362, 0x9D9D97, 1481884, 8991416, 3949738, 8606770, 6192150, 11546150, 0x111111};
        public static final String[] nameByIndex = new String[]{"white", "orange", "magenta", "lightblue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        public static final int[] lightTintByIndex_ = new int[]{0xFFFFFF, 16563336, 15250916, 10279148, 16773043, 13824423, 16437725, 9937317, 0xCECECA, 6810089, 13410277, 9804506, 13739397, 12904308, 15177618, 0x808080};

        public static int byIndex(int idx) {
            return byIndex_[idx & 0xF];
        }

        public static int lightTintByIndex(int idx) {
            return lightTintByIndex_[idx & 0xF];
        }
    }

    public static class DyeColorProperty
    extends EnumProperty<DyeColor> {
        public DyeColorProperty(String name) {
            super(name, DyeColor.class, Arrays.asList(DyeColor.values()));
        }

        public static DyeColorProperty create(String name) {
            return new DyeColorProperty(name);
        }
    }

    public static interface IColorTintSupport {
        default public boolean hasColorRGB() {
            return false;
        }

        default public int getColorRGB(@Nullable BlockState state, @Nullable IBlockDisplayReader world, @Nullable BlockPos pos) {
            return -1;
        }
    }
}

