/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.ModRsGauges;
import wile.rsgauges.blocks.GaugeBlock;
import wile.rsgauges.blocks.IndicatorBlock;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.detail.DevUtils;
import wile.rsgauges.detail.ModResources;

public class AbstractGaugeBlock
extends RsDirectedBlock {
    public static final long GAUGE_DATA_POWER_MASK = 15L;
    public static final int GAUGE_DATA_POWER_SHIFT = 0;
    public static final long GAUGE_DATA_COLOR_MASK = 240L;
    public static final int GAUGE_DATA_COLOR_SHIFT = 4;
    public static final long GAUGE_DATA_BLINKING = 256L;
    public static final long GAUGE_CONFIG_COLOR_TINT_SUPPORT = 0x4000000000000L;
    @Nullable
    public final ModResources.BlockSoundEvent power_on_sound;
    @Nullable
    public final ModResources.BlockSoundEvent power_off_sound;

    public AbstractGaugeBlock(long config, AbstractBlock.Properties props, AxisAlignedBB aabb, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, props, aabb);
        this.power_on_sound = powerOnSound;
        this.power_off_sound = powerOffSound;
    }

    public AbstractGaugeBlock(long config, AbstractBlock.Properties props, AxisAlignedBB aabb) {
        this(config, props, aabb, null, null);
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.isAffectedByNeigbour(state, (IWorld)world, pos, fromPos)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        GaugeTileEntity te = this.getTe((IWorldReader)world, pos);
        if (te == null) {
            te.reset_timer();
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 1);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.func_201670_d()) {
            DevUtils.blockActivateHook.hook(state, world, pos, player, hand, hit);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (world.field_72995_K) {
            return;
        }
        DevUtils.blockClickHook.hook(state, world, pos, player);
        GaugeTileEntity te = this.getTe((IWorldReader)world, pos);
        ItemStack item = player.func_184614_ca();
        if (te == null || item == null) {
            return;
        }
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    public boolean getWeakChanges(BlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return state.func_177230_c() instanceof GaugeBlock && side == ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        return state == null ? null : (state.func_235901_b_((Property)GaugeBlock.POWER) ? (BlockState)state.func_206870_a((Property)GaugeBlock.POWER, (Comparable)Integer.valueOf(0)) : state);
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new GaugeTileEntity(ModContent.TET_GAUGE);
    }

    @Override
    public boolean isWallMount() {
        return true;
    }

    @Override
    public boolean isCube() {
        return false;
    }

    @Override
    public boolean isLateral() {
        return false;
    }

    public GaugeTileEntity getTe(IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof GaugeTileEntity ? (GaugeTileEntity)te : null;
    }

    public static class GaugeTileEntity
    extends RsBlock.RsTileEntity
    implements ITickableTileEntity {
        private boolean alternation_state_ = false;
        private long trigger_timer_ = 0L;
        private long scd_ = 0L;

        public GaugeTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public GaugeTileEntity() {
            super(ModContent.TET_GAUGE);
        }

        public int power() {
            return (int)((this.scd_ & 0xFL) >> 0);
        }

        @Override
        public int color_tint() {
            return (int)((this.scd_ & 0xF0L) >> 4);
        }

        public void power(int p) {
            this.scd_ = this.scd_ & 0xFFFFFFFFFFFFFFF0L | (long)((p <= 0 ? 0 : (p > 15 ? 15 : p)) << 0) & 0xFL;
        }

        public void color_tint(int p) {
            this.scd_ = this.scd_ & 0xFFFFFFFFFFFFFF0FL | (long)((p <= 0 ? 0 : (p > 15 ? 15 : p)) << 4) & 0xF0L;
        }

        public void reset_timer() {
            this.trigger_timer_ = 0L;
        }

        public void reset() {
            this.reset((IWorldReader)this.func_145831_w());
        }

        public void reset(IWorldReader world) {
            this.trigger_timer_ = 0L;
            if (world == null) {
                this.scd_ = 0L;
            } else {
                try {
                    long current_scd = this.scd_;
                    this.scd_ = (int)((GaugeBlock)world.func_180495_p((BlockPos)this.func_174877_v()).func_177230_c()).config;
                    if (current_scd != this.scd_) {
                        this.func_70296_d();
                    }
                }
                catch (Exception e) {
                    this.scd_ = 0L;
                }
            }
        }

        @Override
        public void writeNbt(CompoundNBT nbt, boolean updatePacket) {
            nbt.func_74772_a("scd", this.scd_);
        }

        @Override
        public void readNbt(CompoundNBT nbt, boolean updatePacket) {
            this.scd_ = nbt.func_74763_f("scd");
        }

        public void func_73660_a() {
            if (--this.trigger_timer_ > 0L) {
                return;
            }
            this.trigger_timer_ = ModConfig.gauge_update_interval;
            try {
                BlockState state = this.func_195044_w();
                AbstractGaugeBlock block = (AbstractGaugeBlock)state.func_177230_c();
                if (this.field_145850_b.field_72995_K) {
                    if ((block.config & 0x100L) != 0L && block instanceof IndicatorBlock && ((Boolean)state.func_177229_b((Property)IndicatorBlock.POWERED)).booleanValue() && (block.power_off_sound != null || block.power_on_sound != null)) {
                        boolean alternation;
                        boolean bl = alternation = (System.currentTimeMillis() & 0x400L) < 512L;
                        if (alternation != this.alternation_state_) {
                            this.alternation_state_ = alternation;
                            if (alternation && block.power_on_sound != null) {
                                block.power_on_sound.play(this.field_145850_b, this.field_174879_c);
                            } else if (!alternation && block.power_off_sound != null) {
                                block.power_off_sound.play(this.field_145850_b, this.field_174879_c);
                            }
                        }
                    }
                } else {
                    boolean sync;
                    BlockPos neighbourPos = this.field_174879_c.func_177967_a((Direction)state.func_177229_b((Property)GaugeBlock.FACING), -1);
                    if (!this.field_145850_b.func_175667_e(neighbourPos)) {
                        return;
                    }
                    BlockState neighborState = this.field_145850_b.func_180495_p(neighbourPos);
                    int p = 0;
                    if (block instanceof IndicatorBlock && this.field_145850_b.func_175640_z(this.func_174877_v())) {
                        p = 15;
                    } else if (neighborState.func_185897_m()) {
                        p = this.field_145850_b.func_175651_c(neighbourPos, ((Direction)state.func_177229_b((Property)RsDirectedBlock.FACING)).func_176734_d());
                    } else if (neighborState.func_185912_n()) {
                        p = neighborState.func_185888_a(this.field_145850_b, neighbourPos);
                    } else {
                        boolean is_indicator = block instanceof IndicatorBlock;
                        for (Direction nbf : Direction.values()) {
                            if (p >= 15 || is_indicator && p > 0) break;
                            BlockPos nbp = neighbourPos.func_177972_a(nbf);
                            if (!this.field_145850_b.func_175667_e(nbp)) continue;
                            BlockState nbs = this.field_145850_b.func_180495_p(nbp);
                            p = Math.max(p, this.field_145850_b.func_175651_c(nbp, nbf));
                        }
                    }
                    boolean bl = sync = this.power() != p;
                    if ((block.config & 0x100L) == 0L) {
                        if (block.power_on_sound != null && this.power() == 0 && p > 0) {
                            block.power_on_sound.play(this.field_145850_b, this.field_174879_c);
                        } else if (block.power_off_sound != null && this.power() > 0 && p == 0) {
                            block.power_off_sound.play(this.field_145850_b, this.field_174879_c);
                        }
                    }
                    this.power(p);
                    if (block instanceof IndicatorBlock) {
                        boolean powered;
                        boolean bl2 = powered = p != 0;
                        if ((Boolean)state.func_177229_b((Property)IndicatorBlock.POWERED) != powered) {
                            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)IndicatorBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 19);
                        }
                    } else if (block instanceof GaugeBlock && (Integer)state.func_177229_b((Property)GaugeBlock.POWER) != p) {
                        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)GaugeBlock.POWER, (Comparable)Integer.valueOf(p)), 27);
                    }
                }
            }
            catch (Throwable e) {
                this.trigger_timer_ = 100L;
                ModRsGauges.logger().error("TE update() failed: " + e);
            }
        }
    }
}

