/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.BlockCategories;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModResources;

public class ObserverSwitchBlock
extends SwitchBlock {
    public ObserverSwitchBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (!this.isAffectedByNeigbour(state, world, pos, facingPos)) {
            return state;
        }
        ObserverSwitchTileEntity te = this.getTe((IWorldReader)world, pos);
        if (te != null) {
            te.observe();
        }
        return state;
    }

    @Override
    public ObserverSwitchTileEntity getTe(IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof ObserverSwitchTileEntity)) {
            return null;
        }
        return (ObserverSwitchTileEntity)te;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ObserverSwitchTileEntity(ModContent.TET_OBSERVER_SWITCH);
    }

    public static class ObserverSwitchTileEntity
    extends SwitchBlock.SwitchTileEntity
    implements ITickableTileEntity {
        public final int debounce_max = 10;
        public final int range_max = 8;
        public final int threshold_max = 8;
        private int debounce_ = 0;
        private int range_ = 0;
        private int threshold_ = 1;
        private int filter_index_ = 0;
        private int update_timer_ = 0;
        private int debounce_counter_ = 0;

        public ObserverSwitchTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public ObserverSwitchTileEntity() {
            super(ModContent.TET_OBSERVER_SWITCH);
        }

        int debounce() {
            return this.debounce_;
        }

        int range() {
            return this.range_;
        }

        int threshold() {
            return this.threshold_;
        }

        int filter() {
            return this.filter_index_;
        }

        String filter_name() {
            return BlockCategories.getMatcherNames().get(this.filter_index_ < 0 ? 0 : (this.filter_index_ >= BlockCategories.getMatcherNames().size() ? BlockCategories.getMatcherNames().size() - 1 : this.filter_index_));
        }

        void filter_name(String name) {
            int i = -1;
            int fi = 0;
            for (String s : BlockCategories.getMatcherNames()) {
                ++i;
                if (!s.equals(name)) continue;
                fi = i;
                break;
            }
            this.filter_index_ = fi;
        }

        void debounce(int i) {
            this.debounce_ = i <= 0 ? 0 : (i > 10 ? 10 : i);
        }

        void range(int i) {
            this.range_ = i <= 0 ? 0 : (i > 8 ? 8 : i);
        }

        void threshold(int i) {
            this.threshold_ = i <= 0 ? 0 : (i > 8 ? 8 : i);
        }

        void filter(int f) {
            this.filter_index_ = f >= BlockCategories.getMatcherNames().size() ? BlockCategories.getMatcherNames().size() - 1 : (f < 0 ? 0 : f);
        }

        @Override
        public void writeNbt(CompoundNBT nbt, boolean updatePacket) {
            super.writeNbt(nbt, updatePacket);
            nbt.func_74768_a("range", this.range_);
            nbt.func_74768_a("threshold", this.threshold_);
            nbt.func_74778_a("filter", this.filter_name());
            nbt.func_74768_a("debounce", this.debounce_);
        }

        @Override
        public void readNbt(CompoundNBT nbt, boolean updatePacket) {
            super.readNbt(nbt, updatePacket);
            this.range(nbt.func_74762_e("range"));
            this.threshold(nbt.func_74762_e("threshold"));
            this.filter_name(nbt.func_74779_i("filter"));
            this.debounce(nbt.func_74762_e("debounce"));
        }

        @Override
        public void reset(@Nullable IWorldReader world) {
            super.reset(world);
            this.filter_index_ = 0;
            this.range_ = 0;
            this.threshold_ = 1;
            this.debounce_ = 0;
            this.update_timer_ = 0;
            this.debounce_counter_ = 0;
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable PlayerEntity player, double x, double y) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            int n = y >= 12.0 && y <= 13.0 ? 1 : (direction = y >= 9.0 && y <= 10.0 ? -1 : 0);
            int n2 = x >= 1.0 && x <= 2.0 ? 1 : (x >= 4.0 && x <= 5.0 ? 2 : (x >= 7.0 && x <= 8.0 ? 3 : (x >= 10.0 && x <= 11.0 ? 4 : (field = x >= 13.0 && x <= 14.0 ? 5 : 0))));
            if (direction == 0 || field == 0) {
                return false;
            }
            switch (field) {
                case 1: {
                    this.range(this.range() + direction);
                    if (this.threshold() <= this.range()) break;
                    this.threshold(this.range());
                    break;
                }
                case 2: {
                    this.threshold(this.threshold() + direction);
                    break;
                }
                case 3: {
                    this.debounce(this.debounce() + direction);
                    break;
                }
                case 4: {
                    this.on_power(this.on_power() + direction);
                    break;
                }
                case 5: {
                    this.filter(this.filter() + direction);
                }
            }
            if (this.threshold() < 1) {
                this.threshold(1);
            }
            if (this.on_power() < 1) {
                this.on_power(1);
            }
            ArrayList<Object> tr = new ArrayList<Object>();
            StringTextComponent separator = new StringTextComponent(" | ");
            separator.func_240699_a_(TextFormatting.GRAY);
            tr.add(ModAuxiliaries.localizable("switchconfig.blocksensor.range", TextFormatting.BLUE, this.range()));
            tr.add(separator.func_230532_e_().func_230529_a_((ITextComponent)ModAuxiliaries.localizable("switchconfig.blocksensor.threshold", TextFormatting.YELLOW, this.threshold())));
            if (this.debounce() > 0) {
                tr.add(separator.func_230532_e_().func_230529_a_((ITextComponent)ModAuxiliaries.localizable("switchconfig.lightsensor.debounce", TextFormatting.AQUA, this.debounce())));
            } else {
                tr.add(new StringTextComponent(""));
            }
            tr.add(separator.func_230532_e_().func_230529_a_((ITextComponent)ModAuxiliaries.localizable("switchconfig.blocksensor.output_power", TextFormatting.RED, this.on_power())));
            tr.add(separator.func_230532_e_().func_230529_a_((ITextComponent)ModAuxiliaries.localizable("switchconfig.blocksensor.filter", TextFormatting.DARK_GREEN, new TranslationTextComponent("rsgauges.switchconfig.blocksensor.filter." + this.filter_name()))));
            ModAuxiliaries.playerStatusMessage(player, (ITextComponent)ModAuxiliaries.localizable("switchconfig.blocksensor", TextFormatting.RESET, tr.toArray()));
            this.update_timer_ = 0;
            this.func_70296_d();
            return true;
        }

        public void observe() {
            if (this.update_timer_ > 2) {
                this.update_timer_ = 0;
            }
        }

        public void func_73660_a() {
            boolean active;
            BlockPos p;
            if (this.field_145850_b.field_72995_K || --this.update_timer_ > 0) {
                return;
            }
            this.update_timer_ = (this.range_ <= 1 ? 20 : 10) + (int)(Math.random() * 3.0);
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state == null || !(state.func_177230_c() instanceof ObserverSwitchBlock)) {
                return;
            }
            ObserverSwitchBlock block = (ObserverSwitchBlock)state.func_177230_c();
            Direction obervationDirection = (Direction)state.func_177229_b((Property)RsDirectedBlock.FACING);
            int n_matched = 0;
            int rng = this.range_ < 2 ? 1 : this.range_;
            int tr = this.threshold_ > rng ? rng : this.threshold_;
            String fname = this.filter_name();
            BlockCategories.Matcher matcher = BlockCategories.getMatcher(fname);
            for (int n = 1; !(n > rng || this.field_145850_b.isAreaLoaded(p = this.field_174879_c.func_177967_a(obervationDirection, n), 1) && matcher.match(this.field_145850_b, p) && ++n_matched >= tr); ++n) {
            }
            boolean bl = active = n_matched >= this.threshold_;
            if (this.debounce_ > 0) {
                if (active) {
                    if (++this.debounce_counter_ < this.debounce_) {
                        return;
                    }
                    this.debounce_counter_ = this.debounce_;
                    active = true;
                } else {
                    if (--this.debounce_counter_ > 0) {
                        return;
                    }
                    this.debounce_counter_ = 0;
                    active = false;
                }
            }
            if ((Boolean)state.func_177229_b((Property)SwitchBlock.POWERED) != active) {
                block.onSwitchActivated(this.field_145850_b, this.field_174879_c, state, null, null);
            }
        }
    }
}

