/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import wile.rsgauges.blocks.RsBlock;

public class RsDirectedBlock
extends RsBlock {
    public static final long RSBLOCK_CONFIG_WALLMOUNT = 0x4000000000000000L;
    public static final long RSBLOCK_CONFIG_LATERAL = Long.MIN_VALUE;
    public static final long RSBLOCK_CONFIG_FULLCUBE = 0L;
    public static final long RSBLOCK_CONFIG_OPOSITE_PLACEMENT = 0x800000000000000L;
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    protected final AxisAlignedBB unrotatedBB;
    private static final Direction[][] fast_transform_lut = new Direction[][]{{Direction.SOUTH, Direction.NORTH, Direction.UP, Direction.DOWN, Direction.WEST, Direction.EAST}, {Direction.NORTH, Direction.SOUTH, Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}, {Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH}, {Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}};

    public RsDirectedBlock(long config, AbstractBlock.Properties builder, @Nullable AxisAlignedBB aabb) {
        super(config | ((config & 0x3000000000000000L) == 0L && (aabb.func_216364_b() < 0.99 || aabb.func_216360_c() < 0.99 || aabb.func_216364_b() < 0.99) ? 0x1000000000000000L : 0L), builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        this.unrotatedBB = aabb != null ? aabb : new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)this.getBoundingBox(state));
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.func_220053_a(state, world, pos, selectionContext);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (!this.isValidPositionOnSide((IWorldReader)context.func_195991_k(), context.func_195995_a(), context.func_196000_l())) {
            return null;
        }
        BlockState state = super.func_196258_a(context);
        if (state == null) {
            return null;
        }
        Direction facing = this.isWallMount() && !this.isLateral() ? context.func_196000_l() : (this.isWallMount() && this.isLateral() ? context.func_196000_l().func_176734_d() : (!this.isWallMount() && this.isLateral() ? context.func_195992_f() : context.func_196010_d()));
        if (this.isOpositePlacement()) {
            facing = facing.func_176734_d();
        }
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)facing);
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (this.isCube() || !world.func_175623_d(facingPos) && !facingState.func_185904_a().func_76224_d()) {
            return state;
        }
        boolean iswall = this.isWallMount();
        boolean islat = this.isLateral();
        Direction blockfacing = (Direction)state.func_177229_b((Property)FACING);
        if (!this.isWallMount() && this.isLateral() && facing == Direction.DOWN) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (this.isWallMount() && !this.isLateral() && facing == ((Direction)state.func_177229_b((Property)FACING)).func_176734_d()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (this.isWallMount() && this.isLateral() && facing == state.func_177229_b((Property)FACING)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public boolean isWallMount() {
        return (this.config & 0x4000000000000000L) != 0L;
    }

    public boolean isLateral() {
        return (this.config & Long.MIN_VALUE) != 0L;
    }

    public boolean isCube() {
        return (this.config & 0xC000000000000000L) == 0L;
    }

    public boolean isOpositePlacement() {
        return (this.config & 0x800000000000000L) != 0L;
    }

    public AxisAlignedBB getUnrotatedBB() {
        return this.unrotatedBB;
    }

    public AxisAlignedBB getUnrotatedBB(BlockState state) {
        return this.getUnrotatedBB();
    }

    protected boolean isAffectedByNeigbour(BlockState state, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (this.isCube()) {
            return true;
        }
        if (!this.isWallMount() ? !pos.func_177977_b().equals((Object)neighborPos) : (!this.isLateral() ? !pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d()).equals((Object)neighborPos) : !pos.func_177972_a((Direction)state.func_177229_b((Property)FACING)).equals((Object)neighborPos))) {
            return false;
        }
        BlockState neighborState = world.func_180495_p(neighborPos);
        if (neighborState == null) {
            return false;
        }
        return !world.func_175623_d(neighborPos) && !neighborState.func_185904_a().func_76224_d();
    }

    protected Direction getAbsoluteFacing(BlockState state, Direction relativeSide) {
        return state == null || relativeSide == null ? Direction.NORTH : fast_transform_lut[((Direction)state.func_177229_b((Property)FACING)).func_176745_a()][relativeSide.func_176745_a()];
    }

    public AxisAlignedBB getBoundingBox(BlockState state) {
        AxisAlignedBB bb = this.getUnrotatedBB(state);
        if (!this.isLateral()) {
            switch (((Direction)state.func_177229_b((Property)FACING)).func_176745_a()) {
                case 0: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, 1.0 - bb.field_72334_f, 1.0 - bb.field_72337_e, 1.0 - bb.field_72340_a, 1.0 - bb.field_72339_c, 1.0 - bb.field_72338_b);
                }
                case 1: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72340_a, bb.field_72334_f, bb.field_72337_e);
                }
                case 2: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
                }
                case 3: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 4: {
                    return new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
                }
                case 5: {
                    return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
                }
            }
        } else {
            switch (((Direction)state.func_177229_b((Property)FACING)).func_176745_a()) {
                case 0: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 1: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 2: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 3: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
                }
                case 4: {
                    return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
                }
                case 5: {
                    return new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
                }
            }
        }
        return bb;
    }

    protected boolean isValidPositionOnSide(IWorldReader world, BlockPos pos, Direction side) {
        if (this.isCube()) {
            return true;
        }
        if (this.isLateral() && !this.isWallMount()) {
            if (side != Direction.UP) {
                return false;
            }
            return Block.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177977_b());
        }
        if (this.isWallMount()) {
            if (this.isLateral() && (side == Direction.UP || side == Direction.DOWN)) {
                return false;
            }
            BlockPos blockpos = pos.func_177972_a(side.func_176734_d());
            BlockState blockState = world.func_180495_p(blockpos);
        }
        return true;
    }
}

