/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.detail;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.Logger;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModRsGauges;
import wile.rsgauges.detail.Networking;

public class ModAuxiliaries {
    public static final String MODID = "rsgauges";
    public static final Logger LOGGER = ModRsGauges.logger();
    private static final ModRsGauges.ISidedProxy proxy = ModRsGauges.proxy;

    public static boolean isClientSide() {
        return proxy.mc() != null;
    }

    public static final boolean isModLoaded(String registry_name) {
        return ModList.get().isLoaded(registry_name);
    }

    public static final void logInfo(String msg) {
        LOGGER.info(msg);
    }

    public static final void logWarn(String msg) {
        LOGGER.warn(msg);
    }

    public static final void logError(String msg) {
        LOGGER.error(msg);
    }

    public static TranslationTextComponent localizable(String modtrkey, @Nullable TextFormatting color, Object ... args) {
        TranslationTextComponent tr = new TranslationTextComponent("rsgauges." + modtrkey, args);
        if (color != null) {
            tr.func_240699_a_(color);
        }
        return tr;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localize(String translationKey, Object ... args) {
        TranslationTextComponent tr = new TranslationTextComponent(translationKey, args);
        tr.func_240699_a_(TextFormatting.RESET);
        String ft = tr.getString();
        if (ft.contains("${")) {
            Pattern pt = Pattern.compile("\\$\\{([\\w\\.]+)\\}");
            Matcher mt = pt.matcher(ft);
            StringBuffer sb = new StringBuffer();
            while (mt.find()) {
                mt.appendReplacement(sb, new TranslationTextComponent(mt.group(1)).getString().trim());
            }
            mt.appendTail(sb);
            return sb.toString();
        }
        return ft;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasTranslation(String key) {
        return I18n.func_188566_a((String)key);
    }

    public static String ticksToSecondsString(long t) {
        return String.format("%.02f", (double)t / 20.0);
    }

    public static String daytimeToString(long t) {
        t = (t + 6000L) % 24000L;
        String sh = Long.toString(t / 1000L);
        String sm = Long.toString(t % 1000L * 60L / 1000L);
        if (sh.length() < 2) {
            sh = "0" + sh;
        }
        if (sm.length() < 2) {
            sm = "0" + sm;
        }
        return sh + ":" + sm;
    }

    public static void playerChatMessage(PlayerEntity player, String message) {
        String s = message.trim();
        if (!s.isEmpty()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(s), new UUID(0L, 0L));
        }
    }

    public static void playerStatusMessage(PlayerEntity player, ITextComponent message) {
        if (ModConfig.status_overlay_disabled) {
            player.func_145747_a(message, new UUID(0L, 0L));
        } else {
            Networking.OverlayTextMessage.sendToPlayer(player, message);
        }
    }

    public static AxisAlignedBB transform_forward(AxisAlignedBB bb, Direction facing) {
        switch (facing.func_176745_a()) {
            case 0: {
                return new AxisAlignedBB(bb.field_72338_b, -bb.field_72340_a, bb.field_72339_c, bb.field_72337_e, -bb.field_72336_d, bb.field_72334_f);
            }
            case 1: {
                return new AxisAlignedBB(-bb.field_72338_b, bb.field_72340_a, bb.field_72339_c, -bb.field_72337_e, bb.field_72336_d, bb.field_72334_f);
            }
            case 2: {
                return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, -bb.field_72340_a, bb.field_72334_f, bb.field_72337_e, -bb.field_72336_d);
            }
            case 3: {
                return new AxisAlignedBB(-bb.field_72339_c, bb.field_72338_b, bb.field_72340_a, -bb.field_72334_f, bb.field_72337_e, bb.field_72336_d);
            }
            case 4: {
                return new AxisAlignedBB(-bb.field_72340_a, bb.field_72338_b, -bb.field_72339_c, -bb.field_72336_d, bb.field_72337_e, -bb.field_72334_f);
            }
            case 5: {
                return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.1, 0.1, 0.1);
    }

    public static BlockPos transform_forward(BlockPos pos, Direction facing) {
        switch (facing.func_176745_a()) {
            case 0: {
                return new BlockPos(pos.func_177956_o(), -pos.func_177958_n(), pos.func_177952_p());
            }
            case 1: {
                return new BlockPos(-pos.func_177956_o(), pos.func_177958_n(), pos.func_177952_p());
            }
            case 2: {
                return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n());
            }
            case 3: {
                return new BlockPos(-pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
            }
            case 4: {
                return new BlockPos(-pos.func_177958_n(), pos.func_177956_o(), -pos.func_177952_p());
            }
            case 5: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return pos;
    }

    public static final AxisAlignedBB getPixeledAABB(double x0, double y0, double z0, double x1, double y1, double z1) {
        return new AxisAlignedBB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0);
    }

    public static final AxisAlignedBB getRotatedAABB(AxisAlignedBB bb, Direction new_facing, boolean horizontal_rotation) {
        if (!horizontal_rotation) {
            switch (new_facing.func_176745_a()) {
                case 0: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, 1.0 - bb.field_72334_f, 1.0 - bb.field_72337_e, 1.0 - bb.field_72340_a, 1.0 - bb.field_72339_c, 1.0 - bb.field_72338_b);
                }
                case 1: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72340_a, bb.field_72334_f, bb.field_72337_e);
                }
                case 2: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
                }
                case 3: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 4: {
                    return new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
                }
                case 5: {
                    return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
                }
            }
        } else {
            switch (new_facing.func_176745_a()) {
                case 0: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 1: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 2: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 3: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
                }
                case 4: {
                    return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
                }
                case 5: {
                    return new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
                }
            }
        }
        return bb;
    }

    public static final AxisAlignedBB[] getRotatedAABB(AxisAlignedBB[] bbs, Direction new_facing, boolean horizontal_rotation) {
        AxisAlignedBB[] transformed = new AxisAlignedBB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = ModAuxiliaries.getRotatedAABB(bbs[i], new_facing, horizontal_rotation);
        }
        return transformed;
    }

    public static final VoxelShape getUnionShape(AxisAlignedBB[] aabbs) {
        VoxelShape shape = VoxelShapes.func_197880_a();
        for (AxisAlignedBB aabb : aabbs) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)aabb), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }

    public static String loadResourceText(String path) {
        try {
            InputStream is = ModAuxiliaries.class.getResourceAsStream(path);
            if (is == null) {
                return "";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            return br.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static void logGitVersion(String mod_name) {
        try {
            String version = ModAuxiliaries.loadResourceText("/.gitversion-rsgauges").trim();
            ModAuxiliaries.logInfo(mod_name + (version.isEmpty() ? " (dev build)" : " GIT id #" + version) + ".");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final class Tooltip {
        @OnlyIn(value=Dist.CLIENT)
        public static boolean extendedTipCondition() {
            return InputMappings.func_216506_a((long)proxy.mc().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)proxy.mc().func_228018_at_().func_198092_i(), (int)344);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean helpCondition() {
            return Tooltip.extendedTipCondition() && (InputMappings.func_216506_a((long)proxy.mc().func_228018_at_().func_198092_i(), (int)341) || InputMappings.func_216506_a((long)proxy.mc().func_228018_at_().func_198092_i(), (int)345));
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(@Nullable String advancedTooltipTranslationKey, @Nullable String helpTranslationKey, List<ITextComponent> tooltip, ITooltipFlag flag, boolean addAdvancedTooltipHints) {
            boolean tip_available;
            boolean help_available = helpTranslationKey != null && ModAuxiliaries.hasTranslation(helpTranslationKey + ".help");
            boolean bl = tip_available = advancedTooltipTranslationKey != null && ModAuxiliaries.hasTranslation(helpTranslationKey + ".tip");
            if (!help_available && !tip_available) {
                return false;
            }
            if (Tooltip.helpCondition()) {
                if (!help_available) {
                    return false;
                }
                String s = ModAuxiliaries.localize(helpTranslationKey + ".help", new Object[0]);
                if (s.isEmpty()) {
                    return false;
                }
                tooltip.add((ITextComponent)new StringTextComponent(s));
                return true;
            }
            if (Tooltip.extendedTipCondition()) {
                if (!tip_available) {
                    return false;
                }
                String s = ModAuxiliaries.localize(advancedTooltipTranslationKey + ".tip", new Object[0]);
                if (s.isEmpty()) {
                    return false;
                }
                tooltip.add((ITextComponent)new StringTextComponent(s));
                return true;
            }
            if (addAdvancedTooltipHints) {
                String s = "";
                if (tip_available) {
                    s = s + ModAuxiliaries.localize("rsgauges.tooltip.hint.extended", new Object[0]) + (help_available ? " " : "");
                }
                if (help_available) {
                    s = s + ModAuxiliaries.localize("rsgauges.tooltip.hint.help", new Object[0]);
                }
                tooltip.add((ITextComponent)new StringTextComponent(s));
            }
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag, boolean addAdvancedTooltipHints) {
            return Tooltip.addInformation(stack.func_77977_a(), stack.func_77977_a(), tooltip, flag, addAdvancedTooltipHints);
        }
    }

    public static interface IExperimentalFeature {
    }
}

