/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.syp.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="syp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static boolean autoHeal;
    public static boolean showLoc;
    public static boolean useWorldTicks;
    public static int deathTimer;
    public static int healTime;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MyConfig.bakeConfig();
        }
    }

    public static void bakeConfig() {
        autoHeal = (Boolean)MyConfig.COMMON.autoHeal.get();
        showLoc = (Boolean)MyConfig.COMMON.showLoc.get();
        useWorldTicks = (Boolean)MyConfig.COMMON.useWorldTicks.get();
        deathTimer = (Integer)MyConfig.COMMON.deathTimer.get();
        healTime = (Integer)MyConfig.COMMON.healTime.get() * 20;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue autoHeal;
        public final ForgeConfigSpec.BooleanValue showLoc;
        public final ForgeConfigSpec.BooleanValue useWorldTicks;
        public final ForgeConfigSpec.IntValue deathTimer;
        public final ForgeConfigSpec.IntValue healTime;

        public Common(ForgeConfigSpec.Builder builder) {
            String baseTrans = "syp.config.";
            String sectionTrans = baseTrans + "general.";
            this.deathTimer = builder.comment("Death Timer").translation(sectionTrans + "death_timer").defineInRange("DeathTimer", 24000, 0, 220000);
            this.healTime = builder.comment("Heal Time for Golden Pet Bandage").translation(sectionTrans + "heal_time").defineInRange("HealTime", 20, 0, 120);
            this.autoHeal = builder.comment("Auto Heal after timer").translation(sectionTrans + "auto_heal").define("AutoHeal", false);
            this.showLoc = builder.comment("Show Location").translation(sectionTrans + "show_loc").define("ShowLoc", true);
            this.useWorldTicks = builder.comment("Use world ticks otherwise chunk ticks").translation(sectionTrans + "world_ticks").define("UseWorldTicks", false);
        }
    }
}

