/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.syp.entity;

import com.lupicus.syp.advancements.ModTriggers;
import com.lupicus.syp.config.MyConfig;
import com.lupicus.syp.entity.IDying;
import com.lupicus.syp.item.ModItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ShoulderRidingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class DyingShoulderRidingEntity
extends ShoulderRidingEntity
implements IDying {
    protected long woundedTime;
    protected int woundedTicks;
    double dx;
    double ay;
    double dz;

    protected DyingShoulderRidingEntity(EntityType<? extends ShoulderRidingEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("WoundedTime")) {
            this.woundedTime = compound.func_74763_f("WoundedTime");
            this.woundedTicks = this.field_70173_aa;
            this.woundedTicks = compound.func_74764_b("WoundedTicks") ? (this.woundedTicks -= compound.func_74762_e("WoundedTicks")) : (this.woundedTicks -= (int)(this.field_70170_p.func_82737_E() - this.woundedTime));
            this.field_70180_af.func_187227_b(field_213330_X, (Object)Pose.DYING);
            this.func_70606_j(0.0f);
            this.field_70725_aQ = 20;
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.isDying()) {
            compound.func_74772_a("WoundedTime", this.woundedTime);
            compound.func_74768_a("WoundedTicks", this.field_70173_aa - this.woundedTicks);
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.func_70909_n()) {
            super.func_70645_a(cause);
            return;
        }
        if (!this.isDying()) {
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l) && this.func_70902_q() instanceof ServerPlayerEntity) {
                Class<?> clazz = this.getClass();
                String type = clazz.getSimpleName().replace("Entity", "").toLowerCase();
                TranslationTextComponent msg = new TranslationTextComponent("syp.pet_dying." + type);
                if (this.func_145818_k_()) {
                    msg.func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_(this.func_200201_e());
                }
                if (MyConfig.showLoc) {
                    msg.func_230529_a_((ITextComponent)new StringTextComponent(" " + this.formatLoc(this.func_213303_ch())));
                }
                LivingEntity player = this.func_70902_q();
                player.func_145747_a((ITextComponent)msg, player.func_110124_au());
            }
            this.func_213317_d(Vector3d.field_186680_a);
            this.field_70180_af.func_187227_b(field_213330_X, (Object)Pose.DYING);
            this.woundedTime = this.field_70170_p.func_82737_E();
            this.woundedTicks = this.field_70173_aa;
            this.field_70177_z = this.field_70761_aq;
            this.field_70759_as = this.field_70761_aq;
            this.field_70125_A = 0.0f;
        }
    }

    protected void func_70609_aI() {
        if (!this.func_70909_n()) {
            super.func_70609_aI();
            return;
        }
        if (this.field_70725_aQ < 20) {
            ++this.field_70725_aQ;
            if (this.field_70725_aQ == 10) {
                this.modifyBoundingBox();
            }
        } else if (!this.field_70170_p.field_72995_K) {
            int time;
            int n = time = MyConfig.useWorldTicks ? (int)(this.field_70170_p.func_82737_E() - this.woundedTime) : this.field_70173_aa - this.woundedTicks;
            if (time < MyConfig.deathTimer) {
                return;
            }
            if (MyConfig.autoHeal) {
                this.cureEntity(ModItems.GOLDEN_PET_BANDAGE);
            } else {
                super.func_70645_a(DamageSource.field_76377_j);
                this.func_70106_y();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 101) {
            this.cureEntity(null);
        } else {
            super.func_70103_a(id);
            if (id == 3 && this.func_70909_n()) {
                this.field_70725_aQ = 19;
                super.func_70609_aI();
            }
        }
    }

    @Override
    public boolean isDying() {
        return this.field_70180_af.func_187225_a(field_213330_X) == Pose.DYING && this.func_70909_n() && !this.field_70128_L;
    }

    @Override
    public ActionResultType dyingInteract(PlayerEntity player, Hand hand) {
        if (!this.isDying()) {
            return ActionResultType.PASS;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item == ModItems.PET_BANDAGE || item == ModItems.GOLDEN_PET_BANDAGE) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (player instanceof ServerPlayerEntity) {
                ModTriggers.SAVE_PET.trigger((ServerPlayerEntity)player, (AnimalEntity)this);
                this.cureEntity(item);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    void cureEntity(Item item) {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)101);
        }
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70180_af.func_187227_b(field_213330_X, (Object)Pose.STANDING);
        this.func_70606_j(1.0f);
        this.field_70725_aQ = 0;
        if (!this.field_70170_p.field_72995_K && this.func_70094_T()) {
            super.func_70107_b(Math.floor(this.func_226277_ct_()) + 0.5, this.func_226278_cu_(), Math.floor(this.func_226281_cx_()) + 0.5);
            if (this.func_70094_T()) {
                this.func_70606_j(3.0f);
            }
        } else {
            this.func_226264_Z_();
        }
        if (item == ModItems.GOLDEN_PET_BANDAGE) {
            this.func_195064_c(new EffectInstance(Effects.field_76428_l, MyConfig.healTime, 1));
        }
    }

    public void func_174826_a(AxisAlignedBB bb) {
        if (this.field_70725_aQ >= 10) {
            AxisAlignedBB oldbb = this.func_174813_aQ();
            this.dx += bb.field_72340_a - oldbb.field_72340_a;
            this.ay = bb.field_72338_b;
            this.dz += bb.field_72339_c - oldbb.field_72339_c;
        }
        super.func_174826_a(bb);
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.field_70725_aQ >= 10) {
            this.modifyBoundingBox();
        }
    }

    public void func_174829_m() {
        if (this.field_70725_aQ >= 10) {
            this.func_226288_n_(this.func_226277_ct_() + this.dx, this.ay, this.func_226281_cx_() + this.dz);
            this.dx = 0.0;
            this.dz = 0.0;
            if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K && this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_217464_b((Entity)this);
            }
            return;
        }
        super.func_174829_m();
    }

    private void modifyBoundingBox() {
        double ang = (double)this.field_70177_z * (Math.PI / 180);
        EntitySize size = this.func_213305_a(Pose.STANDING);
        double width = (double)size.field_220315_a / 2.0;
        double length = (double)size.field_220316_b / 2.0;
        double lcos = length * Math.cos(ang);
        double lsin = length * Math.sin(ang);
        double x0 = this.func_226277_ct_();
        double x1 = x0 + lcos;
        double y0 = this.func_226278_cu_();
        double z0 = this.func_226281_cx_();
        double z1 = z0 + lsin;
        double hw = (width + length) / 2.0;
        double xmin = x1 - hw;
        double xmax = x1 + hw;
        if (x0 < xmin) {
            xmin = x0;
        } else if (x0 > xmax) {
            xmax = x0;
        }
        double zmin = z1 - hw;
        double zmax = z1 + hw;
        if (z0 < zmin) {
            zmin = z0;
        } else if (z0 > zmax) {
            zmax = z0;
        }
        super.func_174826_a(new AxisAlignedBB(xmin, y0, zmin, xmax, y0 + width, zmax));
        this.dx = 0.0;
        this.ay = y0;
        this.dz = 0.0;
    }
}

