/*
 * Decompiled with CFR 0.152.
 */
package net.cobrasrock.skinchange.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.cobrasrock.skinchange.changeskin.skinChange;
import net.cobrasrock.skinchange.gui.DownloadScreen;
import net.cobrasrock.skinchange.gui.SkinEntry;
import net.cobrasrock.skinchange.gui.SkinListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.Validate;

public class SkinScreen
extends Screen {
    final File folder;
    private Screen parent;
    private SkinListWidget skinList;
    private SkinListWidget previewList;
    private NativeImage nativeImage;
    private boolean oldSkin;
    private File file;
    public String error;

    public SkinScreen(Screen scr) {
        super((ITextComponent)new StringTextComponent(""));
        this.parent = scr;
        this.folder = new File("skins");
        this.file = new File("config" + File.separator + "skinchange" + File.separator + "data.txt");
    }

    protected void func_231160_c_() {
        this.previewList = new SkinListWidget(this.field_230706_i_, this.field_230708_k_ / 2 + 4, this.field_230709_l_, 36, this.field_230709_l_ - 36, 36);
        this.previewList.func_230959_g_(this.field_230708_k_ / 2 + 4);
        this.field_230705_e_.add(this.previewList);
        this.skinList = new SkinListWidget(this.field_230706_i_, this.field_230708_k_ / 2 - 4, this.field_230709_l_, 36, this.field_230709_l_ - 52, 36);
        this.skinList.func_230959_g_(0);
        this.field_230705_e_.add(this.skinList);
        this.addSkins(this.folder);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ - this.previewList.func_230949_c_() / 2, this.field_230709_l_ - 28, 100, 20, (ITextComponent)new TranslationTextComponent("gui.back"), button -> Minecraft.func_71410_x().func_147108_a(this.parent)));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ - this.previewList.func_230949_c_() / 2 - 52 - 52, this.field_230709_l_ - 28, 100, 20, (ITextComponent)new TranslationTextComponent("skin.change_skin"), button -> this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(this::changeSkin, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"skin.are_you_sure", (Object[])new Object[0])), (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"skin.changeto", (Object[])new Object[0]) + " '" + ((SkinEntry)this.skinList.func_230958_g_()).fname + "'"), (ITextComponent)new TranslationTextComponent("gui.yes"), (ITextComponent)new TranslationTextComponent("gui.cancel")))){

            public void func_230430_a_(MatrixStack matrices, int var1, int var2, float var3) {
                this.field_230694_p_ = true;
                this.field_230693_o_ = SkinScreen.this.skinList.func_230958_g_() != null && SkinScreen.this.file.length() != 0L;
                super.func_230430_a_(matrices, var1, var2, var3);
            }
        });
        this.func_230480_a_((Widget)new Button(this.skinList.func_230949_c_() / 2 - 52 - 40 - 4, this.field_230709_l_ - 24, 100, 20, (ITextComponent)new TranslationTextComponent("skin.open_folder"), button -> Util.func_110647_a().func_195641_a(new File("skins"))));
        this.func_230480_a_((Widget)new Button(this.skinList.func_230949_c_() / 2 + 52 - 40 - 4, this.field_230709_l_ - 24, 100, 20, (ITextComponent)new TranslationTextComponent("skin.delete_skin"), button -> this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(this::removeEntry, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"skin.are_you_sure_remove", (Object[])new Object[0])), (ITextComponent)new StringTextComponent("'" + ((SkinEntry)this.skinList.func_230958_g_()).fname + "' " + I18n.func_135052_a((String)"skin.long", (Object[])new Object[0])), (ITextComponent)new TranslationTextComponent("selectWorld.delete"), (ITextComponent)new TranslationTextComponent("gui.cancel")))){

            public void func_230430_a_(MatrixStack matrices, int var1, int var2, float var3) {
                this.field_230694_p_ = true;
                this.field_230693_o_ = SkinScreen.this.skinList.func_230958_g_() != null;
                super.func_230430_a_(matrices, var1, var2, var3);
            }
        });
        this.func_230480_a_((Widget)new Button(this.skinList.func_230949_c_() / 2 - 52 - 40 - 4, this.field_230709_l_ - 48, 100, 20, (ITextComponent)new TranslationTextComponent("skin.classic"), button -> ((SkinEntry)this.skinList.func_230958_g_()).toggleSkinType()){

            public void func_230430_a_(MatrixStack matrices, int var1, int var2, float var3) {
                this.field_230694_p_ = true;
                this.field_230693_o_ = SkinScreen.this.skinList.func_230958_g_() != null && ((SkinEntry)((SkinScreen)SkinScreen.this).skinList.func_230958_g_()).skinType == "Slim";
                super.func_230430_a_(matrices, var1, var2, var3);
            }
        });
        this.func_230480_a_((Widget)new Button(this.skinList.func_230949_c_() / 2 + 52 - 40 - 4, this.field_230709_l_ - 48, 100, 20, (ITextComponent)new TranslationTextComponent("skin.slim"), button -> ((SkinEntry)this.skinList.func_230958_g_()).toggleSkinType()){

            public void func_230430_a_(MatrixStack matrices, int var1, int var2, float var3) {
                this.field_230694_p_ = true;
                this.field_230693_o_ = SkinScreen.this.skinList.func_230958_g_() != null && ((SkinEntry)((SkinScreen)SkinScreen.this).skinList.func_230958_g_()).skinType == "Classic";
                super.func_230430_a_(matrices, var1, var2, var3);
            }
        });
        this.func_230480_a_((Widget)new Button(this.skinList.func_230949_c_() / 2 - 52 - 40 - 4, 8, 100, 20, (ITextComponent)new TranslationTextComponent("skin.download_skin"), button -> Minecraft.func_71410_x().func_147108_a((Screen)new DownloadScreen(this))));
        this.func_230480_a_((Widget)new Button(this.skinList.func_230949_c_() / 2 + 52 - 40 - 4, 8, 100, 20, (ITextComponent)new TranslationTextComponent("selectServer.refresh"), button -> {
            this.addSkins(this.folder);
            this.skinList.func_241215_a_(null);
        }));
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.func_230446_a_(matrices);
        this.skinList.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.previewList.func_230430_a_(matrices, mouseX, mouseY, delta);
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        try {
            ((SkinEntry)this.skinList.func_230958_g_()).drawSkin(this.field_230708_k_ - this.previewList.func_230949_c_() / 2 - 16, this.field_230709_l_ / 2 - 64, matrices);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        SkinScreen.func_238471_a_((MatrixStack)matrices, (FontRenderer)font, (String)this.error, (int)(this.field_230708_k_ - this.previewList.func_230949_c_() / 2), (int)40, (int)0xFFFFFF);
    }

    public void addSkins(File folder) {
        this.skinList.func_231039_at__().clear();
        for (File fileEntry : folder.listFiles()) {
            if (!fileEntry.getName().contains(".png") || !this.validateimg(fileEntry)) continue;
            this.skinList.func_231039_at__().add(new SkinEntry(fileEntry.getName().substring(0, fileEntry.getName().length() - 4), fileEntry, this.skinList, this.nativeImage, this.oldSkin));
        }
    }

    /*
     * Loose catch block
     */
    private boolean validateimg(File f) {
        FileInputStream inputStream = new FileInputStream(f);
        try {
            this.nativeImage = NativeImage.func_195713_a((InputStream)inputStream);
        }
        catch (Exception eex) {
            ((InputStream)inputStream).close();
            return false;
        }
        {
            catch (Exception e) {
                return false;
            }
        }
        try {
            Validate.validState((this.nativeImage.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
            Validate.validState((this.nativeImage.func_195714_b() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels tall", (Object[])new Object[0]);
            ((InputStream)inputStream).close();
            this.oldSkin = false;
            return true;
        }
        catch (Exception e) {
            try {
                Validate.validState((this.nativeImage.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((this.nativeImage.func_195714_b() == 32 ? 1 : 0) != 0, (String)"Must be 32 pixels tall", (Object[])new Object[0]);
                ((InputStream)inputStream).close();
                this.oldSkin = true;
                return true;
            }
            catch (Exception ex) {
                ((InputStream)inputStream).close();
                return false;
            }
        }
    }

    private void removeEntry(boolean confirmedAction) {
        if (confirmedAction) {
            ((SkinEntry)this.skinList.func_230958_g_()).deleteSkin();
            this.skinList.func_231039_at__().remove(this.skinList.func_230958_g_());
            this.skinList.func_241215_a_(null);
        }
        this.field_230706_i_.func_147108_a((Screen)this);
    }

    private void changeSkin(boolean confirmedAction) {
        if (confirmedAction) {
            if (skinChange.changeSkin(((SkinEntry)this.skinList.func_230958_g_()).skin_icon, ((SkinEntry)this.skinList.func_230958_g_()).skinType, this)) {
                this.skinList.func_241215_a_(null);
                Minecraft.func_71410_x().func_147108_a(this.parent);
            } else {
                this.field_230706_i_.func_147108_a((Screen)this);
            }
        } else {
            this.field_230706_i_.func_147108_a((Screen)this);
        }
    }
}

