/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.smartphone.phone;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mod.vemerion.smartphone.phone.app.App;
import mod.vemerion.smartphone.phone.app.CatchAppleApp;
import mod.vemerion.smartphone.phone.app.JukeboxApp;
import mod.vemerion.smartphone.phone.app.RunnerApp;
import mod.vemerion.smartphone.phone.app.SuggestionApp;
import mod.vemerion.smartphone.phone.app.VillagerChatApp;
import mod.vemerion.smartphone.phone.utils.Button;
import mod.vemerion.smartphone.phone.utils.PhoneUtils;
import mod.vemerion.smartphone.phone.utils.Rectangle;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class Phone
extends Screen {
    private static final ResourceLocation PHONE_TEXTURE = new ResourceLocation("smartphone", "textures/gui/smartphone.png");
    private static final ResourceLocation PHONE_BACKGROUND = new ResourceLocation("smartphone", "textures/gui/phone_background.png");
    private static final ResourceLocation HOME_BUTTON_TEXTURE = new ResourceLocation("smartphone", "textures/gui/home_button.png");
    private static final ResourceLocation SHUTDOWN_BUTTON_TEXTURE = new ResourceLocation("smartphone", "textures/gui/shutdown_button.png");
    private static final Rectangle HOME_BUTTON = new Rectangle(0.0f, 200.0f, 35.0f, 17.5f);
    private static final Rectangle SHUTDOWN_BUTTON = new Rectangle(65.0f, 200.0f, 35.0f, 17.5f);
    private static final float BUTTON_SIZE = 33.333332f;
    private List<App> apps;
    private List<Button> appButtons;
    private App activeApp;
    private List<Integer> mouseClicked = new ArrayList<Integer>();
    private Set<Integer> keysPressed = new HashSet<Integer>();
    private Button homeButton;
    private Button shutdownButton;

    public Phone() {
        super((ITextComponent)new StringTextComponent(""));
        this.apps = new ArrayList<App>();
        this.apps.add(new CatchAppleApp(this));
        this.apps.add(new JukeboxApp(this));
        this.apps.add(new VillagerChatApp(this));
        this.apps.add(new RunnerApp(this));
        this.apps.add(new SuggestionApp(this));
        this.appButtons = new ArrayList<Button>();
        for (int i = 0; i < this.apps.size(); ++i) {
            float x = (float)(i % 3) * 33.333332f + 1.0f;
            float y = (float)(i / 3) * 33.333332f;
            App app = this.apps.get(i);
            Rectangle rectangle = new Rectangle(x, y, 33.333332f, 33.333332f);
            this.appButtons.add(new Button(rectangle, app.getIcon(), this, () -> {
                this.activeApp = app;
                app.resume();
            }));
        }
        this.homeButton = new Button(HOME_BUTTON, HOME_BUTTON_TEXTURE, this, () -> {
            if (this.activeApp != null) {
                this.activeApp.suspend();
            }
            this.activeApp = null;
        });
        this.shutdownButton = new Button(SHUTDOWN_BUTTON, SHUTDOWN_BUTTON_TEXTURE, this, () -> this.onClose());
    }

    public void playSound(SoundEvent sound, float volume) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        Minecraft.func_71410_x().field_71441_e.func_184148_a((PlayerEntity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), sound, SoundCategory.PLAYERS, volume, 0.8f + player.func_70681_au().nextFloat() * 0.4f);
    }

    private boolean atHomeScreen() {
        return this.activeApp == null;
    }

    public void onClose() {
        if (this.activeApp != null) {
            this.activeApp.suspend();
        }
        super.onClose();
    }

    public void tick() {
        if (this.atHomeScreen()) {
            for (Button b : this.appButtons) {
                b.tick();
            }
        } else {
            this.activeApp.tick();
        }
        this.homeButton.tick();
        this.shutdownButton.tick();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.keysPressed.add(keyCode);
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        this.keysPressed.remove(keyCode);
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean isKeyDown(int keyCode) {
        return this.keysPressed.contains(keyCode);
    }

    public List<Integer> getKeys() {
        return new ArrayList<Integer>(this.keysPressed);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int code) {
        this.mouseClicked.add(code);
        return super.mouseClicked(mouseX, mouseY, code);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int code) {
        this.mouseClicked.remove((Object)code);
        return super.mouseReleased(mouseX, mouseY, code);
    }

    public boolean isLeftDown() {
        return this.mouseClicked.contains(0);
    }

    public boolean isRightDown() {
        return this.mouseClicked.contains(1);
    }

    public float getMouseX() {
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow window = mc.func_228018_at_();
        float x = (float)mc.field_71417_B.func_198024_e() * (float)window.func_198107_o() / (float)window.func_198105_m();
        float center = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2;
        float left = center - 36.0f;
        return (x - left) / 72.0f * 100.0f;
    }

    public float getMouseY() {
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow window = mc.func_228018_at_();
        float y = (float)mc.field_71417_B.func_198026_f() * (float)window.func_198087_p() / (float)window.func_198083_n();
        float bottom = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        float top = bottom - 56.0f - 144.0f;
        return (y - top) / 144.0f * 200.0f;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.render();
    }

    private void render() {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        float windowWidth = window.func_198107_o();
        float windowHeight = window.func_198087_p();
        PhoneUtils.drawOnPhone(PHONE_BACKGROUND, 0.0f, 0.0f, 100.0f, 200.0f);
        if (this.atHomeScreen()) {
            for (Button button : this.appButtons) {
                button.render();
            }
        } else {
            this.activeApp.render();
        }
        PhoneUtils.draw(PHONE_TEXTURE, windowWidth / 2.0f - 48.0f, windowHeight - 32.0f - 192.0f, 96.0f, 192.0f);
        this.shutdownButton.render();
        this.homeButton.render();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

