/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.smartphone.phone.app;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mod.vemerion.smartphone.Main;
import mod.vemerion.smartphone.phone.Phone;
import mod.vemerion.smartphone.phone.app.App;
import mod.vemerion.smartphone.phone.utils.PhoneUtils;
import mod.vemerion.smartphone.phone.utils.Position;
import mod.vemerion.smartphone.phone.utils.Rectangle;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;

public class CatchAppleApp
extends App {
    private static final ResourceLocation APPLE = new ResourceLocation("minecraft", "textures/item/apple.png");
    private static final ResourceLocation BACKGROUND1 = new ResourceLocation("smartphone", "textures/gui/catch_apple_app/background1.png");
    private static final ResourceLocation BACKGROUND2 = new ResourceLocation("smartphone", "textures/gui/catch_apple_app/background2.png");
    private static final ResourceLocation STEVE = new ResourceLocation("smartphone", "textures/gui/catch_apple_app/steve.png");
    private static final float PLAYER_SIZE = 40.0f;
    private static final float APPLE_SIZE = 20.0f;
    private List<Position> apples = new ArrayList<Position>();
    private Position player = new Position(50.0f, 145.0f);
    private int ticksRunning;
    private boolean facingLeft;
    private int score;

    public CatchAppleApp(Phone phone) {
        super(phone);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.rand.nextDouble() < 0.02) {
            this.apples.add(new Position(this.rand.nextFloat() * 80.0f, 0.0f));
        }
        for (int i = this.apples.size() - 1; i >= 0; --i) {
            Position apple = this.apples.get(i);
            apple.y += 3.0f;
            if (new Rectangle(this.player.x, this.player.y, 40.0f).intersect(new Rectangle(apple.x, apple.y, 20.0f))) {
                this.apples.remove(i);
                ++this.score;
                this.phone.playSound(Main.CATCH_APPLE_SOUND, 0.45f);
                continue;
            }
            if (!(apple.y > 175.0f)) continue;
            this.apples.remove(i);
        }
        this.movePlayer(this.phone);
    }

    private void movePlayer(Phone phone) {
        if (phone.isKeyDown(263)) {
            this.facingLeft = true;
            ++this.ticksRunning;
            this.player.x -= 3.0f;
            if (this.ticksRunning % 3 == 0) {
                phone.playSound(SoundEvents.field_187579_bV, 1.0f);
            }
        } else if (phone.isKeyDown(262)) {
            this.facingLeft = false;
            ++this.ticksRunning;
            this.player.x += 3.0f;
            if (this.ticksRunning % 3 == 0) {
                phone.playSound(SoundEvents.field_187579_bV, 1.0f);
            }
        } else {
            this.ticksRunning = 0;
        }
        this.player.x = MathHelper.func_76131_a((float)this.player.x, (float)0.0f, (float)60.0f);
    }

    @Override
    public void render() {
        super.render();
        for (Position apple : this.apples) {
            PhoneUtils.drawOnPhone(APPLE, apple.x, apple.y, 20.0f, 20.0f);
        }
        if (this.facingLeft) {
            PhoneUtils.drawOnPhone(STEVE, this.player.x, this.player.y, 40.0f, 40.0f, (float)(this.ticksRunning % 20 / 5) / 4.0f + 0.25f, 0.0f, -0.25f, 1.0f);
        } else {
            PhoneUtils.drawOnPhone(STEVE, this.player.x, this.player.y, 40.0f, 40.0f, (float)(this.ticksRunning % 20 / 5) / 4.0f, 0.0f, 0.25f, 1.0f);
        }
        PhoneUtils.writeOnPhone("Score: " + this.score, 3.0f, 190.0f, new Color(255, 240, 0), 0.65f);
    }

    @Override
    public ResourceLocation getIcon() {
        return APPLE;
    }

    @Override
    public ResourceLocation getBackground() {
        if (this.ticksExisted % 20 < 10) {
            return BACKGROUND1;
        }
        return BACKGROUND2;
    }
}

