/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.smartphone.phone.app;

import java.util.ArrayList;
import java.util.List;
import mod.vemerion.smartphone.phone.Phone;
import mod.vemerion.smartphone.phone.app.App;
import mod.vemerion.smartphone.phone.app.JukeboxAppMusic;
import mod.vemerion.smartphone.phone.utils.Button;
import mod.vemerion.smartphone.phone.utils.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public class JukeboxApp
extends App {
    private static final SoundEvent[] MUSIC = new SoundEvent[]{SoundEvents.field_187826_eo, SoundEvents.field_187828_ep, SoundEvents.field_187830_eq, SoundEvents.field_187832_er, SoundEvents.field_187834_es, SoundEvents.field_187836_et, SoundEvents.field_187838_eu, SoundEvents.field_187840_ev, SoundEvents.field_187842_ew, SoundEvents.field_187844_ex, SoundEvents.field_187846_ey, SoundEvents.field_187848_ez};
    private static final ResourceLocation[] ICONS = new ResourceLocation[]{new ResourceLocation("minecraft", "textures/item/music_disc_11.png"), new ResourceLocation("minecraft", "textures/item/music_disc_13.png"), new ResourceLocation("minecraft", "textures/item/music_disc_blocks.png"), new ResourceLocation("minecraft", "textures/item/music_disc_cat.png"), new ResourceLocation("minecraft", "textures/item/music_disc_chirp.png"), new ResourceLocation("minecraft", "textures/item/music_disc_far.png"), new ResourceLocation("minecraft", "textures/item/music_disc_mall.png"), new ResourceLocation("minecraft", "textures/item/music_disc_mellohi.png"), new ResourceLocation("minecraft", "textures/item/music_disc_stal.png"), new ResourceLocation("minecraft", "textures/item/music_disc_strad.png"), new ResourceLocation("minecraft", "textures/item/music_disc_wait.png"), new ResourceLocation("minecraft", "textures/item/music_disc_ward.png")};
    private static final int MUSIC_COUNT = MUSIC.length;
    private static final float BUTTON_SIZE = 33.333332f;
    private static final ResourceLocation JUKEBOX = new ResourceLocation("minecraft", "textures/item/music_disc_13.png");
    private static final ResourceLocation BACKGROUND = new ResourceLocation("smartphone", "textures/gui/jukebox_background.png");
    private List<Button> musicButtons = new ArrayList<Button>();
    private JukeboxAppMusic activeMusic;

    public JukeboxApp(Phone phone) {
        super(phone);
        for (int i = 0; i < MUSIC_COUNT; ++i) {
            float x = (float)(i % 3) * 33.333332f + 1.0f;
            float y = (float)(i / 3) * 33.333332f;
            SoundEvent music = MUSIC[i];
            this.musicButtons.add(new Button(new Rectangle(x, y, 33.333332f, 33.333332f), ICONS[i], phone, () -> {
                if (this.activeMusic != null) {
                    this.activeMusic.stop();
                }
                this.activeMusic = new JukeboxAppMusic((PlayerEntity)Minecraft.func_71410_x().field_71439_g, music);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.activeMusic);
            }));
        }
    }

    @Override
    public void tick() {
        super.tick();
        for (Button b : this.musicButtons) {
            b.tick();
        }
    }

    @Override
    public void render() {
        super.render();
        for (Button b : this.musicButtons) {
            b.render();
        }
    }

    @Override
    public void suspend() {
        if (this.activeMusic != null) {
            this.activeMusic.stop();
        }
    }

    @Override
    public ResourceLocation getIcon() {
        return JUKEBOX;
    }

    @Override
    public ResourceLocation getBackground() {
        return BACKGROUND;
    }
}

