/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.smartphone.phone.app;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mod.vemerion.smartphone.Main;
import mod.vemerion.smartphone.phone.Phone;
import mod.vemerion.smartphone.phone.app.App;
import mod.vemerion.smartphone.phone.utils.PhoneUtils;
import mod.vemerion.smartphone.phone.utils.Position;
import mod.vemerion.smartphone.phone.utils.Rectangle;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;

public class RunnerApp
extends App {
    private static final ResourceLocation ICON = new ResourceLocation("smartphone", "textures/gui/runner_app/icon.png");
    private static final ResourceLocation BACKGROUND = new ResourceLocation("smartphone", "textures/gui/runner_app/background.png");
    private static final ResourceLocation STEVE = new ResourceLocation("smartphone", "textures/gui/runner_app/steve.png");
    private static final ResourceLocation FENCE = new ResourceLocation("smartphone", "textures/gui/runner_app/fence.png");
    private static final ResourceLocation FADE = new ResourceLocation("smartphone", "textures/gui/runner_app/fade.png");
    private static final float PLAYER_SIZE = 40.0f;
    Position player;
    private float jump;
    private float z;
    private List<Position> fences;
    private int fenceCooldown;
    private boolean gameOver;

    public RunnerApp(Phone phone) {
        super(phone);
        this.resume();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.gameOver) {
            return;
        }
        if (this.ticksExisted % 3 == 0) {
            this.phone.playSound(SoundEvents.field_187579_bV, 1.0f);
        }
        for (Position fence : this.fences) {
            fence.y += 4.0f;
            if (!(this.z < 0.05f) || !new Rectangle(fence.x, fence.y + 13.0f, 100.0f, 2.0f).intersect(new Rectangle(this.player.x - 20.0f, this.player.y - 20.0f, 40.0f, 20.0f))) continue;
            this.player.y += 4.0f;
        }
        if (this.phone.isKeyDown(32) && this.z < 0.01f) {
            this.jump = 1.0f;
            this.phone.playSound(Main.JUMP_SOUND, 0.6f);
        }
        if (this.z < 0.1f) {
            if (this.phone.isKeyDown(263)) {
                this.player.x -= 3.0f;
            }
            if (this.phone.isKeyDown(262)) {
                this.player.x += 3.0f;
            }
        }
        this.player.x = MathHelper.func_76131_a((float)this.player.x, (float)20.0f, (float)80.0f);
        this.z += this.jump - 0.7f;
        this.jump = (float)((double)this.jump * 0.97);
        if (this.z < 0.0f) {
            this.z = 0.0f;
        }
        if (this.fenceCooldown-- < 0 && this.rand.nextDouble() < 0.03) {
            this.fences.add(new Position(0.0f, -5.0f));
            this.fenceCooldown = 20;
        }
        for (int i = this.fences.size() - 1; i >= 0; --i) {
            if (!(this.fences.get((int)i).y > 200.0f)) continue;
            this.fences.remove(i);
        }
        if (this.player.y > 200.0f) {
            this.gameOver = true;
        }
    }

    @Override
    public void resume() {
        this.player = new Position(50.0f, 80.0f);
        this.fences = new ArrayList<Position>();
        this.gameOver = false;
    }

    private float playerSize() {
        return 40.0f + this.z * 10.0f;
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }

    @Override
    public ResourceLocation getBackground() {
        return BACKGROUND;
    }

    @Override
    public void render() {
        PhoneUtils.drawOnPhone(this.getBackground(), 0.0f, 0.0f, 100.0f, 200.0f, 0.0f, 1.0f - (float)this.ticksExisted / 100.0f % 100.0f, 1.0f, 0.5f);
        for (Position fence : this.fences) {
            PhoneUtils.drawOnPhone(FENCE, fence.x, fence.y, 100.0f, 15.0f);
        }
        float playerSize = this.playerSize();
        PhoneUtils.drawOnPhone(STEVE, this.player.x - playerSize / 2.0f, this.player.y - playerSize / 2.0f, playerSize, playerSize, (float)(this.ticksExisted % 20 / 5) / 4.0f + 0.25f, 0.0f, -0.25f, 1.0f);
        if (this.gameOver) {
            PhoneUtils.drawOnPhone(FADE, 0.0f, 0.0f, 100.0f, 200.0f);
            PhoneUtils.writeOnPhone("Game", 18.0f, 85.0f, new Color(255, 50, 50), 2.0f);
            PhoneUtils.writeOnPhone("Over", 18.0f, 115.0f, new Color(255, 50, 50), 2.0f);
        }
    }
}

