/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.smartphone.phone.app;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mod.vemerion.smartphone.Main;
import mod.vemerion.smartphone.phone.Phone;
import mod.vemerion.smartphone.phone.app.App;
import mod.vemerion.smartphone.phone.utils.PhoneUtils;
import net.minecraft.util.ResourceLocation;

public class VillagerChatApp
extends App {
    private static final ResourceLocation ICON = new ResourceLocation("smartphone", "textures/gui/villager_chat_app/icon.png");
    private static final ResourceLocation BACKGROUND = new ResourceLocation("smartphone", "textures/gui/villager_chat_app/background.png");
    private static final String[] RESPONSES = new String[]{"hmmmmmmmmm", "hhhhmmmmmm", "mhmmm", "hhhhhhhhhhhhhhhhhhhhmmmmmmmmmmmm", "mmmmmmmhhhmmmmmmmmmm", "hhhhhhhhmmmmmmmmmm"};
    private static final String[] CHARS = new String[]{"h", "m"};
    private List<String> chat = new ArrayList<String>();
    private String message = "";

    public VillagerChatApp(Phone phone) {
        super(phone);
    }

    @Override
    public void tick() {
        super.tick();
        List<Integer> keys = this.phone.getKeys();
        if (keys.size() > 0 && this.message.length() < 45 && this.ticksExisted % 3 == 0) {
            this.phone.playSound(Main.WRITE_SOUND, 0.3f);
        }
        for (int key : this.phone.getKeys()) {
            if (this.message.length() >= 45 || key == 257) continue;
            this.message = this.message + CHARS[this.rand.nextInt(CHARS.length)];
        }
        if (this.phone.isKeyDown(257) && !this.message.isEmpty()) {
            this.chat.add("P" + this.message);
            this.message = "";
        }
        if (this.rand.nextDouble() < 0.02) {
            this.chat.add("V" + RESPONSES[this.rand.nextInt(RESPONSES.length)]);
            this.phone.playSound(Main.CATCH_APPLE_SOUND, 0.3f);
        }
    }

    @Override
    public void render() {
        super.render();
        this.printMsg(this.message, 2.0f, 175.0f, new Color(0, 180, 255), 15);
        float y = 150.0f;
        for (int i = this.chat.size() - 1; i >= 0; --i) {
            boolean fromPlayer = this.chat.get(i).startsWith("P");
            String msg = this.chat.get(i).substring(1);
            if ((y = (float)((double)y - (Math.ceil((float)msg.length() / 8.0f) * 8.5 + 10.0))) < 2.0f) break;
            this.printMsg(msg, fromPlayer ? 2.0f : 50.0f, y, fromPlayer ? new Color(0, 180, 255) : new Color(0, 255, 180), 8);
        }
    }

    private void printMsg(String msg, float x, float y, Color color, int maxLength) {
        double count = Math.ceil((float)msg.length() / (float)maxLength) + 0.1;
        int i = 0;
        while ((double)i < count) {
            PhoneUtils.writeOnPhone(msg.substring(0, Math.min(maxLength, msg.length())), x, y + (float)i * 8.5f, color, 0.75f);
            msg = msg.substring(Math.min(maxLength, msg.length()));
            ++i;
        }
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }

    @Override
    public ResourceLocation getBackground() {
        return BACKGROUND;
    }
}

