/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.smartphone.phone.utils;

import java.awt.Color;
import mod.vemerion.smartphone.Main;
import mod.vemerion.smartphone.phone.Phone;
import mod.vemerion.smartphone.phone.utils.PhoneUtils;
import mod.vemerion.smartphone.phone.utils.Rectangle;
import net.minecraft.util.ResourceLocation;

public class Button {
    private Rectangle rectangle;
    private ResourceLocation icon;
    private Phone phone;
    private Runnable runnable;
    private boolean isLeftDownPrev;

    public Button(Rectangle rectangle, ResourceLocation icon, Phone phone, Runnable runnable) {
        this.rectangle = rectangle;
        this.icon = icon;
        this.phone = phone;
        this.runnable = runnable;
    }

    public void tick() {
        boolean isLeftDown = this.phone.isLeftDown();
        if (isLeftDown && !this.isLeftDownPrev && this.rectangle.contains(this.phone.getMouseX(), this.phone.getMouseY())) {
            this.onPress();
        }
        this.isLeftDownPrev = isLeftDown;
    }

    public void render() {
        Color color = this.rectangle.contains(this.phone.getMouseX(), this.phone.getMouseY()) ? new Color(100, 100, 100) : new Color(255, 255, 255);
        PhoneUtils.drawOnPhone(this.icon, this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height, color);
    }

    private void onPress() {
        this.phone.playSound(Main.CLICK_SOUND, 2.0f);
        this.runnable.run();
    }
}

