/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.core.registry;

import com.farcr.swampexpansion.client.render.SlabfishRenderer;
import com.farcr.swampexpansion.common.entity.SlabfishEntity;
import com.farcr.swampexpansion.core.SwampExpansion;
import com.teamabnormals.abnormals_core.core.utils.RegistryHelper;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="swampexpansion", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SwampExEntities {
    public static final RegistryHelper HELPER = SwampExpansion.REGISTRY_HELPER;
    public static final RegistryObject<EntityType<SlabfishEntity>> SLABFISH = HELPER.createLivingEntity("slabfish", SlabfishEntity::new, EntityClassification.CREATURE, 0.45f, 0.9f);

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRendering() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SLABFISH.get()), SlabfishRenderer::new);
    }

    public static void addEntitySpawns() {
        ForgeRegistries.BIOMES.getValues().stream().forEach(SwampExEntities::processSpawning);
    }

    private static void processSpawning(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.SWAMP) {
            biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry((EntityType)SLABFISH.get(), 50, 2, 4));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)SLABFISH.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
    }
}

