/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.common.block;

import com.farcr.swampexpansion.common.block.DoubleCattailBlock;
import com.farcr.swampexpansion.core.registries.SwampExBlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class CattailBlock
extends BushBlock
implements IWaterLoggable,
IGrowable {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public CattailBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATERLOGGED});
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_150354_m || block == Blocks.field_196661_l || block == Blocks.field_150435_aG || block == Blocks.field_150458_ak || block.func_203417_a(BlockTags.field_219750_S);
    }

    public void placeAt(IWorld worldIn, BlockPos pos, int flags) {
        Random rand = new Random();
        int type = rand.nextInt(4);
        BlockState seeds = ((Block)SwampExBlocks.CATTAIL_SPROUTS.get()).func_176223_P();
        BlockState cattail = ((Block)SwampExBlocks.CATTAIL.get()).func_176223_P();
        BlockState tall_up = (BlockState)((Block)SwampExBlocks.TALL_CATTAIL.get()).func_176223_P().func_206870_a(DoubleCattailBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
        BlockState tall_down = (BlockState)((Block)SwampExBlocks.TALL_CATTAIL.get()).func_176223_P().func_206870_a(DoubleCattailBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
        boolean waterlogged = worldIn.func_201671_F(pos);
        if (type == 0) {
            worldIn.func_180501_a(pos, (BlockState)seeds.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), flags);
        } else if (type == 1) {
            worldIn.func_180501_a(pos, (BlockState)cattail.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), flags);
        } else {
            worldIn.func_180501_a(pos, (BlockState)tall_down.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), flags);
            waterlogged = worldIn.func_201671_F(pos.func_177984_a());
            worldIn.func_180501_a(pos.func_177984_a(), (BlockState)tall_up.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), flags);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vec3d vec3d = state.func_191059_e(worldIn, pos);
        return SHAPE.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 10;
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, BlockState state) {
        DoubleCattailBlock doubleplantblock = (DoubleCattailBlock)SwampExBlocks.TALL_CATTAIL.get();
        IFluidState ifluidstateUp = worldIn.func_204610_c(pos.func_177984_a());
        if (doubleplantblock.func_176223_P().func_196955_c((IWorldReader)worldIn, pos) && (worldIn.func_175623_d(pos.func_177984_a()) || Boolean.valueOf(ifluidstateUp.func_206884_a(FluidTags.field_206959_a) && ifluidstateUp.func_206882_g() == 8).booleanValue())) {
            doubleplantblock.placeAt((IWorld)worldIn, pos, 2);
        }
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        int chance;
        super.func_196267_b(state, worldIn, pos, random);
        int n = chance = worldIn.func_180495_p(pos.func_177977_b()).isFertile((IBlockReader)worldIn, pos.func_177977_b()) ? 10 : 12;
        if (worldIn.func_201669_a(pos.func_177984_a(), 0) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(chance) == 0 ? 1 : 0) != 0)) {
            DoubleCattailBlock doubleplantblock = (DoubleCattailBlock)SwampExBlocks.TALL_CATTAIL.get();
            if (doubleplantblock.func_176223_P().func_196955_c((IWorldReader)worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150458_ak) {
                doubleplantblock.placeAt((IWorld)worldIn, pos, 2);
            }
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return this.func_200014_a_(world.func_180495_p(pos.func_177977_b()), (IBlockReader)world, pos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!state.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(state, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }
}

