/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class VerticalSlabBlock
extends Block
implements IWaterLoggable {
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.func_177709_a((String)"type", VerticalSlabType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public VerticalSlabBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)VerticalSlabType.NORTH))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_220074_n(BlockState state) {
        return state.func_177229_b(TYPE) != VerticalSlabType.DOUBLE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TYPE, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ((VerticalSlabType)((Object)state.func_177229_b(VerticalSlabBlock.TYPE))).shape;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = context.func_195991_k().func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this) {
            return (BlockState)((BlockState)blockstate.func_206870_a(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        IFluidState fluid = context.func_195991_k().func_204610_c(blockpos);
        BlockState retState = (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
        Direction direction = VerticalSlabBlock.getDirectionForPlacement(context);
        VerticalSlabType type = VerticalSlabType.fromDirection(direction);
        return (BlockState)retState.func_206870_a(TYPE, (Comparable)((Object)type));
    }

    private static Direction getDirectionForPlacement(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        if (direction.func_176740_k() != Direction.Axis.Y) {
            return direction;
        }
        Vec3d vec = context.func_221532_j().func_178788_d(new Vec3d((Vec3i)context.func_195995_a())).func_178786_a(0.5, 0.0, 0.5);
        double angle = Math.atan2(vec.field_72450_a, vec.field_72449_c) * -180.0 / Math.PI;
        return Direction.func_176733_a((double)angle).func_176734_d();
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        ItemStack itemstack = useContext.func_195996_i();
        VerticalSlabType slabtype = (VerticalSlabType)((Object)state.func_177229_b(TYPE));
        return slabtype != VerticalSlabType.DOUBLE && itemstack.func_77973_b() == this.func_199767_j() && useContext.func_196012_c() && useContext.func_196000_l() == slabtype.direction && VerticalSlabBlock.getDirectionForPlacement(useContext) == slabtype.direction;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        return state.func_177229_b(TYPE) != VerticalSlabType.DOUBLE && super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.func_177229_b(TYPE) != VerticalSlabType.DOUBLE && super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return type == PathType.WATER && worldIn.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
    }

    public static enum VerticalSlabType implements IStringSerializable
    {
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST),
        DOUBLE(null);

        private final String name;
        public final Direction direction;
        public final VoxelShape shape;

        private VerticalSlabType(Direction directionIn) {
            this.direction = directionIn;
            String string2 = this.name = this.direction == null ? "double" : this.direction.func_176610_l();
            if (this.direction == null) {
                this.shape = VoxelShapes.func_197868_b();
            } else {
                double min = 0.0;
                double max = 8.0;
                if (this.direction.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
                    min = 8.0;
                    max = 16.0;
                }
                this.shape = this.direction.func_176740_k() == Direction.Axis.X ? Block.func_208617_a((double)min, (double)0.0, (double)0.0, (double)max, (double)16.0, (double)16.0) : Block.func_208617_a((double)0.0, (double)0.0, (double)min, (double)16.0, (double)16.0, (double)max);
            }
        }

        public String toString() {
            return this.name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static VerticalSlabType fromDirection(Direction direction) {
            for (VerticalSlabType type : VerticalSlabType.values()) {
                if (type.direction == null || direction != type.direction) continue;
                return type;
            }
            return null;
        }
    }
}

