/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.common.block.fluid;

import com.farcr.swampexpansion.core.registries.SwampExBlocks;
import com.farcr.swampexpansion.core.registries.SwampExFluids;
import com.farcr.swampexpansion.core.registries.SwampExItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;

public abstract class MudFluid
extends FlowingFluid {
    public Fluid func_210197_e() {
        return SwampExFluids.FLOWING_MUD;
    }

    public Fluid func_210198_f() {
        return SwampExFluids.MUD;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public Item func_204524_b() {
        return (Item)SwampExItems.MUD_BUCKET.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_204522_a(World worldIn, BlockPos pos, IFluidState state, Random random) {
        if (!state.func_206889_d() && !((Boolean)state.func_177229_b((IProperty)field_207209_a)).booleanValue()) {
            if (random.nextInt(64) == 0) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
            }
        } else if (random.nextInt(10) == 0) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197605_P, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)((float)pos.func_177956_o() + random.nextFloat()), (double)((float)pos.func_177952_p() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public boolean func_207185_a(Tag<Fluid> tagIn) {
        return tagIn == FluidTags.field_206959_a;
    }

    protected boolean func_205579_d() {
        return false;
    }

    protected void func_205580_a(IWorld world, BlockPos pos, BlockState state) {
        TileEntity tileentity = state.func_177230_c().func_149716_u() ? world.func_175625_s(pos) : null;
        Block.func_220059_a((BlockState)state, (World)world.func_201672_e(), (BlockPos)pos, (TileEntity)tileentity);
    }

    public int func_185698_b(IWorldReader reader) {
        return 1;
    }

    public BlockState func_204527_a(IFluidState state) {
        return (BlockState)((Block)SwampExBlocks.MUD.get()).func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(MudFluid.func_207205_e((IFluidState)state)));
    }

    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn == SwampExFluids.MUD || fluidIn == SwampExFluids.FLOWING_MUD;
    }

    public int func_204528_b(IWorldReader reader) {
        return 2;
    }

    public int func_205569_a(IWorldReader reader) {
        return 6;
    }

    public boolean func_215665_a(IFluidState state, IBlockReader reader, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.func_207185_a(FluidTags.field_206959_a);
    }

    protected float func_210195_d() {
        return 100.0f;
    }

    protected FluidAttributes createAttributes() {
        FluidAttributes.Builder builder = FluidAttributes.builder((ResourceLocation)new ResourceLocation("swampexpansion", "block/mud_still"), (ResourceLocation)new ResourceLocation("swampexpansion", "block/mud_flow"));
        builder.luminosity(15).density(500).viscosity(1000).translationKey("mud").overlay(new ResourceLocation("swampexpansion", "block/mud_overlay"));
        return builder.build((Fluid)this);
    }

    public static class Flowing
    extends MudFluid {
        public Flowing() {
            this.setRegistryName(new ResourceLocation("swampexpansion", "flowing_mud"));
        }

        protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new IProperty[]{field_207210_b});
        }

        public int func_207192_d(IFluidState state) {
            return (Integer)state.func_177229_b((IProperty)field_207210_b);
        }

        public boolean func_207193_c(IFluidState state) {
            return false;
        }
    }

    public static class Source
    extends MudFluid {
        public Source() {
            this.setRegistryName(new ResourceLocation("swampexpansion", "mud"));
        }

        public int func_207192_d(IFluidState state) {
            return 8;
        }

        public boolean func_207193_c(IFluidState state) {
            return true;
        }
    }
}

