/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.common.world.gen.feature;

import com.farcr.swampexpansion.common.block.CattailBlock;
import com.farcr.swampexpansion.core.registries.SwampExBlocks;
import com.farcr.swampexpansion.core.registries.SwampExFeatures;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class CattailsFeature
extends Feature<NoFeatureConfig> {
    public CattailsFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, NoFeatureConfig config) {
        boolean place = false;
        for (int i = 0; i < 512; ++i) {
            BlockPos placePos = pos.func_177982_a(random.nextInt(8) - random.nextInt(4), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(4));
            if (i == 0 && !world.func_201671_F(placePos)) {
                return false;
            }
            if (!world.func_201671_F(placePos) && !world.func_175623_d(placePos) || !world.func_175623_d(placePos.func_177984_a()) || placePos.func_177956_o() >= world.func_201672_e().func_201675_m().getHeight() - 2 || !((Block)SwampExBlocks.CATTAIL.get()).func_176223_P().func_196955_c((IWorldReader)world, placePos)) continue;
            ((CattailBlock)SwampExBlocks.CATTAIL.get()).placeAt(world, placePos, 2);
            place = true;
        }
        return place;
    }

    public static void addFeature() {
        ForgeRegistries.BIOMES.getValues().forEach(CattailsFeature::generate);
    }

    public static void generate(Biome biome) {
        if (biome.func_150561_m() != Biome.TempCategory.COLD && biome.func_201856_r() == Biome.Category.SWAMP || biome.func_201856_r() == Biome.Category.RIVER) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)SwampExFeatures.CATTAILS, (IFeatureConfig)new NoFeatureConfig(), (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(12)));
        }
    }
}

