/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.common.world.gen.feature;

import com.farcr.swampexpansion.core.registries.SwampExBlocks;
import com.farcr.swampexpansion.core.registries.SwampExFeatures;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class HangingWillowLeavesFeature
extends Feature<NoFeatureConfig> {
    public HangingWillowLeavesFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, NoFeatureConfig config) {
        boolean place = false;
        for (int i = 0; i < 128; ++i) {
            BlockPos placePos = pos.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(2) - random.nextInt(2), random.nextInt(8) - random.nextInt(8));
            if (!world.func_175623_d(placePos) || placePos.func_177956_o() >= world.func_201672_e().func_201675_m().getHeight() - 2 || world.func_180495_p(placePos.func_177984_a()).func_177230_c() != SwampExBlocks.WILLOW_LEAVES.get() || !((Block)SwampExBlocks.HANGING_WILLOW_LEAVES.get()).func_176223_P().func_196955_c((IWorldReader)world, placePos)) continue;
            world.func_180501_a(placePos, ((Block)SwampExBlocks.HANGING_WILLOW_LEAVES.get()).func_176223_P(), 2);
            place = true;
        }
        return place;
    }

    public static void addFeature() {
        ForgeRegistries.BIOMES.getValues().forEach(HangingWillowLeavesFeature::generate);
    }

    public static void generate(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.SWAMP) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)SwampExFeatures.HANGING_WILLOW_LEAVES, (IFeatureConfig)new NoFeatureConfig(), (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(128)));
        }
    }
}

