/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.core;

import com.farcr.swampexpansion.client.render.WillowBoatRenderer;
import com.farcr.swampexpansion.common.block.fluid.MudFluid;
import com.farcr.swampexpansion.common.entity.WillowBoatEntity;
import com.farcr.swampexpansion.common.worldgen.FeatureEditor;
import com.farcr.swampexpansion.core.registries.SwampExBlocks;
import com.farcr.swampexpansion.core.registries.SwampExData;
import com.farcr.swampexpansion.core.registries.SwampExFeatures;
import com.farcr.swampexpansion.core.registries.SwampExItems;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.fluid.IFluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="swampexpansion")
@Mod.EventBusSubscriber(modid="swampexpansion")
public class SwampExpansion {
    public SwampExpansion() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupCommon);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::initSetupClient);
        SwampExBlocks.BLOCKS.register(modEventBus);
        SwampExItems.ITEMS.register(modEventBus);
        SwampExBlocks.PAINTINGS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void initSetupClient() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        SwampExData.registerBlockData();
        FeatureEditor.overrideFeatures();
        SwampExFeatures.generateFeatures();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupClient(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(WillowBoatEntity.class, WillowBoatRenderer::new);
        SwampExData.registerBlockColors();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onFogColor(EntityViewRenderEvent.FogColors event) {
        ActiveRenderInfo info = event.getInfo();
        IFluidState state = info.func_216771_k();
        if (state.func_206886_c() instanceof MudFluid) {
            event.setRed(0.140625f);
            event.setGreen(0.0625f);
            event.setBlue(0.015625f);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        ActiveRenderInfo info = event.getInfo();
        IFluidState state = info.func_216771_k();
        if (state.func_206886_c() instanceof MudFluid) {
            GlStateManager.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            event.setDensity(1.0f);
            event.setCanceled(true);
        }
    }
}

