/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.core.registries;

import com.farcr.swampexpansion.common.world.gen.feature.CattailsFeature;
import com.farcr.swampexpansion.common.world.gen.feature.HangingWillowLeavesFeature;
import com.farcr.swampexpansion.common.world.gen.feature.WillowTreeFeature;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="swampexpansion", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SwampExFeatures {
    public static Feature CATTAILS = (Feature)new CattailsFeature(NoFeatureConfig::func_214639_a).setRegistryName("cattails");
    public static Feature HANGING_WILLOW_LEAVES = (Feature)new HangingWillowLeavesFeature(NoFeatureConfig::func_214639_a).setRegistryName("hanging_willow_leaves");
    public static Feature WILLOW_TREE = (Feature)new WillowTreeFeature(NoFeatureConfig::func_214639_a).setRegistryName("willow_tree");

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Feature[]{CATTAILS, HANGING_WILLOW_LEAVES, WILLOW_TREE});
    }

    public static void addMiscSwampFeatures() {
        ForgeRegistries.BIOMES.getValues().forEach(SwampExFeatures::generate);
    }

    public static void generate(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.SWAMP) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202292_al, (IFeatureConfig)new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202339_q}, new IFeatureConfig[]{IFeatureConfig.field_202429_e}, new float[]{0.5f}, Feature.field_202301_A, (IFeatureConfig)IFeatureConfig.field_202429_e), (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.5f, 1)));
            DefaultBiomeFeatures.func_222294_Q((Biome)biome);
        }
    }

    public static void generateFeatures() {
        CattailsFeature.addFeature();
        HangingWillowLeavesFeature.addFeature();
        SwampExFeatures.addMiscSwampFeatures();
    }
}

