/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraheads;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.WallSkullBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import shetiphian.terraheads.TileEntityMobHead;

public class BlockMobHead {

    public static enum Type {
        VILLAGER(4.0, 0.0, 4.0, 12.0, 10.0, 12.0, 4.0, 3.0, 8.0, 12.0, 13.0, 16.0),
        ZOMBIE_VILLAGER(4.0, 0.0, 4.0, 12.0, 10.0, 12.0, 4.0, 3.0, 8.0, 12.0, 13.0, 16.0),
        ILLAGER(4.0, 0.0, 4.0, 12.0, 10.0, 12.0, 4.0, 3.0, 8.0, 12.0, 13.0, 16.0),
        WANDERING_TRADER(4.0, 0.0, 4.0, 12.0, 10.0, 12.0, 4.0, 3.0, 8.0, 12.0, 13.0, 16.0),
        WITCH(4.0, 0.0, 4.0, 12.0, 10.0, 12.0, 4.0, 3.0, 8.0, 12.0, 13.0, 16.0);

        private final VoxelShape shapeGround;
        private final VoxelShape[] shapeWall;

        private Type(double gx1, double gy1, double gz1, double gx2, double gy2, double gz2, double wx1, double wy1, double wz1, double wx2, double wy2, double wz2) {
            this.shapeGround = Block.func_208617_a((double)gx1, (double)gy1, (double)gz1, (double)gx2, (double)gy2, (double)gz2);
            this.shapeWall = new VoxelShape[]{Block.func_208617_a((double)(16.0 - wx2), (double)wy1, (double)(16.0 - wz2), (double)(16.0 - wx1), (double)wy2, (double)(16.0 - wz1)), Block.func_208617_a((double)wz2, (double)wy1, (double)(16.0 - wx1), (double)wz1, (double)wy2, (double)(16.0 - wx2)), Block.func_208617_a((double)wx1, (double)wy1, (double)wz1, (double)wx2, (double)wy2, (double)wz2), Block.func_208617_a((double)(16.0 - wz1), (double)wy1, (double)wx1, (double)(16.0 - wz2), (double)wy2, (double)wx2)};
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public VoxelShape getShapeGround() {
            return this.shapeGround;
        }

        public VoxelShape[] getShapeWall() {
            return this.shapeWall;
        }
    }

    public static class Wall
    extends WallSkullBlock
    implements MobHead {
        private final Type type;

        public Wall(Type type, Block block) {
            super((SkullBlock.ISkullType)SkullBlock.Types.SKELETON, AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(1.0f).func_222379_b(block));
            this.type = type;
        }

        public TileEntity func_196283_a_(IBlockReader world) {
            return new TileEntityMobHead();
        }

        public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
            return this.type.shapeWall[((Direction)state.func_177229_b((Property)field_196302_a)).func_176736_b()];
        }

        @Override
        public Type getType() {
            return this.type;
        }

        public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
            ItemStack stack = super.func_185473_a(world, pos, state);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityMobHead) {
                CompoundNBT nbt = stack.func_190925_c("BlockEntityTag");
                nbt.func_74778_a("data1", ((TileEntityMobHead)tile).getData1());
                nbt.func_74778_a("data2", ((TileEntityMobHead)tile).getData2());
            }
            return stack;
        }
    }

    public static class Ground
    extends SkullBlock
    implements MobHead {
        private final Type type;

        public Ground(Type type) {
            super((SkullBlock.ISkullType)SkullBlock.Types.SKELETON, AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(1.0f));
            this.type = type;
        }

        public TileEntity func_196283_a_(IBlockReader world) {
            return new TileEntityMobHead();
        }

        public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
            return this.type.shapeGround;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
            ItemStack stack = super.func_185473_a(world, pos, state);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityMobHead) {
                CompoundNBT nbt = stack.func_190925_c("BlockEntityTag");
                nbt.func_74778_a("data1", ((TileEntityMobHead)tile).getData1());
                nbt.func_74778_a("data2", ((TileEntityMobHead)tile).getData2());
            }
            return stack;
        }
    }

    public static interface MobHead {
        public Type getType();
    }
}

