/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraheads;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import shetiphian.core.common.MyCreativeTab;
import shetiphian.core.common.RegistryHelper;
import shetiphian.terraheads.BlockMobHead;
import shetiphian.terraheads.ItemMobHead;
import shetiphian.terraheads.TileEntityMobHead;
import shetiphian.terraheads.Values;

@Mod.EventBusSubscriber(modid="terraheads", bus=Mod.EventBusSubscriber.Bus.MOD)
class Register {
    Register() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (BlockMobHead.Type type : BlockMobHead.Type.values()) {
            String name = type.toString();
            Block head = RegistryHelper.register((IForgeRegistry)registry, (Block)new BlockMobHead.Ground(type), (String)("terraheads:" + name + "_head"));
            Values.blockMobHead.put(type, head);
            Values.blockMobHeadWall.put(type, RegistryHelper.register((IForgeRegistry)registry, (Block)new BlockMobHead.Wall(type, head), (String)("terraheads:" + name + "_wall_head")));
        }
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        ArrayList<Block> mobHeadBlocks = new ArrayList<Block>();
        mobHeadBlocks.addAll(Values.blockMobHead.values());
        mobHeadBlocks.addAll(Values.blockMobHeadWall.values());
        Values.tileMobHead = RegistryHelper.register((IForgeRegistry)registry, TileEntityMobHead::new, (String)"terraheads:mob_head", (Block[])mobHeadBlocks.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Block block;
        IForgeRegistry registry = event.getRegistry();
        Values.tabTerraHeads = new MyCreativeTab("TerraHeads", MyCreativeTab.MyTabType.SEARCH_L);
        Item.Properties stackable = new Item.Properties().func_200916_a((ItemGroup)Values.tabTerraHeads);
        for (BlockMobHead.Type type : BlockMobHead.Type.values()) {
            RegistryHelper.register((IForgeRegistry)registry, (BlockItem)new ItemMobHead(type, Values.blockMobHead.get((Object)type), Values.blockMobHeadWall.get((Object)type), stackable));
        }
        if (!Values.blockMobHead.isEmpty() && (block = Values.blockMobHead.get((Object)BlockMobHead.Type.WANDERING_TRADER)) != null) {
            Values.tabTerraHeads.setIcon(new ItemStack((IItemProvider)block));
        }
    }
}

