/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.item.ItemColorizer;
import shetiphian.terraqueous.common.misc.BlueFlowerHandler;
import shetiphian.terraqueous.common.misc.PlantFunctions;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;

@Mod.EventBusSubscriber
public class Configuration {
    private static final ForgeConfigSpec.Builder BUILDER_CLIENT = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder BUILDER_COMMON = new ForgeConfigSpec.Builder();
    public static final Menu_General GENERAL = new Menu_General(BUILDER_COMMON);
    public static final Menu_GUI GUI_STYLE = new Menu_GUI(BUILDER_CLIENT);
    public static final Menu_Doodads DOODADS = new Menu_Doodads(BUILDER_COMMON);
    public static final Menu_FlowerPots FLOWERPOTS = new Menu_FlowerPots(BUILDER_CLIENT);
    public static final Menu_Plants PLANTS = new Menu_Plants(BUILDER_COMMON);
    public static final Menu_Trees TREES = new Menu_Trees(BUILDER_COMMON);
    public static final Menu_StormForge STORMFORGE = new Menu_StormForge(BUILDER_COMMON);
    public static final Menu_WaterPearl WATER_PEARL = new Menu_WaterPearl(BUILDER_COMMON);
    public static final Menu_Tweaks TWEAKS = new Menu_Tweaks(BUILDER_COMMON);
    public static final Menu_LootTables LOOT_TABLES = new Menu_LootTables(BUILDER_COMMON);
    public static final Menu_Generator GENERATOR = new Menu_Generator(BUILDER_COMMON);
    public static final Menu_Integration INTEGRATION = new Menu_Integration(BUILDER_COMMON);
    static final ForgeConfigSpec SPEC_CLIENT = BUILDER_CLIENT.build();
    static final ForgeConfigSpec SPEC_COMMON = BUILDER_COMMON.build();
    public static boolean CAN_PROCESS_TAGS = false;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        Configuration.process();
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading configEvent) {
        Configuration.process();
    }

    public static void process() {
        BlueFlowerHandler.INSTANCE.buildList((List)Configuration.GENERAL.listTricksterBloomEffects.get());
        PlantFunctions.load();
        Values.rebuildDustList = true;
        Values.flowerpotOverrides.clear();
        ItemColorizer.buildClassLookUpMap((List)TWEAKS.colorizerClassMappings.get());
        if (CAN_PROCESS_TAGS) {
            Configuration.processTagLists();
        }
    }

    public static void processTagLists() {
        Configuration.processRenderList(TileEntityFlowerPot.RenderStyle.CROSS_SINGLE.ordinal(), (List)FLOWERPOTS.forceSingleCrossRender.get());
        Configuration.processRenderList(TileEntityFlowerPot.RenderStyle.CROSS_MULTI.ordinal(), (List)FLOWERPOTS.forceMultiCrossRender.get());
        Configuration.processRenderList(TileEntityFlowerPot.RenderStyle.BLOCK.ordinal(), (List)FLOWERPOTS.forceBlockRender.get());
        Configuration.processRenderList(TileEntityFlowerPot.RenderStyle.PANE.ordinal(), (List)FLOWERPOTS.forcePaneRender.get());
        Configuration.processRenderList(TileEntityFlowerPot.RenderStyle.TALL.ordinal(), (List)FLOWERPOTS.forceTallRender.get());
    }

    private static void processRenderList(int style, List<? extends String> names) {
        for (String string : names) {
            if (Strings.isNullOrEmpty((String)string)) continue;
            if (string.toLowerCase().startsWith("tag|")) {
                String nameId;
                String string2 = string.substring(4);
                String modId = string2.contains(":") ? string2.split(":")[0] : "minecraft";
                String string3 = nameId = string2.contains(":") ? string2.split(":")[1] : string2;
                ITag.INamedTag tag = ItemTags.func_199901_a((String)(modId + ":" + nameId.replaceAll("\\.", "/")));
                if (tag == null) continue;
                for (Item item : tag.func_230236_b_()) {
                    ResourceLocation registration;
                    if (item == null || (registration = item.getRegistryName()) == null) continue;
                    Values.flowerpotOverrides.put(registration.toString(), (byte)style);
                }
                continue;
            }
            Values.flowerpotOverrides.put(string, (byte)style);
        }
    }

    public static class Menu_Integration {
        public ForgeConfigSpec.BooleanValue enableCurios;
        public ForgeConfigSpec.BooleanValue enableIndustrialForegoing;

        Menu_Integration(ForgeConfigSpec.Builder builder) {
            builder.comment("Mod integration can be disabled to solve compatibility issues, remove unwanted/unneeded features, etc.").push("integration");
            this.enableCurios = builder.comment("CloudTalisman, BurniumBelt, ToonTrotters, and WaterPearl will function while equipped as a Curio").define("enableCurios", true);
            this.enableIndustrialForegoing = builder.comment("Adds: fruit to the BioReactor, endimium/burnium ore to the LaserDrill, and flowers/cactus pear/pineapple/banana stalk to the Plant Gatherer").define("enableIndustrialForegoing", true);
            builder.pop();
        }
    }

    public static class Menu_Generator {
        public ForgeConfigSpec.BooleanValue generateClouds;
        public ForgeConfigSpec.BooleanValue generateDoodads;
        public ForgeConfigSpec.BooleanValue generateFlowers;
        public ForgeConfigSpec.BooleanValue generatePlants;
        public ForgeConfigSpec.BooleanValue generateTrees;
        public SubMenu_DimBlacklist DIM_BLACKLIST;
        public SubMenu_Clouds CLOUDS;
        public SubMenu_Doodads DOODADS;
        public SubMenu_Flowers FLOWERS;
        public SubMenu_Plants PLANTS;
        public SubMenu_Trees TREES;
        public SubMenu_Village VILLAGE;

        Menu_Generator(ForgeConfigSpec.Builder builder) {
            builder.comment("Options used by the world generator").push("world_gen");
            this.generateClouds = builder.comment(new String[]{"This is a general on/off toggle", "For more control see the sub menu"}).define("generate_clouds", true);
            this.generateDoodads = builder.comment(new String[]{"This is a general on/off toggle", "For more control see the sub menu"}).define("generate_doodads", true);
            this.generateFlowers = builder.comment(new String[]{"This is a general on/off toggle", "For more control see the sub menu"}).define("generate_flowers", true);
            this.generatePlants = builder.comment(new String[]{"This is a general on/off toggle", "For more control see the sub menu"}).define("generate_plants", true);
            this.generateTrees = builder.comment(new String[]{"This is a general on/off toggle", "For more control see the sub menu"}).define("generate_trees", true);
            this.DIM_BLACKLIST = new SubMenu_DimBlacklist(builder);
            this.CLOUDS = new SubMenu_Clouds(builder);
            this.DOODADS = new SubMenu_Doodads(builder);
            this.FLOWERS = new SubMenu_Flowers(builder);
            this.PLANTS = new SubMenu_Plants(builder);
            this.TREES = new SubMenu_Trees(builder);
            this.VILLAGE = new SubMenu_Village(builder);
            builder.pop();
        }

        public static class SubMenu_Village {
            public ForgeConfigSpec.BooleanValue generateVillage_Vineyard;
            public ForgeConfigSpec.BooleanValue enableDeathFruitVines;
            public ForgeConfigSpec.BooleanValue enableLifeFruitVines;
            public ForgeConfigSpec.BooleanValue enableGrapeVines;

            SubMenu_Village(ForgeConfigSpec.Builder builder) {
                builder.comment(" ").push("village");
                builder.pop();
            }
        }

        public static class SubMenu_Trees {
            public ForgeConfigSpec.IntValue attempts_Beach;
            public ForgeConfigSpec.IntValue attempts_Forest;
            public ForgeConfigSpec.IntValue attempts_Hills;
            public ForgeConfigSpec.IntValue attempts_Jungle;
            public ForgeConfigSpec.IntValue attempts_Mountain;
            public ForgeConfigSpec.IntValue attempts_Plains;
            public ForgeConfigSpec.DoubleValue chance_Beach;
            public ForgeConfigSpec.DoubleValue chance_Forest;
            public ForgeConfigSpec.DoubleValue chance_Hills;
            public ForgeConfigSpec.DoubleValue chance_Jungle;
            public ForgeConfigSpec.DoubleValue chance_Mountain;
            public ForgeConfigSpec.DoubleValue chance_Plains;
            public ForgeConfigSpec.BooleanValue generate_Apple;
            public ForgeConfigSpec.BooleanValue generate_Cherry;
            public ForgeConfigSpec.BooleanValue generate_Orange;
            public ForgeConfigSpec.BooleanValue generate_Pear;
            public ForgeConfigSpec.BooleanValue generate_Peach;
            public ForgeConfigSpec.BooleanValue generate_Mango;
            public ForgeConfigSpec.BooleanValue generate_Lemon;
            public ForgeConfigSpec.BooleanValue generate_Plum;
            public ForgeConfigSpec.BooleanValue generate_Coconut;
            public ForgeConfigSpec.BooleanValue generate_Banana;
            public ForgeConfigSpec.BooleanValue generate_Mulberry;

            SubMenu_Trees(ForgeConfigSpec.Builder builder) {
                builder.comment(" ").push("trees");
                this.attempts_Beach = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_biometype_beach", 2, 0, 10);
                this.attempts_Forest = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_biometype_forest", 1, 0, 10);
                this.attempts_Hills = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_biometype_hills", 1, 0, 10);
                this.attempts_Jungle = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_biometype_jungle", 2, 0, 10);
                this.attempts_Mountain = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_biometype_mountain", 1, 0, 10);
                this.attempts_Plains = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_biometype_plains", 1, 0, 10);
                this.chance_Beach = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_biometype_beach", 0.02, 0.0, 1.0);
                this.chance_Forest = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_biometype_forest", 0.02, 0.0, 1.0);
                this.chance_Hills = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_biometype_hills", 0.01, 0.0, 1.0);
                this.chance_Jungle = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_biometype_jungle", 0.04, 0.0, 1.0);
                this.chance_Mountain = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_biometype_mountain", 0.015, 0.0, 1.0);
                this.chance_Plains = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_biometype_plains", 0.01, 0.0, 1.0);
                this.generate_Apple = builder.comment(new String[]{"Found in the following biome types:", "Forest"}).define("generate_apple", true);
                this.generate_Cherry = builder.comment(new String[]{"Found in the following biome types:", "Hills"}).define("generate_cherry", true);
                this.generate_Orange = builder.comment(new String[]{"Found in the following biome types:", "Hills"}).define("generate_orange", true);
                this.generate_Pear = builder.comment(new String[]{"Found in the following biome types:", "Forest"}).define("generate_pear", true);
                this.generate_Peach = builder.comment(new String[]{"Found in the following biome types:", "Mountain"}).define("generate_peach", true);
                this.generate_Mango = builder.comment(new String[]{"Found in the following biome types:", "Forest"}).define("generate_mango", true);
                this.generate_Lemon = builder.comment(new String[]{"Found in the following biome types:", "Hills"}).define("generate_lemon", true);
                this.generate_Plum = builder.comment(new String[]{"Found in the following biome types:", "Hills"}).define("generate_plum", true);
                this.generate_Coconut = builder.comment(new String[]{"Found in the following biome types:", "Beach"}).define("generate_coconut", true);
                this.generate_Banana = builder.comment(new String[]{"Found in the following biome types:", "Jungle"}).define("generate_banana", true);
                this.generate_Mulberry = builder.comment(new String[]{"Found in the following biome types:", "Plains"}).define("generate_mulberry", true);
                builder.pop();
            }
        }

        public static class SubMenu_Flowers {
            public ForgeConfigSpec.IntValue attempts_Forest;
            public ForgeConfigSpec.IntValue attempts_Jungle;
            public ForgeConfigSpec.IntValue attempts_Magical;
            public ForgeConfigSpec.IntValue attempts_Mountain;
            public ForgeConfigSpec.IntValue attempts_Plains;
            public ForgeConfigSpec.IntValue attempts_Water;
            public ForgeConfigSpec.DoubleValue chance_Forest;
            public ForgeConfigSpec.DoubleValue chance_Jungle;
            public ForgeConfigSpec.DoubleValue chance_Magical;
            public ForgeConfigSpec.DoubleValue chance_Mountain;
            public ForgeConfigSpec.DoubleValue chance_Plains;
            public ForgeConfigSpec.DoubleValue chance_Water;
            public ForgeConfigSpec.BooleanValue perBiomeFlowers;

            SubMenu_Flowers(ForgeConfigSpec.Builder builder) {
                builder.comment(" ").push("flowers");
                this.attempts_Forest = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_biometype_forest", 1, 0, 10);
                this.attempts_Jungle = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_biometype_jungle", 1, 0, 10);
                this.attempts_Magical = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_biometype_magical", 1, 0, 10);
                this.attempts_Mountain = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_biometype_mountain", 1, 0, 10);
                this.attempts_Plains = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_biometype_plains", 1, 0, 10);
                this.attempts_Water = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_biometype_water", 1, 0, 10);
                this.chance_Forest = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_biometype_forest", 0.35, 0.0, 1.0);
                this.chance_Jungle = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_biometype_jungle", 0.35, 0.0, 1.0);
                this.chance_Magical = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_biometype_magical", 0.35, 0.0, 1.0);
                this.chance_Mountain = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_biometype_mountain", 0.35, 0.0, 1.0);
                this.chance_Plains = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_biometype_plains", 0.35, 0.0, 1.0);
                this.chance_Water = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_biometype_water", 0.35, 0.0, 1.0);
                this.perBiomeFlowers = builder.comment("While true flowers generated will differ by biome type").define("per_biome_flowers", true);
                builder.pop();
            }
        }

        public static class SubMenu_Doodads {
            public ForgeConfigSpec.IntValue attempts_Stick;
            public ForgeConfigSpec.IntValue attempts_Stone;
            public ForgeConfigSpec.IntValue attempts_Bone;
            public ForgeConfigSpec.IntValue attempts_Endimium;
            public ForgeConfigSpec.IntValue attempts_Burnium;
            public ForgeConfigSpec.DoubleValue chance_Stick;
            public ForgeConfigSpec.DoubleValue chance_Stone;
            public ForgeConfigSpec.DoubleValue chance_Bone;
            public ForgeConfigSpec.DoubleValue chance_Endimium;
            public ForgeConfigSpec.DoubleValue chance_Burnium;
            public ForgeConfigSpec.BooleanValue generate_Stick;
            public ForgeConfigSpec.BooleanValue generate_Stone;
            public ForgeConfigSpec.BooleanValue generate_Bone;
            public ForgeConfigSpec.BooleanValue generate_Endimium;
            public ForgeConfigSpec.BooleanValue generate_Burnium;

            SubMenu_Doodads(ForgeConfigSpec.Builder builder) {
                builder.comment(" ").push("doodads");
                this.attempts_Stick = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_stick", 2, 0, 10);
                this.attempts_Stone = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_stone", 4, 0, 10);
                this.attempts_Bone = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_bone", 1, 0, 10);
                this.attempts_Endimium = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_endimium", 1, 0, 10);
                this.attempts_Burnium = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_burnium", 1, 0, 10);
                this.chance_Stick = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_stick", 0.4, 0.0, 1.0);
                this.chance_Stone = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_stone", 0.1, 0.0, 1.0);
                this.chance_Bone = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_bone", 0.2, 0.0, 1.0);
                this.chance_Endimium = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_endimium", 0.3, 0.0, 1.0);
                this.chance_Burnium = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_burnium", 0.3, 0.0, 1.0);
                this.generate_Stick = builder.comment("").define("generate_stick", true);
                this.generate_Stone = builder.comment("").define("generate_stone", true);
                this.generate_Bone = builder.comment("").define("generate_bone", true);
                this.generate_Endimium = builder.comment("").define("generate_endimium", true);
                this.generate_Burnium = builder.comment("").define("generate_burnium", true);
                builder.pop();
            }
        }

        public static class SubMenu_Plants {
            public ForgeConfigSpec.IntValue attempts_Pineapple;
            public ForgeConfigSpec.IntValue attempts_CactusPear;
            public ForgeConfigSpec.DoubleValue chance_Pineapple;
            public ForgeConfigSpec.DoubleValue chance_CactusPear;
            public ForgeConfigSpec.BooleanValue generate_Pineapple;
            public ForgeConfigSpec.BooleanValue generate_CactusPear;

            SubMenu_Plants(ForgeConfigSpec.Builder builder) {
                builder.comment(" ").push("plants");
                this.attempts_Pineapple = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_pineapple", 1, 0, 10);
                this.attempts_CactusPear = builder.comment("Number of placement positions picked on each generation pass").defineInRange("attempts_cactus", 1, 0, 10);
                this.chance_Pineapple = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_pineapple", 0.75, 0.0, 1.0);
                this.chance_CactusPear = builder.comment("Chance that each placement position has at being reviewed by the generator").defineInRange("chance_cactus", 0.25, 0.0, 1.0);
                this.generate_Pineapple = builder.comment("Can Pineapples Generate").define("generate_pineapple", true);
                this.generate_CactusPear = builder.comment("Can Prickly Pear Cactus Generate").define("generate_cactus", true);
                builder.pop();
            }
        }

        public static class SubMenu_Clouds {
            public ForgeConfigSpec.IntValue height_Override;
            public ForgeConfigSpec.IntValue minSize_Light;
            public ForgeConfigSpec.IntValue maxSize_Light;
            public ForgeConfigSpec.IntValue minSize_Dense;
            public ForgeConfigSpec.IntValue maxSize_Dense;
            public ForgeConfigSpec.IntValue minSize_Storm;
            public ForgeConfigSpec.IntValue maxSize_Storm;
            public ForgeConfigSpec.DoubleValue chance_light;
            public ForgeConfigSpec.DoubleValue chance_dense;
            public ForgeConfigSpec.DoubleValue chance_storm;
            public ForgeConfigSpec.BooleanValue generate_Light;
            public ForgeConfigSpec.BooleanValue generate_Dense;
            public ForgeConfigSpec.BooleanValue generate_Storm;

            SubMenu_Clouds(ForgeConfigSpec.Builder builder) {
                builder.comment(" ").push("clouds");
                this.height_Override = builder.comment("A value greater then zero will be used as the clouds base generation height, otherwise its 75% of the worlds height").defineInRange("height_override", 0, 0, 2048);
                this.minSize_Light = builder.comment("Minimum number of blocks in the cloud").defineInRange("size_light_minimum", 16, 8, 64);
                this.maxSize_Light = builder.comment("Maximum number of blocks in the cloud").defineInRange("size_light_maximum", 32, 16, 128);
                this.minSize_Dense = builder.comment("Minimum number of blocks in the cloud").defineInRange("size_dense_minimum", 24, 8, 64);
                this.maxSize_Dense = builder.comment("Maximum number of blocks in the cloud").defineInRange("size_dense_maximum", 40, 16, 128);
                this.minSize_Storm = builder.comment("Minimum number of blocks in the cloud").defineInRange("size_storm_minimum", 32, 8, 64);
                this.maxSize_Storm = builder.comment("Maximum number of blocks in the cloud").defineInRange("size_storm_maximum", 48, 16, 128);
                this.chance_light = builder.comment("").defineInRange("chance_light", 0.03, 0.0, 1.0);
                this.chance_dense = builder.comment("").defineInRange("chance_dense", 0.02, 0.0, 1.0);
                this.chance_storm = builder.comment("").defineInRange("chance_storm", 0.01, 0.0, 1.0);
                this.generate_Light = builder.comment("").define("generate_light_clouds", true);
                this.generate_Dense = builder.comment("").define("generate_dense_clouds", true);
                this.generate_Storm = builder.comment("").define("generate_storm_clouds", true);
                builder.pop();
            }
        }

        public static class SubMenu_DimBlacklist {
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> global;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> clouds;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> doodads;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> flowers;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> plants;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> trees;
            private Predicate<Object> validator = object -> {
                String string;
                if (object instanceof String && !Strings.isNullOrEmpty((String)(string = (String)object))) {
                    return string.split(":").length == 2;
                }
                return false;
            };

            SubMenu_DimBlacklist(ForgeConfigSpec.Builder builder) {
                builder.comment(new String[]{"Generators will not generate in the dimensions on this list", "The registered name is expected. [eg: minecraft:overworld, minecraft:the_nether, minecraft:the_end] (regex supported)", "Finding the registered name:", "With an open source mod, running a search for RegistryKey<DimensionType> should get you the name.", "With closed sourced mods, asking the author or using a decompiler like JD-GUI are your options."}).push("dimension_blacklist");
                this.global = builder.comment("Dimensions here are blacklist from all generators").defineList("global", this.getListOf("randomthings:spectre", "compactmachines:compactmachines"), this.validator);
                this.clouds = builder.comment("").defineList("clouds", this.getListOf(new String[0]), this.validator);
                this.doodads = builder.comment("").defineList("doodads", this.getListOf(new String[0]), this.validator);
                this.flowers = builder.comment("").defineList("flowers", this.getListOf(new String[0]), this.validator);
                this.plants = builder.comment("").defineList("plants", this.getListOf(new String[0]), this.validator);
                this.trees = builder.comment("").defineList("trees", this.getListOf(new String[0]), this.validator);
                builder.pop();
            }

            private List<String> getListOf(String ... values) {
                return new ArrayList<String>(Arrays.asList(values));
            }
        }
    }

    public static class Menu_LootTables {
        public SubMenu_Chests CHESTS;
        public SubMenu_Mobs MOBS;

        Menu_LootTables(ForgeConfigSpec.Builder builder) {
            builder.comment("Controls which loot table injections are applied").push("loot_tables");
            this.CHESTS = new SubMenu_Chests(builder);
            this.MOBS = new SubMenu_Mobs(builder);
            builder.pop();
        }

        public static class SubMenu_Mobs {
            public ForgeConfigSpec.BooleanValue enableMobDropTweaks;
            public ForgeConfigSpec.BooleanValue blaze_BurniumDust;
            public ForgeConfigSpec.BooleanValue blaze_BurniumGem;
            public ForgeConfigSpec.BooleanValue enderman_EnderDust;
            public ForgeConfigSpec.BooleanValue enderman_EndimiumDust;
            public ForgeConfigSpec.BooleanValue enderman_EndimiumGem;
            public ForgeConfigSpec.BooleanValue endermite_EnderDust;
            public ForgeConfigSpec.BooleanValue endermite_EndimiumDust;
            public ForgeConfigSpec.BooleanValue magmaCube_BurniumGem;
            public ForgeConfigSpec.BooleanValue piglin_GoldDust;
            public ForgeConfigSpec.BooleanValue witherSkeleton_CoalDust;
            public ForgeConfigSpec.BooleanValue zombie_LeatherScraps;

            SubMenu_Mobs(ForgeConfigSpec.Builder builder) {
                builder.comment(" ").push("mobs");
                this.enableMobDropTweaks = builder.comment("Must be enabled for any of the mob specific ones to work").define("enable_extra_drops", true);
                this.blaze_BurniumDust = builder.comment("").define("blaze_burnium_dust", true);
                this.blaze_BurniumGem = builder.comment("").define("blaze_burnium_gem", true);
                this.enderman_EnderDust = builder.comment("").define("enderman_ender_dust", true);
                this.enderman_EndimiumDust = builder.comment("").define("enderman_endimium_dust", true);
                this.enderman_EndimiumGem = builder.comment("").define("enderman_endimium_gem", true);
                this.endermite_EnderDust = builder.comment("").define("endermite_ender_dust", true);
                this.endermite_EndimiumDust = builder.comment("").define("endermite_endimium_dust", true);
                this.magmaCube_BurniumGem = builder.comment("").define("magma_cube_burnium_gem", true);
                this.piglin_GoldDust = builder.comment("").define("piglin_gold_dust", true);
                this.witherSkeleton_CoalDust = builder.comment("").define("wither_skeleton_coal_dust", true);
                this.zombie_LeatherScraps = builder.comment("").define("zombie_leather_scraps", true);
                builder.pop();
            }
        }

        public static class SubMenu_Chests {
            public ForgeConfigSpec.BooleanValue chestSpawnBonus_LifeFruit;
            public ForgeConfigSpec.BooleanValue chestMineshaft_DeathFruit;
            public ForgeConfigSpec.BooleanValue chestToolsmith_Colorizer;
            public ForgeConfigSpec.BooleanValue chestDungeon_Colorizer;
            public ForgeConfigSpec.BooleanValue chestStronghold_Scroll;
            public ForgeConfigSpec.BooleanValue chestNetherBridge_Scroll;
            public ForgeConfigSpec.BooleanValue chestDungeon_ToonTrotters;

            SubMenu_Chests(ForgeConfigSpec.Builder builder) {
                builder.comment(" ").push("chests");
                this.chestSpawnBonus_LifeFruit = builder.comment("Spawn Bonus Chests can contain LifeFruit").define("spawn_bonus_lifefruit", true);
                this.chestMineshaft_DeathFruit = builder.comment("Mineshaft Chests can contain DeathFruit").define("mineshaft_deathfruit", true);
                this.chestToolsmith_Colorizer = builder.comment("Village Toolsmith Chests can contain a Molecular Colorizer").define("toolsmith_colorizer", true);
                this.chestDungeon_Colorizer = builder.comment("Dungeon Chests can contain a Molecular Colorizer").define("dungeon_colorizer", true);
                this.chestStronghold_Scroll = builder.comment("Stronghold Library Chests can contain a Strange Scroll").define("stronghold_strange_scroll", true);
                this.chestNetherBridge_Scroll = builder.comment("Nether Bridge Chests can contain a Strange Scroll").define("nether_bridge_strange_scroll", true);
                this.chestDungeon_ToonTrotters = builder.comment("Dungeon Chests can contain the Toon Trotters").define("dungeon_toon_trotters", true);
                builder.pop();
            }
        }
    }

    public static class Menu_Tweaks {
        public ForgeConfigSpec.BooleanValue enableGlassShardDropsForBlocks;
        public ForgeConfigSpec.BooleanValue enableGlassShardDropsForPotions;
        public ForgeConfigSpec.BooleanValue chickensMoult;
        public ForgeConfigSpec.BooleanValue addHayAITasks;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> colorizerClassMappings;

        Menu_Tweaks(ForgeConfigSpec.Builder builder) {
            builder.comment("Make adjustments to how different blocks/items function").push("tweaks");
            this.enableGlassShardDropsForBlocks = builder.comment("Glass Blocks will drop shards when broken, if it would otherwise drop nothing").define("glassshards_from_block", true);
            this.enableGlassShardDropsForPotions = builder.comment("Throwable Potions will drop a shard when broken").define("glassshards_from_potion_bottle", true);
            this.chickensMoult = builder.comment("Adds feather moulting").define("chickens_moult", true);
            this.addHayAITasks = builder.comment(new String[]{"Adds two AITasks", "Animals the follow for wheat will also follow for hay", "Animals that eat grass will also eat hay"}).define("add_hay_ai_tasks", true);
            this.colorizerClassMappings = builder.comment(new String[]{"Map of non-colored blocks that have colored variants but do not just add the color name to the star or end (eg. Glass & Stained Glass", "Format: <modId>:<base_blockId>:<colored_blockId> Note: the colored_blockId must include * in place of the color (eg. 'orange_stained_glass' = '*_stained_glass'"}).defineList("special_colorizer_class_mappings", new ArrayList<String>(Arrays.asList("minecraft:glass:*_stained_glass", "minecraft:glass_pane:*_stained_glass_pane")), object -> object instanceof String && !Strings.isNullOrEmpty((String)((String)object)) && ((String)object).split(":").length == 3 && ((String)object).split(":")[2].contains("*"));
            builder.pop();
        }
    }

    public static class Menu_WaterPearl {
        public ForgeConfigSpec.BooleanValue enableWaterBreathing;
        public ForgeConfigSpec.BooleanValue enableWorldInteraction;
        public ForgeConfigSpec.BooleanValue enableInfiniteWaterTank;

        Menu_WaterPearl(ForgeConfigSpec.Builder builder) {
            builder.comment(" ").push("water_pearl");
            this.enableWaterBreathing = builder.comment("Prevent breath loss while held, or in the hotbar, or equipped as a bauble").define("give_water_breathing", true);
            this.enableWorldInteraction = builder.comment("Allows the placement water into the world, and filling fluid inventories").define("world_interaction", true);
            this.enableInfiniteWaterTank = builder.comment("Adds fluid capabilities enabling machines that support it to pull water from the pearl").define("use_in_machines", true);
            builder.pop();
        }
    }

    public static class Menu_StormForge {
        public ForgeConfigSpec.EnumValue<LEVEL> permissions;
        public ForgeConfigSpec.DoubleValue smeltTimeMultiplier;
        public ForgeConfigSpec.IntValue ticksPerRepairPoint;
        public ForgeConfigSpec.IntValue powerPerTickBase;
        public ForgeConfigSpec.DoubleValue powerMultiplierFU;
        public ForgeConfigSpec.DoubleValue powerMultiplierIF;
        public ForgeConfigSpec.DoubleValue powerMultiplierJ;

        Menu_StormForge(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"StormForge Settings", "1EU = 4RF = 10J = 0.4MJ (http://ftbwiki.org/Power_Systems)"}).push("stormforge");
            this.permissions = builder.comment(new String[]{"Controls who has permission to create a StormForge.", "0 = No One, 1 = OP's Only, 2 = OP's and Creative Players, 3 = Everyone", "NOTE: Does not disable/remove existing StormForges", "NOTE: StormForges require addCraftables"}).defineEnum("permissions", (Enum)LEVEL.EVERYONE);
            this.smeltTimeMultiplier = builder.comment("A smelting recipe's 'cookingtime' will be multiplied by this value when processed in a StormForge").defineInRange("smeltingTimeMultiplier", 2.0, 1.0, 100.0);
            this.ticksPerRepairPoint = builder.comment("The number of ticks needed to repair an item by one point").defineInRange("ticksPerRepairPoint", 100, 20, 600);
            this.powerPerTickBase = builder.comment(new String[]{"The base amount of energy charged per tick", "This value is multiplied by the PowerMultiplier that matches the items requirements"}).defineInRange("powerPerTickBase", 32, 1, 2048);
            this.powerMultiplierFU = builder.comment("When charging with Forge Units, powerPerTickBase times this equals the base FU/t").defineInRange("powerMultiplierFU", 4.0, 0.001, 1000.0);
            this.powerMultiplierIF = builder.comment("When charging with Immersive Flux, powerPerTickBase times this equals the base IF/t").defineInRange("powerMultiplierIF", 4.0, 0.001, 1000.0);
            this.powerMultiplierJ = builder.comment("When charging with Joules, powerPerTickBase times this equals the base J/t").defineInRange("powerMultiplierJ", 10.0, 0.001, 1000.0);
            builder.pop();
        }

        public static enum LEVEL {
            NO_ONE,
            OPS_ONLY,
            OPS_CREATIVE,
            EVERYONE;


            public boolean check(PlayerEntity player) {
                if (this == NO_ONE) {
                    return false;
                }
                if (this == OPS_ONLY && !Function.isOP((PlayerEntity)player)) {
                    return false;
                }
                return this != OPS_CREATIVE || player.field_71075_bZ.field_75098_d;
            }
        }
    }

    public static class Menu_Trees {
        public ForgeConfigSpec.BooleanValue fruitStaysOnTrees;
        public SubMenu_SaplingGrow SAPLING_GROW;
        public SubMenu_FlowerGrow FLOWER_GROW;
        public SubMenu_FruitGrow FRUIT_GROW;
        public SubMenu_FruitFall FRUIT_FALL;

        Menu_Trees(ForgeConfigSpec.Builder builder) {
            builder.comment("").push("trees");
            this.fruitStaysOnTrees = builder.comment("Controls if the fruit stays on the trees or randomly falls off").define("fruitStaysOnTrees", false);
            this.SAPLING_GROW = new SubMenu_SaplingGrow(builder);
            this.FLOWER_GROW = new SubMenu_FlowerGrow(builder);
            this.FRUIT_GROW = new SubMenu_FruitGrow(builder);
            this.FRUIT_FALL = new SubMenu_FruitFall(builder);
            builder.pop();
        }

        public static class SubMenu_FruitFall
        extends TreeConfig {
            SubMenu_FruitFall(ForgeConfigSpec.Builder builder) {
                builder.comment(new String[]{"'1 in x' chance a fruit will fall on the next block update", "If 'fruitStaysOnTrees' is set true, fruit will never drop"}).push("fruit_fall");
                this.apple = builder.defineInRange("apple", 50, 0, 100);
                this.cherry = builder.defineInRange("cherry", 50, 0, 100);
                this.orange = builder.defineInRange("orange", 50, 0, 100);
                this.pear = builder.defineInRange("pear", 60, 0, 100);
                this.peach = builder.defineInRange("peach", 50, 0, 100);
                this.mango = builder.defineInRange("mango", 60, 0, 100);
                this.lemon = builder.defineInRange("lemon", 40, 0, 100);
                this.plum = builder.defineInRange("plum", 50, 0, 100);
                this.coconut = builder.defineInRange("coconut", 70, 0, 100);
                this.mulberry = builder.defineInRange("mulberry", 50, 0, 100);
                builder.pop();
            }

            @Override
            public int[] getValues() {
                return new int[]{(Integer)this.apple.get(), (Integer)this.cherry.get(), (Integer)this.orange.get(), (Integer)this.pear.get(), (Integer)this.peach.get(), (Integer)this.mango.get(), (Integer)this.lemon.get(), (Integer)this.plum.get(), (Integer)this.coconut.get(), 0, (Integer)this.mulberry.get()};
            }
        }

        public static class SubMenu_FruitGrow
        extends TreeConfig {
            SubMenu_FruitGrow(ForgeConfigSpec.Builder builder) {
                builder.comment("'1 in x' chance the fruit will grow on the next block update").push("fruit_grow");
                this.apple = builder.defineInRange("apple", 40, 0, 100);
                this.cherry = builder.defineInRange("cherry", 40, 0, 100);
                this.orange = builder.defineInRange("orange", 40, 0, 100);
                this.pear = builder.defineInRange("pear", 50, 0, 100);
                this.peach = builder.defineInRange("peach", 40, 0, 100);
                this.mango = builder.defineInRange("mango", 50, 0, 100);
                this.lemon = builder.defineInRange("lemon", 30, 0, 100);
                this.plum = builder.defineInRange("plum", 40, 0, 100);
                this.coconut = builder.defineInRange("coconut", 20, 0, 100);
                this.banana = builder.defineInRange("banana", 20, 0, 100);
                this.mulberry = builder.defineInRange("mulberry", 40, 0, 100);
                builder.pop();
            }
        }

        public static class SubMenu_FlowerGrow
        extends TreeConfig {
            SubMenu_FlowerGrow(ForgeConfigSpec.Builder builder) {
                builder.comment("'1 in x' chance the fruit flower will grow on the next block update").push("flower_grow");
                this.apple = builder.defineInRange("apple", 25, 0, 100);
                this.cherry = builder.defineInRange("cherry", 25, 0, 100);
                this.orange = builder.defineInRange("orange", 25, 0, 100);
                this.pear = builder.defineInRange("pear", 25, 0, 100);
                this.peach = builder.defineInRange("peach", 25, 0, 100);
                this.mango = builder.defineInRange("mango", 25, 0, 100);
                this.lemon = builder.defineInRange("lemon", 25, 0, 100);
                this.plum = builder.defineInRange("plum", 25, 0, 100);
                this.banana = builder.defineInRange("banana", 15, 0, 100);
                this.mulberry = builder.defineInRange("mulberry", 25, 0, 100);
                builder.pop();
            }

            @Override
            public int[] getValues() {
                return new int[]{(Integer)this.apple.get(), (Integer)this.cherry.get(), (Integer)this.orange.get(), (Integer)this.pear.get(), (Integer)this.peach.get(), (Integer)this.mango.get(), (Integer)this.lemon.get(), (Integer)this.plum.get(), 0, (Integer)this.banana.get(), (Integer)this.mulberry.get()};
            }
        }

        public static class SubMenu_SaplingGrow
        extends TreeConfig {
            SubMenu_SaplingGrow(ForgeConfigSpec.Builder builder) {
                builder.comment("'1 in x' chance the sapling will grow on the next block update").push("sapling_grow");
                this.apple = builder.defineInRange("apple", 7, 0, 100);
                this.cherry = builder.defineInRange("cherry", 7, 0, 100);
                this.orange = builder.defineInRange("orange", 7, 0, 100);
                this.pear = builder.defineInRange("pear", 7, 0, 100);
                this.peach = builder.defineInRange("peach", 7, 0, 100);
                this.mango = builder.defineInRange("mango", 7, 0, 100);
                this.lemon = builder.defineInRange("lemon", 7, 0, 100);
                this.plum = builder.defineInRange("plum", 7, 0, 100);
                this.coconut = builder.defineInRange("coconut", 7, 0, 100);
                this.banana = builder.defineInRange("banana", 7, 0, 100);
                this.mulberry = builder.defineInRange("mulberry", 7, 0, 100);
                builder.pop();
            }
        }

        private static abstract class TreeConfig {
            protected ForgeConfigSpec.IntValue apple;
            protected ForgeConfigSpec.IntValue cherry;
            protected ForgeConfigSpec.IntValue orange;
            protected ForgeConfigSpec.IntValue pear;
            protected ForgeConfigSpec.IntValue peach;
            protected ForgeConfigSpec.IntValue mango;
            protected ForgeConfigSpec.IntValue lemon;
            protected ForgeConfigSpec.IntValue plum;
            protected ForgeConfigSpec.IntValue coconut;
            protected ForgeConfigSpec.IntValue banana;
            protected ForgeConfigSpec.IntValue mulberry;

            private TreeConfig() {
            }

            public int[] getValues() {
                return new int[]{(Integer)this.apple.get(), (Integer)this.cherry.get(), (Integer)this.orange.get(), (Integer)this.pear.get(), (Integer)this.peach.get(), (Integer)this.mango.get(), (Integer)this.lemon.get(), (Integer)this.plum.get(), (Integer)this.coconut.get(), (Integer)this.banana.get(), (Integer)this.mulberry.get()};
            }
        }
    }

    public static class Menu_Plants {
        public ForgeConfigSpec.BooleanValue flowersRequireShears;
        public SubMenu_PlantGrow PLANT_GROW;
        public SubMenu_PlantSpread PLANT_SPREAD;
        public SubMenu_FruitGrow FRUIT_GROW;

        Menu_Plants(ForgeConfigSpec.Builder builder) {
            builder.comment("").push("plants");
            this.flowersRequireShears = builder.comment("If enabled Terraqueous flowers require shears to harvest, otherwise nothing will drop").define("flowersRequireShears", false);
            this.PLANT_GROW = new SubMenu_PlantGrow(builder);
            this.PLANT_SPREAD = new SubMenu_PlantSpread(builder);
            this.FRUIT_GROW = new SubMenu_FruitGrow(builder);
            builder.pop();
        }

        public static class SubMenu_FruitGrow {
            public ForgeConfigSpec.IntValue pineapple_normal;
            public ForgeConfigSpec.IntValue pineapple_rain;
            public ForgeConfigSpec.IntValue cactus_day;
            public ForgeConfigSpec.IntValue cactus_night;
            public ForgeConfigSpec.IntValue grapevine_normal;
            public ForgeConfigSpec.IntValue grapevine_rain;
            public ForgeConfigSpec.IntValue lifevine_normal;
            public ForgeConfigSpec.IntValue lifevine_rain;
            public ForgeConfigSpec.IntValue deathvine_normal;
            public ForgeConfigSpec.IntValue deathvine_rain;

            SubMenu_FruitGrow(ForgeConfigSpec.Builder builder) {
                builder.comment("Chance the plant will grow fruit on the next block update").push("fruit_grow");
                this.pineapple_normal = builder.defineInRange("pineapple_normal", 40, 0, 100);
                this.pineapple_rain = builder.defineInRange("pineapple_rain", 40, 0, 100);
                this.cactus_day = builder.defineInRange("cactus_day", 0, 0, 100);
                this.cactus_night = builder.defineInRange("cactus_night", 40, 0, 100);
                this.grapevine_normal = builder.defineInRange("grapevine_normal", 40, 0, 100);
                this.grapevine_rain = builder.defineInRange("grapevine_rain", 40, 0, 100);
                this.lifevine_normal = builder.defineInRange("lifevine_normal", 40, 0, 100);
                this.lifevine_rain = builder.defineInRange("lifevine_rain", 40, 0, 100);
                this.deathvine_normal = builder.defineInRange("deathvine_normal", 40, 0, 100);
                this.deathvine_rain = builder.defineInRange("deathvine_rain", 40, 0, 100);
                builder.pop();
            }
        }

        public static class SubMenu_PlantSpread {
            public ForgeConfigSpec.IntValue flower_normal;
            public ForgeConfigSpec.IntValue flower_rain;
            public ForgeConfigSpec.IntValue grass_normal;
            public ForgeConfigSpec.IntValue grass_rain;
            public ForgeConfigSpec.IntValue grapevine_normal;
            public ForgeConfigSpec.IntValue grapevine_rain;
            public ForgeConfigSpec.IntValue lifevine_normal;
            public ForgeConfigSpec.IntValue lifevine_rain;
            public ForgeConfigSpec.IntValue deathvine_normal;
            public ForgeConfigSpec.IntValue deathvine_rain;

            SubMenu_PlantSpread(ForgeConfigSpec.Builder builder) {
                builder.comment("Chance the plant will spread on the next block update").push("plant_spread");
                this.flower_normal = builder.defineInRange("flower_normal", 20, 0, 100);
                this.flower_rain = builder.defineInRange("flower_rain", 18, 0, 100);
                this.grass_normal = builder.defineInRange("grass_normal", 20, 0, 100);
                this.grass_rain = builder.defineInRange("grass_rain", 18, 0, 100);
                this.grapevine_normal = builder.defineInRange("grapevine_normal", 15, 0, 100);
                this.grapevine_rain = builder.defineInRange("grapevine_rain", 13, 0, 100);
                this.lifevine_normal = builder.defineInRange("lifevine_normal", 15, 0, 100);
                this.lifevine_rain = builder.defineInRange("lifevine_rain", 13, 0, 100);
                this.deathvine_normal = builder.defineInRange("deathvine_normal", 15, 0, 100);
                this.deathvine_rain = builder.defineInRange("deathvine_rain", 13, 0, 100);
                builder.pop();
            }
        }

        public static class SubMenu_PlantGrow {
            public ForgeConfigSpec.IntValue flower_normal;
            public ForgeConfigSpec.IntValue flower_rain;
            public ForgeConfigSpec.IntValue grass_normal;
            public ForgeConfigSpec.IntValue grass_rain;
            public ForgeConfigSpec.IntValue pineapple_normal;
            public ForgeConfigSpec.IntValue pineapple_rain;
            public ForgeConfigSpec.IntValue cactus_day;
            public ForgeConfigSpec.IntValue cactus_night;

            SubMenu_PlantGrow(ForgeConfigSpec.Builder builder) {
                builder.comment("Chance the plant will grow on the next block update").push("plant_grow");
                this.flower_normal = builder.defineInRange("flower_normal", 10, 0, 100);
                this.flower_rain = builder.defineInRange("flower_rain", 9, 0, 100);
                this.grass_normal = builder.defineInRange("grass_normal", 95, 0, 100);
                this.grass_rain = builder.defineInRange("grass_rain", 75, 0, 100);
                this.pineapple_normal = builder.defineInRange("pineapple_normal", 8, 0, 100);
                this.pineapple_rain = builder.defineInRange("pineapple_rain", 5, 0, 100);
                this.cactus_day = builder.defineInRange("cactus_day", 0, 0, 100);
                this.cactus_night = builder.defineInRange("cactus_night", 8, 0, 100);
                builder.pop();
            }
        }
    }

    private static class Menu_FlowerPots {
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> forceSingleCrossRender;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> forceMultiCrossRender;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> forceBlockRender;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> forcePaneRender;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> forceTallRender;
        private Predicate<Object> validator = object -> {
            String string;
            if (object instanceof String && !Strings.isNullOrEmpty((String)(string = (String)object))) {
                return string.split(":").length == 2;
            }
            return false;
        };

        Menu_FlowerPots(ForgeConfigSpec.Builder builder) {
            builder.comment("").push("flowerpots");
            this.forceSingleCrossRender = builder.comment(new String[]{"Items Listed will render in flower pots using the Cross render style", "Saplings use this by default"}).defineList("forceSingleCrossRender", this.getListOf(new String[0]), this.validator);
            this.forceMultiCrossRender = builder.comment(new String[]{"Items Listed will render in flower pots using the Cross render style", "2D items use this by default"}).defineList("forceMultiCrossRender", this.getListOf(new String[0]), this.validator);
            this.forceBlockRender = builder.comment(new String[]{"Items Listed will render in flower pots using the Block render style", "3D items use this by default"}).defineList("forceBlockRender", this.getListOf(new String[0]), this.validator);
            this.forcePaneRender = builder.comment("Items Listed will render in flower pots using the Pane render style").defineList("forcePaneRender", this.getListOf(new String[0]), this.validator);
            this.forceTallRender = builder.comment("Items Listed will render in flower pots using the Tall render style").defineList("forceTallRender", this.getListOf("minecraft:cactus"), this.validator);
            builder.pop();
        }

        private List<String> getListOf(String ... values) {
            return new ArrayList<String>(Arrays.asList(values));
        }
    }

    public static class Menu_Doodads {
        public SubMenu_Branch STICK;
        public SubMenu_Stone STONE;
        public SubMenu_Bone BONE;
        public SubMenu_SandStone SANDSTONE;
        public SubMenu_RedSandStone REDSANDSTONE;
        public SubMenu_Endimium ENDIMIUM;
        public SubMenu_Burnium BURNIUM;
        public static Pattern PATTERN_MOD = Pattern.compile("(?>mod\\|)([a-z0-9_.-]+)");
        public static Pattern PATTERN_ITEM = Pattern.compile("(?>tag\\|)?((?>[a-z0-9_.-]+):(?>[a-z0-9\\/_.-]+))#(\\d(?>-\\d)?)");
        private static final Predicate<Object> validator = object -> {
            String string;
            if (object instanceof String && !Strings.isNullOrEmpty((String)(string = (String)object))) {
                Matcher matcher = string.startsWith("mod|") ? PATTERN_MOD.matcher(string) : PATTERN_ITEM.matcher(string);
                return matcher.find();
            }
            return false;
        };

        Menu_Doodads(ForgeConfigSpec.Builder builder) {
            builder.comment("").push("doodads");
            this.STICK = new SubMenu_Branch(builder);
            this.STONE = new SubMenu_Stone(builder);
            this.BONE = new SubMenu_Bone(builder);
            this.SANDSTONE = new SubMenu_SandStone(builder);
            this.REDSANDSTONE = new SubMenu_RedSandStone(builder);
            this.ENDIMIUM = new SubMenu_Endimium(builder);
            this.BURNIUM = new SubMenu_Burnium(builder);
            builder.pop();
        }

        private static List<String> getListOf(String ... values) {
            return new ArrayList<String>(Arrays.asList(values));
        }

        public static class SubMenu_Burnium {
            public ForgeConfigSpec.IntValue dropAttempts;
            public ForgeConfigSpec.IntValue dropChance;
            public ForgeConfigSpec.IntValue dropCount;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;

            SubMenu_Burnium(ForgeConfigSpec.Builder builder) {
                builder.comment("").push("burnium");
                this.dropAttempts = builder.comment(new String[]{"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_attempts", 1, -100, 100);
                this.dropChance = builder.comment("'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist").defineInRange("drop_chance", 1, 0, 100);
                this.dropCount = builder.comment(new String[]{"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_amount", -3, -100, 100);
                this.whitelist = builder.comment(new String[]{"Items listed here have a chance to drop", "Formats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'"}).defineList("whitelist", Menu_Doodads.getListOf(new String[]{"tag|forge:gems/burnium#1-4", "tag|forge:dusts/burnium#1-4"}), validator);
                this.blacklist = builder.comment(new String[]{"Items listed here can never drop", "Formats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'"}).defineList("blacklist", Menu_Doodads.getListOf(new String[0]), validator);
                builder.pop();
            }
        }

        public static class SubMenu_Endimium {
            public ForgeConfigSpec.IntValue dropAttempts;
            public ForgeConfigSpec.IntValue dropChance;
            public ForgeConfigSpec.IntValue dropCount;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;

            SubMenu_Endimium(ForgeConfigSpec.Builder builder) {
                builder.comment("").push("endimium");
                this.dropAttempts = builder.comment(new String[]{"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_attempts", 1, -100, 100);
                this.dropChance = builder.comment("'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist").defineInRange("drop_chance", 1, 0, 100);
                this.dropCount = builder.comment(new String[]{"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_amount", -3, -100, 100);
                this.whitelist = builder.comment(new String[]{"Items listed here have a chance to drop", "Formats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'"}).defineList("whitelist", Menu_Doodads.getListOf(new String[]{"tag|forge:gems/endimium#1-4", "tag|forge:dusts/endimium#1-4"}), validator);
                this.blacklist = builder.comment(new String[]{"Items listed here can never drop", "Formats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'"}).defineList("blacklist", Menu_Doodads.getListOf(new String[0]), validator);
                builder.pop();
            }
        }

        public static class SubMenu_RedSandStone {
            public ForgeConfigSpec.IntValue dropAttempts;
            public ForgeConfigSpec.IntValue dropChance;
            public ForgeConfigSpec.IntValue dropCount;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;

            SubMenu_RedSandStone(ForgeConfigSpec.Builder builder) {
                builder.comment("").push("red_sandstone");
                this.dropAttempts = builder.comment(new String[]{"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_attempts", 1, -100, 100);
                this.dropChance = builder.comment("'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist").defineInRange("drop_chance", 1, 0, 100);
                this.dropCount = builder.comment(new String[]{"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_amount", -2, -100, 100);
                this.whitelist = builder.comment(new String[]{"Items listed here have a chance to drop", "Formats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'"}).defineList("whitelist", Menu_Doodads.getListOf(new String[]{"tag|forge:dusts#1", "terraqueous:red_sandstone_lump#1"}), validator);
                this.blacklist = builder.comment(new String[]{"Items listed here can never drop", "Formats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'"}).defineList("blacklist", Menu_Doodads.getListOf(new String[]{"tag|forge:dusts/burnium", "tag|forge:dusts/endimium"}), validator);
                builder.pop();
            }
        }

        public static class SubMenu_SandStone {
            public ForgeConfigSpec.IntValue dropAttempts;
            public ForgeConfigSpec.IntValue dropChance;
            public ForgeConfigSpec.IntValue dropCount;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;

            SubMenu_SandStone(ForgeConfigSpec.Builder builder) {
                builder.comment("").push("sandstone");
                this.dropAttempts = builder.comment(new String[]{"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_attempts", 1, -100, 100);
                this.dropChance = builder.comment("'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist").defineInRange("drop_chance", 1, 0, 100);
                this.dropCount = builder.comment(new String[]{"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_amount", -2, -100, 100);
                this.whitelist = builder.comment(new String[]{"Items listed here have a chance to drop", "Formats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'"}).defineList("whitelist", Menu_Doodads.getListOf(new String[]{"tag|forge:dusts#1", "terraqueous:sandstone_lump#1"}), validator);
                this.blacklist = builder.comment(new String[]{"Items listed here can never drop", "Formats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'"}).defineList("blacklist", Menu_Doodads.getListOf(new String[]{"tag|forge:dusts/burnium", "tag|forge:dusts/endimium"}), validator);
                builder.pop();
            }
        }

        public static class SubMenu_Bone {
            public ForgeConfigSpec.IntValue dropAttempts;
            public ForgeConfigSpec.IntValue dropChance;
            public ForgeConfigSpec.IntValue dropCount;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;

            SubMenu_Bone(ForgeConfigSpec.Builder builder) {
                builder.comment("").push("bone");
                this.dropAttempts = builder.comment(new String[]{"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_attempts", 1, -100, 100);
                this.dropChance = builder.comment("'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist").defineInRange("drop_chance", 1, 0, 100);
                this.dropCount = builder.comment(new String[]{"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_amount", -2, -100, 100);
                this.whitelist = builder.comment(new String[]{"Items listed here have a chance to drop", "Formats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'"}).defineList("whitelist", Menu_Doodads.getListOf(new String[]{"tag|forge:bones#1", "minecraft:bone_meal#1-3"}), validator);
                this.blacklist = builder.comment(new String[]{"Items listed here can never drop", "Formats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'"}).defineList("blacklist", Menu_Doodads.getListOf(new String[0]), validator);
                builder.pop();
            }
        }

        public static class SubMenu_Stone {
            public ForgeConfigSpec.IntValue dropAttempts;
            public ForgeConfigSpec.IntValue dropChance;
            public ForgeConfigSpec.IntValue dropCount;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;

            SubMenu_Stone(ForgeConfigSpec.Builder builder) {
                builder.comment("").push("stone");
                this.dropAttempts = builder.comment(new String[]{"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_attempts", 1, -100, 100);
                this.dropChance = builder.comment("'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist").defineInRange("drop_chance", 1, 0, 100);
                this.dropCount = builder.comment(new String[]{"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_amount", -2, -100, 100);
                this.whitelist = builder.comment(new String[]{"Items listed here have a chance to drop", "Formats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'"}).defineList("whitelist", Menu_Doodads.getListOf(new String[]{"tag|forge:dusts#1", "terraqueous:gravel_lump#1"}), validator);
                this.blacklist = builder.comment(new String[]{"Items listed here can never drop", "Formats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'"}).defineList("blacklist", Menu_Doodads.getListOf(new String[]{"tag|forge:dusts/burnium", "tag|forge:dusts/endimium"}), validator);
                builder.pop();
            }
        }

        public static class SubMenu_Branch {
            public ForgeConfigSpec.IntValue dropAttempts;
            public ForgeConfigSpec.IntValue dropChance;
            public ForgeConfigSpec.IntValue dropCount;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;

            SubMenu_Branch(ForgeConfigSpec.Builder builder) {
                builder.comment("").push("branch");
                this.dropAttempts = builder.comment(new String[]{"The number of attempts made to suscessfully drop an item", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_attempts", 1, -100, 100);
                this.dropChance = builder.comment("'1 in x' chance the doodad will drop something from the whitelist, excluding items from the blacklist").defineInRange("drop_chance", 1, 0, 100);
                this.dropCount = builder.comment(new String[]{"The number of items to drop on a suscessful attempt", "positive numbers are exact, negitive are a random chance between 0 and the number"}).defineInRange("drop_amount", -2, -100, 100);
                this.whitelist = builder.comment(new String[]{"Items listed here have a chance to drop", "Formats: ItemTag: 'tag|<tagId>#<count>', Mod Item: '<modId>:<itemId>#<count>'"}).defineList("whitelist", Menu_Doodads.getListOf(new String[]{"minecraft:stick#1-3"}), validator);
                this.blacklist = builder.comment(new String[]{"Items listed here can never drop", "Formats: ItemTag: 'tag|<tagId>', Mod Item: '<modId>:<itemId>', Entire Mod: 'mod|<modId>'"}).defineList("blacklist", Menu_Doodads.getListOf(new String[0]), validator);
                builder.pop();
            }
        }
    }

    public static class Menu_GUI {
        public ForgeConfigSpec.EnumValue<STYLE> cloud_furnace;
        public ForgeConfigSpec.EnumValue<STYLE> cloud_workbench;
        public ForgeConfigSpec.EnumValue<STYLE> cloud_craftbench;
        public ForgeConfigSpec.EnumValue<STYLE> cloud_craftfurnace;
        public ForgeConfigSpec.EnumValue<STYLE> colorizer;
        public ForgeConfigSpec.EnumValue<STYLE> craftbench;
        public ForgeConfigSpec.EnumValue<STYLE> craftfurnace;
        public ForgeConfigSpec.EnumValue<STYLE> endertable;
        public ForgeConfigSpec.EnumValue<STYLE> stormforge;

        Menu_GUI(ForgeConfigSpec.Builder builder) {
            builder.comment("Select A GUI Style").push("gui_style");
            this.cloud_furnace = builder.defineEnum("cloud_furnace", (Enum)STYLE.DEFAULT);
            this.cloud_workbench = builder.defineEnum("cloud_workbench", (Enum)STYLE.DEFAULT);
            this.cloud_craftbench = builder.defineEnum("cloud_craftbench", (Enum)STYLE.DEFAULT);
            this.cloud_craftfurnace = builder.defineEnum("cloud_craftfurnace", (Enum)STYLE.DEFAULT);
            this.colorizer = builder.defineEnum("colorizer", (Enum)STYLE.DEFAULT);
            this.craftbench = builder.defineEnum("craftbench", (Enum)STYLE.DEFAULT);
            this.craftfurnace = builder.defineEnum("craftfurnace", (Enum)STYLE.DEFAULT);
            this.endertable = builder.defineEnum("endertable", (Enum)STYLE.DEFAULT);
            this.stormforge = builder.defineEnum("stormforge", (Enum)STYLE.DEFAULT);
            builder.pop();
        }

        public static enum STYLE {
            DEFAULT,
            VANILLA;

        }
    }

    public static class Menu_General {
        public ForgeConfigSpec.ConfigValue<List<String>> listTricksterBloomEffects;

        Menu_General(ForgeConfigSpec.Builder builder) {
            this.listTricksterBloomEffects = builder.comment("List of effects Trickster Bloom can apply").define("Trickster Bloom Effects", BlueFlowerHandler.DEFAULTS, object -> object instanceof String && ((String)object).matches("effect\\[\\w+(:|)\\w*\\];time\\[\\d+(-|)\\d*\\];level\\[\\d+(-|)\\d*\\]"));
        }
    }
}

