/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.command.CommandSource;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Register;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.api.machines.CapabilityStormForge;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.misc.ClientEventHandler;
import shetiphian.terraqueous.client.render.RenderRegistry;
import shetiphian.terraqueous.client.resources.FoliageColorReloadListener;
import shetiphian.terraqueous.common.command.StormForgeCommand;
import shetiphian.terraqueous.common.misc.EventHandler;
import shetiphian.terraqueous.common.network.NetworkHandler;
import shetiphian.terraqueous.common.worldgen.WorldGenRegistry;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;
import shetiphian.terraqueous.modintegration.ModIntegration;

@Mod(value="terraqueous")
public class Terraqueous {
    public static final String MOD_ID = "terraqueous";
    public static Terraqueous INSTANCE;
    public static Logger LOGGER;

    public Terraqueous() {
        INSTANCE = this;
        LOGGER = LogManager.getLogger((String)MOD_ID);
        IEventBus MOD_EVENT_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        MOD_EVENT_BUS.register((Object)this);
        WorldGenRegistry.register(MOD_EVENT_BUS);
        MOD_EVENT_BUS.addListener(this::commonSetup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MOD_EVENT_BUS.addListener(this::clientSetup);
            MOD_EVENT_BUS.addListener(this::onTextureStitchedEvent);
        });
        MOD_EVENT_BUS.addListener(this::init);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Configuration.SPEC_CLIENT, "terraqueous-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Configuration.SPEC_COMMON, "terraqueous.toml");
        MOD_EVENT_BUS.register(Configuration.class);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> Terraqueous::addReloadListener);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addReloadListener() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)new FoliageColorReloadListener());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        new ModIntegration().preInit();
        DeferredWorkQueue.runLater(CapabilityStormForge::register);
        DeferredWorkQueue.runLater(Register::setFireInfo);
        DeferredWorkQueue.runLater(Register::setCompostInfo);
        DeferredWorkQueue.runLater(WorldGenerator::load);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        DeferredWorkQueue.runLater(RenderRegistry::setup);
        DeferredWorkQueue.runLater(Register::registerScreenFactories);
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onTextureStitchedEvent(TextureStitchEvent.Pre event) {
        AtlasTexture atlas = event.getMap();
        if (atlas.func_229223_g_() == Atlases.field_228746_e_) {
            for (CloudAPI.CloudType cloudType : CloudAPI.CloudType.values()) {
                event.addSprite(new ResourceLocation(MOD_ID, "entity/signs/" + cloudType.func_176610_l() + "_cloud"));
            }
            for (Enum enum_ : PlantAPI.TreeType.values()) {
                event.addSprite(new ResourceLocation(MOD_ID, "entity/signs/" + ((PlantAPI.TreeType)enum_).func_176610_l()));
            }
        }
        if (atlas.func_229223_g_() == PlayerContainer.field_226615_c_) {
            event.addSprite(new ResourceLocation(MOD_ID, "entity/enderbook"));
        }
    }

    private void init(InterModEnqueueEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        NetworkHandler.initialise(MOD_ID);
        new ModIntegration().load();
    }

    private void serverStarting(FMLServerStartingEvent event) {
        StormForgeCommand.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
    }

    private void serverStopped(FMLServerStoppedEvent event) {
        Configuration.CAN_PROCESS_TAGS = false;
    }
}

