/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.plant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import shetiphian.terraqueous.api.plant.IPlantControl;

public class PlantAPI {
    private static final List<IPlantControl> CONTROLLERS = Collections.synchronizedList(new ArrayList());

    public static void registerPlantController(IPlantControl controller) {
        CONTROLLERS.add(controller);
    }

    public static int getTreeEventChance(TreeEvent event, TreeType type, IBlockReader world, BlockPos pos, int defaultChance) {
        double chance = defaultChance;
        for (IPlantControl plantController : CONTROLLERS) {
            chance *= plantController.getChanceMultiplier(event, type, world, pos);
        }
        return MathHelper.func_76143_f((double)chance);
    }

    public static int getPlantEventChance(PlantEvent event, PlantType type, IBlockReader world, BlockPos pos, int defaultChance) {
        double chance = defaultChance;
        for (IPlantControl plantController : CONTROLLERS) {
            chance *= plantController.getChanceMultiplier(event, type, world, pos);
        }
        return MathHelper.func_76143_f((double)chance);
    }

    public static byte getPlacementValue(PlacementValue placement, IBlockReader world, BlockPos pos, int defaultValue) {
        double value = defaultValue;
        for (IPlantControl plantController : CONTROLLERS) {
            value *= plantController.getValueMultiplier(placement, world, pos);
        }
        return (byte)MathHelper.func_76143_f((double)value);
    }

    public static enum PlacementValue {
        FlowerSpreadRadius,
        FlowerMaxAttempts,
        GrassSpreadRadius,
        GrassMaxAttempts;

    }

    public static enum PlantEvent {
        PlantGrow,
        PlantSpread,
        FruitGrow;

    }

    public static enum TreeEvent {
        FruitFlower,
        FruitGrow,
        FruitFall,
        SaplingGrow;

    }

    public static enum PlantType implements IStringSerializable
    {
        FLOWER(0),
        GRASS(1),
        PINEAPPLE(2),
        CACTUS(3),
        GRAPEVINE(4),
        LIFEVINE(5),
        DEATHVINE(6);

        private static final PlantType[] array;
        private final byte id;

        private PlantType(int id) {
            this.id = (byte)id;
        }

        public byte getID() {
            return this.id;
        }

        public static PlantType byID(int id) {
            return array[MathHelper.func_76125_a((int)id, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new PlantType[7];
            PlantType[] plantTypeArray = PlantType.values();
            int n = plantTypeArray.length;
            for (int i = 0; i < n; ++i) {
                PlantType value;
                PlantType.array[value.getID()] = value = plantTypeArray[i];
            }
        }
    }

    public static enum TreeType implements IStringSerializable
    {
        APPLE(0, MaterialColor.field_193574_Z),
        CHERRY(1, MaterialColor.field_193559_aa),
        ORANGE(2, MaterialColor.field_193562_N),
        PEAR(3, MaterialColor.field_193566_R),
        PEACH(4, MaterialColor.field_193562_N),
        MANGO(5, MaterialColor.field_193562_N),
        LEMON(6, MaterialColor.field_193565_Q),
        PLUM(7, MaterialColor.field_193571_W),
        COCONUT(8, MaterialColor.field_193561_M),
        BANANA(9, MaterialColor.field_193561_M),
        MULBERRY(10, MaterialColor.field_193572_X);

        private static final TreeType[] array;
        private final byte id;
        private final MaterialColor color;

        private TreeType(int id, MaterialColor color) {
            this.id = (byte)id;
            this.color = color;
        }

        public byte getID() {
            return this.id;
        }

        public static TreeType byID(int id) {
            return array[MathHelper.func_76125_a((int)id, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public MaterialColor getBarkColor() {
            return this.color;
        }

        public MaterialColor getWoodColor() {
            return this.color;
        }

        static {
            array = new TreeType[]{APPLE, CHERRY, ORANGE, PEAR, PEACH, MANGO, LEMON, PLUM, COCONUT, BANANA, MULBERRY};
        }
    }
}

