/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.MultiLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;

@OnlyIn(value=Dist.CLIENT)
public class ModelMultiLayer {

    private static enum GraphicsMode {
        FAST,
        FANCY,
        BOTH;


        public String getKey() {
            return "layers" + (this == FANCY ? "_fancy" : (this == FAST ? "_fast" : ""));
        }

        public boolean doRender() {
            return this == BOTH || (RenderTypeLookup.field_228388_c_ ? this == FANCY : this == FAST);
        }
    }

    public static class Baked
    implements IBakedModel {
        private final ImmutableTable<GraphicsMode, RenderType, IBakedModel> models;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> cameraTransforms;
        protected final boolean ambientOcclusion;
        protected final boolean gui3d;
        protected final boolean isSideLit;
        protected final TextureAtlasSprite particle;
        protected final ItemOverrideList overrides;

        public Baked(IModelConfiguration owner, TextureAtlasSprite particle, ItemOverrideList overrides, ImmutableTable<GraphicsMode, RenderType, IBakedModel> models, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> cameraTransforms) {
            this.isSideLit = owner.isSideLit();
            this.models = models;
            this.cameraTransforms = cameraTransforms;
            this.ambientOcclusion = owner.useSmoothLighting();
            this.gui3d = owner.isShadedInGui();
            this.particle = particle;
            this.overrides = overrides;
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            RenderType layer = MinecraftForgeClient.getRenderLayer();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (GraphicsMode graphicsMode : this.models.rowKeySet()) {
                if (!graphicsMode.doRender()) continue;
                ImmutableMap modelMap = this.models.row((Object)graphicsMode);
                if (layer == null) {
                    for (IBakedModel model : modelMap.values()) {
                        builder.addAll((Iterable)model.func_200117_a(state, side, rand));
                    }
                    continue;
                }
                if (!modelMap.containsKey(layer)) continue;
                builder.addAll((Iterable)((IBakedModel)modelMap.get(layer)).getQuads(state, side, rand, extraData));
            }
            return builder.build();
        }

        public boolean func_177555_b() {
            return this.ambientOcclusion;
        }

        public boolean isAmbientOcclusion(BlockState state) {
            return this.ambientOcclusion;
        }

        public boolean func_177556_c() {
            return this.gui3d;
        }

        public boolean func_230044_c_() {
            return this.isSideLit;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.cameraTransforms, (ItemCameraTransforms.TransformType)cameraTransformType, (MatrixStack)mat);
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry> {
        private final ImmutableTable<GraphicsMode, RenderType, IUnbakedModel> models;

        public Geometry(ImmutableTable<GraphicsMode, RenderType, IUnbakedModel> models) {
            this.models = models;
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet materials = Sets.newHashSet();
            materials.add(owner.resolveTexture("particle"));
            for (IUnbakedModel m : this.models.values()) {
                materials.addAll(m.func_225614_a_(modelGetter, missingTextureErrors));
            }
            return materials;
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            return new Baked(owner, spriteGetter.apply(owner.resolveTexture("particle")), overrides, Geometry.buildModels(this.models, modelTransform, bakery, spriteGetter, modelLocation), (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)PerspectiveMapWrapper.getTransforms((IModelTransform)new ModelTransformComposition(owner.getCombinedTransform(), modelTransform)));
        }

        private static ImmutableTable<GraphicsMode, RenderType, IBakedModel> buildModels(ImmutableTable<GraphicsMode, RenderType, IUnbakedModel> models, IModelTransform modelTransform, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ResourceLocation modelLocation) {
            ImmutableTable.Builder builder = ImmutableTable.builder();
            for (GraphicsMode graphicsMode : models.rowKeySet()) {
                for (Map.Entry entry : models.row((Object)graphicsMode).entrySet()) {
                    IBakedModel model = ((IUnbakedModel)entry.getValue()).func_225613_a_(bakery, spriteGetter, modelTransform, modelLocation);
                    if (model == null) continue;
                    builder.put((Object)graphicsMode, entry.getKey(), (Object)model);
                }
            }
            return builder.build();
        }
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public void func_195410_a(IResourceManager resourceManager) {
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ImmutableTable.Builder builder = ImmutableTable.builder();
            for (GraphicsMode graphicsMode : GraphicsMode.values()) {
                String modeKey = graphicsMode.getKey();
                if (!modelContents.has(modeKey)) continue;
                JsonObject layersObject = JSONUtils.func_152754_s((JsonObject)modelContents, (String)modeKey);
                for (Map.Entry layer : MultiLayerModel.Loader.BLOCK_LAYERS.entrySet()) {
                    String layerName = (String)layer.getKey();
                    if (!layersObject.has(layerName)) continue;
                    builder.put((Object)graphicsMode, layer.getValue(), deserializationContext.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)layersObject, (String)layerName), BlockModel.class));
                }
            }
            ImmutableTable models = builder.build();
            return new Geometry((ImmutableTable<GraphicsMode, RenderType, IUnbakedModel>)models);
        }
    }
}

