/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;

@OnlyIn(value=Dist.CLIENT)
public class RenderFlowerPot
extends TileEntityRenderer<TileEntityFlowerPot> {
    public RenderFlowerPot(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(TileEntityFlowerPot tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        int facing;
        ItemStack plantstack = tile.getPlantStack();
        if (plantstack.func_190926_b()) {
            return;
        }
        TileEntityFlowerPot.RenderStyle style = tile.getRenderStyle();
        if (style == TileEntityFlowerPot.RenderStyle.NONE) {
            return;
        }
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(plantstack);
        if (model == null) {
            return;
        }
        Block block = tile.func_195044_w().func_177230_c();
        if (style == TileEntityFlowerPot.RenderStyle.DEFAULT) {
            TileEntityFlowerPot.RenderStyle renderStyle = model.func_177556_c() ? TileEntityFlowerPot.RenderStyle.BLOCK : (style = ItemTags.field_200037_g.func_230235_a_((Object)plantstack.func_77973_b()) ? TileEntityFlowerPot.RenderStyle.CROSS_SINGLE : TileEntityFlowerPot.RenderStyle.CROSS_MULTI);
        }
        float rotation = (facing = tile.getPlantFacing().func_176736_b()) == 0 ? 180.0f : (facing == 2 ? 0.0f : (float)facing * 90.0f);
        matrixStack.func_227860_a_();
        switch (style) {
            case CROSS_MULTI: {
                if (block == Values.blockLargeFlowerPot) {
                    matrixStack.func_227861_a_(0.25, (double)0.74f, 0.25);
                    ItemRenderer renderer = Minecraft.func_71410_x().func_175599_af();
                    this.renderCross(renderer, plantstack, 0.16f, 0.02f, matrixStack, buffer, combinedLight, combinedOverlay);
                    this.renderCross(renderer, plantstack, 0.44f, 0.09f, matrixStack, buffer, combinedLight, combinedOverlay);
                    this.renderCross(renderer, plantstack, 0.45f, 0.39f, matrixStack, buffer, combinedLight, combinedOverlay);
                    this.renderCross(renderer, plantstack, 0.18f, 0.48f, matrixStack, buffer, combinedLight, combinedOverlay);
                    this.renderCross(renderer, plantstack, 0.01f, 0.26f, matrixStack, buffer, combinedLight, combinedOverlay);
                    break;
                }
                if (block == Values.blockMediumFlowerPot) {
                    matrixStack.func_227861_a_(0.25, (double)0.62f, 0.25);
                    ItemRenderer renderer = Minecraft.func_71410_x().func_175599_af();
                    this.renderCross(renderer, plantstack, 0.25f, 0.11f, matrixStack, buffer, combinedLight, combinedOverlay);
                    this.renderCross(renderer, plantstack, 0.37f, 0.32f, matrixStack, buffer, combinedLight, combinedOverlay);
                    this.renderCross(renderer, plantstack, 0.13f, 0.32f, matrixStack, buffer, combinedLight, combinedOverlay);
                    break;
                }
            }
            case CROSS_SINGLE: {
                if (block == Values.blockLargeFlowerPot) {
                    matrixStack.func_227861_a_(0.5, (double)0.88f, 0.5);
                    matrixStack.func_227862_a_(2.8f, 2.6f, 2.8f);
                } else if (block == Values.blockMediumFlowerPot) {
                    matrixStack.func_227861_a_(0.5, (double)0.68f, 0.5);
                    matrixStack.func_227862_a_(2.2f, 2.0f, 2.6f);
                } else {
                    matrixStack.func_227861_a_(0.5, (double)0.48f, 0.5);
                    matrixStack.func_227862_a_(1.6f, 1.4f, 1.6f);
                }
                ItemRenderer renderer = Minecraft.func_71410_x().func_175599_af();
                this.render(renderer, plantstack, 225.0f, matrixStack, buffer, combinedLight, combinedOverlay);
                this.render(renderer, plantstack, 135.0f, matrixStack, buffer, combinedLight, combinedOverlay);
                break;
            }
            case BLOCK: {
                if (block == Values.blockLargeFlowerPot) {
                    matrixStack.func_227861_a_(0.5, (double)0.46f, 0.5);
                    matrixStack.func_227862_a_(2.5f, 2.5f, 2.5f);
                } else if (block == Values.blockMediumFlowerPot) {
                    matrixStack.func_227861_a_(0.5, (double)0.37f, 0.5);
                    matrixStack.func_227862_a_(1.8f, 1.8f, 1.8f);
                } else {
                    matrixStack.func_227861_a_(0.5, (double)0.3f, 0.5);
                }
                this.render(Minecraft.func_71410_x().func_175599_af(), plantstack, rotation, matrixStack, buffer, combinedLight, combinedOverlay);
                break;
            }
            case PANE: {
                if (block == Values.blockLargeFlowerPot) {
                    matrixStack.func_227861_a_(0.5, (double)0.78f, 0.5);
                    matrixStack.func_227862_a_(1.4f, 1.4f, 1.4f);
                } else if (block == Values.blockMediumFlowerPot) {
                    matrixStack.func_227861_a_(0.5, (double)0.61f, 0.5);
                    matrixStack.func_227862_a_(1.0f, 1.0f, 1.0f);
                } else {
                    matrixStack.func_227861_a_(0.5, (double)0.43f, 0.5);
                    matrixStack.func_227862_a_(0.55f, 0.55f, 0.55f);
                }
                this.render(Minecraft.func_71410_x().func_175599_af(), plantstack, rotation, matrixStack, buffer, combinedLight, combinedOverlay);
                break;
            }
            case TALL: {
                if (block == Values.blockLargeFlowerPot) {
                    matrixStack.func_227861_a_(0.5, (double)0.3f, 0.5);
                    matrixStack.func_227862_a_(2.5f, 5.0f, 2.5f);
                } else if (block == Values.blockMediumFlowerPot) {
                    matrixStack.func_227861_a_(0.5, (double)0.28f, 0.5);
                    matrixStack.func_227862_a_(1.8f, 2.6f, 1.8f);
                } else {
                    matrixStack.func_227861_a_(0.5, (double)0.22f, 0.5);
                    matrixStack.func_227862_a_(1.0f, 2.0f, 1.0f);
                }
                this.render(Minecraft.func_71410_x().func_175599_af(), plantstack, rotation, matrixStack, buffer, combinedLight, combinedOverlay);
            }
        }
        matrixStack.func_227865_b_();
    }

    private void render(ItemRenderer renderer, ItemStack plantstack, float rotation, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        renderer.func_229110_a_(plantstack, ItemCameraTransforms.TransformType.GROUND, combinedLight, combinedOverlay, matrixStack, buffer);
        matrixStack.func_227865_b_();
    }

    private void renderCross(ItemRenderer renderer, ItemStack plantstack, float x, float z, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, 0.0, (double)z);
        this.render(renderer, plantstack, 225.0f, matrixStack, buffer, combinedLight, combinedOverlay);
        this.render(renderer, plantstack, 135.0f, matrixStack, buffer, combinedLight, combinedOverlay);
        matrixStack.func_227865_b_();
    }
}

