/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.render;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityType;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.ClientFunction;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.model.ModelMultiLayer;
import shetiphian.terraqueous.client.render.RenderCoconut;
import shetiphian.terraqueous.client.render.RenderEnderTable;
import shetiphian.terraqueous.client.render.RenderFlowerPot;
import shetiphian.terraqueous.client.render.RenderSign;
import shetiphian.terraqueous.client.render.RenderStormForge;

public class RenderRegistry {
    public static List<Object> COLORIZE = new ArrayList<Object>();
    public static List<Triple<Item, String, IItemPropertyGetter>> OVERRIDES = new ArrayList<Triple<Item, String, IItemPropertyGetter>>();

    public static void registerLoaders(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("terraqueous:multi-layer"), (IModelLoader)new ModelMultiLayer.Loader());
    }

    public static void setup() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)Values.tileEnderTable, RenderEnderTable::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)Values.tileSign, RenderSign::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)Values.tileFlowerPot, RenderFlowerPot::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)Values.tileStormForgeAlter, RenderStormForge::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)Values.entityCoconut, (IRenderFactory)RenderCoconut.INSTANCE);
        RenderRegistry.setRenderLayer();
        for (Object object : COLORIZE) {
            if (object instanceof Block) {
                ClientFunction.registerColorize((Block)((Block)object));
                continue;
            }
            if (!(object instanceof Item)) continue;
            ClientFunction.registerColorize((Item)((Item)object));
        }
        COLORIZE.clear();
        for (Triple triple : OVERRIDES) {
            ItemModelsProperties.func_239418_a_((Item)((Item)triple.getLeft()), (ResourceLocation)new ResourceLocation((String)triple.getMiddle()), (IItemPropertyGetter)((IItemPropertyGetter)triple.getRight()));
        }
        OVERRIDES.clear();
    }

    private static void registerColorize() {
        ClientFunction.registerColorize((Block)Values.blockWaterVapor);
        ClientFunction.registerColorize((Block)Values.blockGlowVapor);
        ClientFunction.registerColorize((Block)Values.blockVaporLantern);
        ClientFunction.registerColorize((Block)Values.blockSmallFlowerPot);
        ClientFunction.registerColorize((Block)Values.blockMediumFlowerPot);
        ClientFunction.registerColorize((Block)Values.blockLargeFlowerPot);
        ClientFunction.registerColorize((Block)Values.blockPlanter);
        ClientFunction.registerColorize((Block)Values.blockGardenWallWave);
        ClientFunction.registerColorize((Block)Values.blockGardenWallSpeed);
        ClientFunction.registerColorize((Block)Values.blockDryingHay);
        ClientFunction.registerColorize((Block)Values.blockStormForge);
        ClientFunction.registerColorize((Block)Values.blockPergolaGate);
        ClientFunction.registerColorize((Block)Values.blockPergolaRoof);
        ClientFunction.registerColorize((Block)Values.blockPergolaWall);
        ClientFunction.registerColorize((Block)Values.blockPaper);
        ClientFunction.registerColorize((Block)Values.blockGlowPaper);
        ClientFunction.registerColorize((Block)Values.blockPaperLantern);
        ClientFunction.registerColorize((Block)Values.blockPlants.get((Object)PlantAPI.PlantType.GRASS));
        for (Block block : Values.blockPlants.values()) {
            ClientFunction.registerColorize((Block)block);
        }
        for (Block block : Values.blockLeaves.values()) {
            ClientFunction.registerColorize((Block)block);
        }
    }

    private static void setRenderLayer() {
        RenderType solid = RenderType.func_228639_c_();
        RenderType cutout = RenderType.func_228643_e_();
        RenderType mipped = RenderType.func_228641_d_();
        RenderType translucent = RenderType.func_228645_f_();
        for (Block block : Values.blockCloudTrapDoors.values()) {
            RenderTypeLookup.setRenderLayer((Block)block, layer -> layer == cutout);
        }
        for (Block block : Values.blockCloudDoors.values()) {
            RenderTypeLookup.setRenderLayer((Block)block, layer -> layer == cutout);
        }
        RenderTypeLookup.setRenderLayer((Block)Values.blockWaterVapor, layer -> layer == translucent);
        RenderTypeLookup.setRenderLayer((Block)Values.blockGlowVapor, layer -> layer == translucent);
        RenderTypeLookup.setRenderLayer((Block)Values.blockVaporLantern, layer -> layer == solid || layer == translucent);
        RenderTypeLookup.setRenderLayer((Block)Values.blockDoodadBurnium, layer -> layer == translucent);
        RenderTypeLookup.setRenderLayer((Block)Values.blockDoodadEndimium, layer -> layer == translucent);
        RenderTypeLookup.setRenderLayer((Block)Values.blockDoodadGlassShards, layer -> layer == translucent);
        for (Block block : Values.blockFlowers) {
            RenderTypeLookup.setRenderLayer((Block)block, layer -> layer == cutout);
        }
        RenderTypeLookup.setRenderLayer((Block)Values.blockGardenWallTransmute, layer -> layer == mipped);
        RenderTypeLookup.setRenderLayer((Block)Values.blockGardenWallNecrotic, layer -> layer == mipped);
        RenderTypeLookup.setRenderLayer((Block)Values.blockDryingHay, layer -> layer == mipped);
        RenderTypeLookup.setRenderLayer((Block)Values.blockHayPile, layer -> layer == mipped);
        RenderTypeLookup.setRenderLayer((Block)Values.blockBurniumOre, layer -> layer == solid || layer == translucent);
        RenderTypeLookup.setRenderLayer((Block)Values.blockEndimiumOre, layer -> layer == solid || layer == translucent);
        RenderTypeLookup.setRenderLayer((Block)Values.blockPergolaGate, layer -> layer == mipped);
        RenderTypeLookup.setRenderLayer((Block)Values.blockPergolaRoof, layer -> layer == mipped);
        RenderTypeLookup.setRenderLayer((Block)Values.blockPergolaWall, layer -> layer == mipped);
        for (Block block : Values.blockPlants.values()) {
            RenderTypeLookup.setRenderLayer((Block)block, layer -> layer == cutout);
        }
        for (Block block : Values.blockSaplings.values()) {
            RenderTypeLookup.setRenderLayer((Block)block, layer -> layer == cutout);
        }
        for (Block block : Values.blockLeaves.values()) {
            RenderTypeLookup.setRenderLayer((Block)block, layer -> layer == solid || layer == mipped || layer == cutout);
        }
        for (Block block : Values.blockWoodTrapDoors.values()) {
            RenderTypeLookup.setRenderLayer((Block)block, layer -> layer == cutout);
        }
        for (Block block : Values.blockWoodDoors.values()) {
            RenderTypeLookup.setRenderLayer((Block)block, layer -> layer == cutout);
        }
        RenderTypeLookup.setRenderLayer((Block)Values.blockPaperLantern, layer -> layer == solid || layer == translucent);
    }
}

