/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import shetiphian.terraqueous.api.cloud.CloudPresets;
import shetiphian.terraqueous.api.cloud.ICloud;

public class BlockCarpet {

    public static class Cloud
    extends CarpetBlock
    implements ICloud {
        public Cloud(DyeColor color) {
            super(color, CloudPresets.properties().func_200943_b(0.3f));
        }

        public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
            return CloudPresets.isFlammable();
        }

        public PushReaction func_149656_h(BlockState state) {
            return CloudPresets.getPushReaction();
        }

        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
            if (context == ISelectionContext.func_216377_a() || CloudPresets.shouldCollide(state, world, pos, context.getEntity())) {
                return super.func_220071_b(state, world, pos, context);
            }
            return VoxelShapes.func_197880_a();
        }

        public void func_176199_a(World world, BlockPos pos, Entity entity) {
            CloudPresets.onEntityWalking(world, pos, entity);
        }

        public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
            CloudPresets.onEntityCollision(state, world, pos, entity);
        }

        public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
            CloudPresets.onFallenUpon(world, pos, entity, fallDistance);
        }

        @Override
        public boolean isCloudBlock(BlockState state, IBlockReader world, BlockPos pos) {
            return true;
        }

        @Override
        public boolean isCloudKickable(BlockState state, IBlockReader world, BlockPos pos) {
            return false;
        }
    }

    public static class Hay
    extends CarpetBlock {
        public Hay() {
            super(DyeColor.YELLOW, AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200943_b(0.3f).func_200947_a(SoundType.field_185850_c));
        }
    }
}

