/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import shetiphian.terraqueous.api.cloud.CloudPresets;
import shetiphian.terraqueous.api.cloud.ICloud;
import shetiphian.terraqueous.common.block.BlockColumn;

public class BlockCloudColumn
extends BlockColumn
implements ICloud {
    public BlockCloudColumn(MaterialColor color) {
        super(CloudPresets.properties(color));
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return CloudPresets.isFlammable();
    }

    public PushReaction func_149656_h(BlockState state) {
        return CloudPresets.getPushReaction();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (context == ISelectionContext.func_216377_a() || CloudPresets.shouldCollide(state, world, pos, context.getEntity())) {
            return super.func_220071_b(state, world, pos, context);
        }
        return VoxelShapes.func_197880_a();
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        CloudPresets.onEntityWalking(world, pos, entity);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        CloudPresets.onEntityCollision(state, world, pos, entity);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        CloudPresets.onFallenUpon(world, pos, entity, fallDistance);
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    public boolean isCloudBlock(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean isCloudKickable(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }
}

