/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;

public class BlockDoodad
extends Block {
    private static final Map<EnumType, List<DropEntry>> cacheDropList = new HashMap<EnumType, List<DropEntry>>();
    private static final VoxelShape SHAPE_ENDIMIUM = VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
    private static final VoxelShape SHAPE_BURNIUM = VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
    private static final VoxelShape SHAPE_FLAT = VoxelShapes.func_197873_a((double)0.05, (double)0.0, (double)0.05, (double)0.95, (double)0.15, (double)0.95);
    private static final Material MATERIAL = new Material(MaterialColor.field_151667_k, false, false, false, false, false, false, PushReaction.IGNORE);
    private final EnumType type;

    public BlockDoodad(EnumType type) {
        super(type.properties);
        this.type = type;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (this.type == EnumType.ENDIMIUM) {
            return SHAPE_ENDIMIUM;
        }
        if (this.type == EnumType.BURNIUM) {
            return SHAPE_BURNIUM;
        }
        return SHAPE_FLAT;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return BlockDoodad.func_220056_d((BlockState)world.func_180495_p(pos.func_177977_b()), (IBlockReader)world, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack tool = (ItemStack)builder.func_216019_b(LootParameters.field_216289_i);
        int fortune = tool == null || tool.func_190926_b() ? 0 : EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
        switch (this.type) {
            case BRANCH: {
                this.buildDrops(drops, fortune, (Integer)Configuration.DOODADS.STICK.dropAttempts.get(), (Integer)Configuration.DOODADS.STICK.dropChance.get(), (Integer)Configuration.DOODADS.STICK.dropCount.get());
                break;
            }
            case STONE: {
                this.buildDrops(drops, fortune, (Integer)Configuration.DOODADS.STONE.dropAttempts.get(), (Integer)Configuration.DOODADS.STONE.dropChance.get(), (Integer)Configuration.DOODADS.STONE.dropCount.get());
                break;
            }
            case BONE: {
                this.buildDrops(drops, fortune, (Integer)Configuration.DOODADS.BONE.dropAttempts.get(), (Integer)Configuration.DOODADS.BONE.dropChance.get(), (Integer)Configuration.DOODADS.BONE.dropCount.get());
                break;
            }
            case SANDSTONE: {
                this.buildDrops(drops, fortune, (Integer)Configuration.DOODADS.SANDSTONE.dropAttempts.get(), (Integer)Configuration.DOODADS.SANDSTONE.dropChance.get(), (Integer)Configuration.DOODADS.SANDSTONE.dropCount.get());
                break;
            }
            case REDSANDSTONE: {
                this.buildDrops(drops, fortune, (Integer)Configuration.DOODADS.REDSANDSTONE.dropAttempts.get(), (Integer)Configuration.DOODADS.REDSANDSTONE.dropChance.get(), (Integer)Configuration.DOODADS.REDSANDSTONE.dropCount.get());
                break;
            }
            case ENDIMIUM: {
                this.buildDrops(drops, fortune, (Integer)Configuration.DOODADS.ENDIMIUM.dropAttempts.get(), (Integer)Configuration.DOODADS.ENDIMIUM.dropChance.get(), (Integer)Configuration.DOODADS.ENDIMIUM.dropCount.get());
                break;
            }
            case BURNIUM: {
                this.buildDrops(drops, fortune, (Integer)Configuration.DOODADS.BURNIUM.dropAttempts.get(), (Integer)Configuration.DOODADS.BURNIUM.dropChance.get(), (Integer)Configuration.DOODADS.BURNIUM.dropCount.get());
                break;
            }
            case GLASSSHARDS: {
                drops.add(new ItemStack((IItemProvider)this));
            }
        }
        return drops;
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        if (entity instanceof EnderDragonEntity && this.type == EnumType.ENDIMIUM) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        boolean hasBoots;
        boolean bl = hasBoots = entity instanceof LivingEntity && !((LivingEntity)entity).func_184582_a(EquipmentSlotType.FEET).func_190926_b();
        if (this.type == EnumType.ENDIMIUM || this.type == EnumType.BURNIUM || this.type == EnumType.GLASSSHARDS && !hasBoots) {
            entity.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        boolean hasBoots;
        boolean bl = hasBoots = entity instanceof LivingEntity && !((LivingEntity)entity).func_184582_a(EquipmentSlotType.FEET).func_190926_b();
        if (this.type == EnumType.ENDIMIUM || this.type == EnumType.BURNIUM || this.type == EnumType.GLASSSHARDS) {
            entity.func_70097_a(DamageSource.field_76377_j, this.type == EnumType.GLASSSHARDS && hasBoots ? 1.0f : 2.5f);
        }
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return this.type == EnumType.ENDIMIUM ? 6 : (this.type == EnumType.BURNIUM ? 10 : 0);
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, MobEntity entity) {
        return this.type == EnumType.BURNIUM || this.type == EnumType.ENDIMIUM ? PathNodeType.DANGER_CACTUS : super.getAiPathNodeType(state, world, pos, entity);
    }

    private void buildDrops(List<ItemStack> drops, int fortune, int dropAttempts, int dropChance, int dropCount) {
        List<DropEntry> dropList;
        if (Values.rebuildDustList) {
            cacheDropList.clear();
            for (EnumType enumType : EnumType.values()) {
                cacheDropList.put(enumType, BlockDoodad.generateDropList(enumType));
            }
            Values.rebuildDustList = false;
        }
        if ((dropList = cacheDropList.get((Object)this.type)) == null) {
            dropList = BlockDoodad.generateDropList(this.type);
            cacheDropList.put(this.type, dropList);
        }
        if (!dropList.isEmpty()) {
            int maxAttempts = this.getNumber(dropAttempts);
            if (dropChance > 1) {
                dropChance = Math.max(2, (int)((double)dropChance * (1.0 - (double)Math.min(fortune, 5) / 10.0)));
            }
            if (dropChance > 1 && fortune > 5) {
                maxAttempts += fortune - 5;
            }
            for (int attempt = 0; attempt < maxAttempts; ++attempt) {
                if (dropChance <= 0 || Function.random.nextInt(dropChance) != 0) continue;
                for (int drop = 0; drop < this.getNumber(dropCount) + Function.random.nextInt(fortune + 1); ++drop) {
                    DropEntry dropEntry = dropList.get(Function.random.nextInt(dropList.size()));
                    drops.add(dropEntry.getStack(fortune));
                }
                return;
            }
        }
    }

    private int getNumber(int value) {
        if (value < 0) {
            return Function.random.nextInt(1 - value) + 1;
        }
        return value;
    }

    private static List<DropEntry> generateDropList(EnumType type) {
        List whitelist = null;
        List blacklist = null;
        switch (type) {
            case BRANCH: {
                whitelist = (List)Configuration.DOODADS.STICK.whitelist.get();
                blacklist = (List)Configuration.DOODADS.STICK.blacklist.get();
                break;
            }
            case STONE: {
                whitelist = (List)Configuration.DOODADS.STONE.whitelist.get();
                blacklist = (List)Configuration.DOODADS.STONE.blacklist.get();
                break;
            }
            case BONE: {
                whitelist = (List)Configuration.DOODADS.BONE.whitelist.get();
                blacklist = (List)Configuration.DOODADS.BONE.blacklist.get();
                break;
            }
            case SANDSTONE: {
                whitelist = (List)Configuration.DOODADS.SANDSTONE.whitelist.get();
                blacklist = (List)Configuration.DOODADS.SANDSTONE.blacklist.get();
                break;
            }
            case REDSANDSTONE: {
                whitelist = (List)Configuration.DOODADS.REDSANDSTONE.whitelist.get();
                blacklist = (List)Configuration.DOODADS.REDSANDSTONE.blacklist.get();
                break;
            }
            case ENDIMIUM: {
                whitelist = (List)Configuration.DOODADS.ENDIMIUM.whitelist.get();
                blacklist = (List)Configuration.DOODADS.ENDIMIUM.blacklist.get();
                break;
            }
            case BURNIUM: {
                whitelist = (List)Configuration.DOODADS.BURNIUM.whitelist.get();
                blacklist = (List)Configuration.DOODADS.BURNIUM.blacklist.get();
            }
        }
        if (whitelist != null && blacklist != null) {
            String resource;
            Matcher matcher;
            HashMap<String, String> tags = new HashMap<String, String>();
            HashMap<String, String> items = new HashMap<String, String>();
            ArrayList<String> removeItems = new ArrayList<String>();
            ArrayList<String> removeMods = new ArrayList<String>();
            for (String string : whitelist) {
                try {
                    matcher = Configuration.Menu_Doodads.PATTERN_ITEM.matcher(string);
                    if (!matcher.find()) continue;
                    resource = matcher.group(1);
                    String count = matcher.group(2);
                    if (string.startsWith("tag|")) {
                        tags.put(resource, count);
                        continue;
                    }
                    items.put(resource, count);
                }
                catch (Exception error) {
                    Terraqueous.LOGGER.debug("Error processing" + type.func_176610_l() + "whitelist entry '" + string + "'; " + error);
                }
            }
            for (String string : blacklist) {
                try {
                    matcher = Configuration.Menu_Doodads.PATTERN_ITEM.matcher(string);
                    if (matcher.find()) {
                        resource = matcher.group(1);
                        if (string.startsWith("tag|")) {
                            tags.remove(resource);
                            continue;
                        }
                        removeItems.add(resource);
                        continue;
                    }
                    if (!string.startsWith("mod|")) continue;
                    removeMods.add(string.substring(4));
                }
                catch (Exception error) {
                    Terraqueous.LOGGER.debug("Error processing" + type.func_176610_l() + "blacklist entry '" + string + "'; " + error);
                }
            }
            for (Map.Entry entry : tags.entrySet()) {
                try {
                    ITag.INamedTag tag = ItemTags.func_199901_a((String)((String)entry.getKey()));
                    for (Item item : tag.func_230236_b_()) {
                        try {
                            items.put(item.getRegistryName().toString(), (String)entry.getValue());
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception error) {
                    Terraqueous.LOGGER.debug("Error processing" + type.func_176610_l() + "tag entry '" + (String)entry.getKey() + "'; " + error);
                }
            }
            for (String string : removeItems) {
                items.remove(string);
            }
            ArrayList<DropEntry> entryList = new ArrayList<DropEntry>();
            for (Map.Entry entry : items.entrySet()) {
                try {
                    ItemStack stack;
                    ResourceLocation resource2 = new ResourceLocation((String)entry.getKey());
                    if (removeMods.contains(resource2.func_110624_b()) || (stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(resource2))).func_190926_b()) continue;
                    entryList.add(DropEntry.create(stack, (String)entry.getValue()));
                }
                catch (Exception error) {
                    Terraqueous.LOGGER.debug("Error adding item '" + (String)entry.getKey() + "' to " + type.func_176610_l() + "droplist; " + error);
                }
            }
            return entryList;
        }
        return new ArrayList<DropEntry>();
    }

    private static class DropEntry {
        private final ItemStack stack;
        private final int min;
        private final int max;

        public static DropEntry create(@Nonnull ItemStack stack, String amount) {
            int min = 1;
            int max = 1;
            try {
                if (amount.contains("-")) {
                    min = Integer.parseInt(amount.split("-")[0]);
                    max = Integer.parseInt(amount.split("-")[1]);
                } else {
                    min = max = Integer.parseInt(amount);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new DropEntry(stack, min, max);
        }

        private DropEntry(ItemStack stack, int min, int max) {
            this.stack = stack;
            this.min = Math.min(min, max);
            this.max = Math.max(max, min);
        }

        @Nonnull
        public ItemStack getStack(int fortune) {
            ItemStack returnStack = this.stack.func_77946_l();
            int count = this.max == this.min ? this.max : Function.random.nextInt(this.max - this.min) + this.min;
            int boost = fortune;
            if (fortune > 5) {
                fortune = (fortune - 5) / 2 + 1;
                boost = 5 + fortune + Function.random.nextInt(fortune);
            }
            returnStack.func_190920_e(MathHelper.func_76125_a((int)(count + boost), (int)1, (int)returnStack.func_77976_d()));
            return returnStack;
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        BRANCH(MaterialColor.field_151663_o, 0.75f, ToolType.AXE, 0, SoundType.field_185848_a),
        STONE(MaterialColor.field_151665_m, 0.75f, ToolType.PICKAXE, 0, SoundType.field_185851_d),
        BONE(MaterialColor.field_151658_d, 0.25f, ToolType.SHOVEL, 0, SoundType.field_185851_d),
        SANDSTONE(MaterialColor.field_151658_d, 0.75f, ToolType.PICKAXE, 0, SoundType.field_185851_d),
        ENDIMIUM(MaterialColor.field_193570_V, 0.75f, ToolType.PICKAXE, 2, SoundType.field_185853_f),
        BURNIUM(MaterialColor.field_193562_N, 0.75f, ToolType.PICKAXE, 1, SoundType.field_185853_f),
        GLASSSHARDS(MaterialColor.field_151660_b, 0.25f, ToolType.SHOVEL, 0, SoundType.field_185853_f),
        REDSANDSTONE(MaterialColor.field_151676_q, 0.75f, ToolType.PICKAXE, 0, SoundType.field_185851_d);

        private final AbstractBlock.Properties properties;

        private EnumType(MaterialColor color, float hardness, ToolType toolType, int toolLevel, SoundType soundType) {
            this.properties = AbstractBlock.Properties.func_200949_a((Material)MATERIAL, (MaterialColor)color).func_200948_a(hardness, 2.0f).func_200947_a(soundType).harvestTool(toolType).harvestLevel(toolLevel);
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        private boolean isTranslucent() {
            return this == ENDIMIUM || this == BURNIUM || this == GLASSSHARDS;
        }
    }
}

