/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.terraqueous.client.render.RenderRegistry;
import shetiphian.terraqueous.common.item.ItemBlockRGB;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;

public class BlockFlowerPot
extends Block
implements IColored,
IRGB16_Block {
    public static final RGB16 BASE_COLOR = new RGB16(10, 5, 4);
    private static final VoxelShape[] SHAPE = new VoxelShape[]{Block.func_208617_a((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)6.0, (double)11.5), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.func_208617_a((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)10.0, (double)14.5)};
    private final int size;

    public BlockFlowerPot(int size) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(0.2f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(0));
        this.size = MathHelper.func_76125_a((int)size, (int)0, (int)3);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityFlowerPot();
    }

    private TileEntityFlowerPot getTile(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityFlowerPot ? (TileEntityFlowerPot)tile : null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE[this.size];
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityFlowerPot tile = this.getTile((IBlockReader)world, pos);
        if (tile != null && stack.func_77973_b() instanceof ItemBlockRGB) {
            tile.setRGB16(((ItemBlockRGB)stack.func_77973_b()).getRGB16(stack), placer instanceof PlayerEntity ? (PlayerEntity)placer : null);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntityFlowerPot tile = this.getTile((IBlockReader)world, pos);
        if (tile == null || player == null) {
            return ActionResultType.PASS;
        }
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_190926_b()) {
            if (!tile.getPlantStack().func_190926_b() && player.func_213453_ef()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    Function.giveItem((PlayerEntity)player, (ItemStack)tile.getPlantStack());
                }
                tile.setPlantStack(ItemStack.field_190927_a);
                Function.syncTile((TileEntity)tile);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        Item heldItem = heldStack.func_77973_b();
        ItemStack giveStack = null;
        if (heldItem instanceof BlockItem) {
            Block block = Block.func_149634_a((Item)heldItem);
            if (!tile.getPlantStack().func_190926_b()) {
                giveStack = tile.getPlantStack();
            }
            tile.setPlantFacing(player.func_174811_aO().func_176734_d());
            tile.setPlantStack(heldStack.func_77946_l().func_77979_a(1));
            Function.syncTile((TileEntity)tile);
            world.func_184133_a(player, pos, block.func_220072_p(block.func_176223_P()).func_185841_e(), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
                if (giveStack != null) {
                    Function.giveItem((PlayerEntity)player, (ItemStack)giveStack);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean recolorBlock(BlockState state, IWorld world, BlockPos pos, PlayerEntity player, Hand hand, Direction side, Vector3d hitVec, String dyeName) {
        TileEntityFlowerPot tile;
        if (!Strings.isNullOrEmpty((String)dyeName) && (tile = this.getTile((IBlockReader)world, pos)) != null) {
            if (!world.func_201670_d()) {
                if (player == null) {
                    tile.getRGB16(null).setValues(dyeName);
                } else {
                    tile.getRGB16(player).recolor(player, dyeName);
                }
                Function.syncTile((TileEntity)tile);
            }
            if (player != null) {
                player.func_184609_a(hand);
            }
            return true;
        }
        return false;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityFlowerPot tile;
        if (data.world != null && data.pos != null && (tile = this.getTile((IBlockReader)data.world, data.pos)) != null) {
            return tile.getRGB16(null).getColor();
        }
        return 0xFFFFFF;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ItemStack plantStack;
        List drops = super.func_220076_a(state, builder);
        TileEntity builderTile = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (builderTile instanceof TileEntityFlowerPot && !(plantStack = ((TileEntityFlowerPot)builderTile).getPlantStack()).func_190926_b()) {
            drops.add(plantStack);
        }
        return drops;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        TileEntityFlowerPot tile = this.getTile(world, pos);
        if (tile != null) {
            RGB16StackHelper.setRGB16((ItemStack)stack, (RGB16)tile.getRGB16(null));
        }
        return stack;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack plantStack;
        TileEntityFlowerPot tile;
        if (player.func_213453_ef() && (tile = this.getTile(world, pos)) != null && !(plantStack = tile.getPlantStack()).func_190926_b()) {
            return plantStack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }
}

