/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.Tags;
import shetiphian.core.common.Function;
import shetiphian.core.common.IBonemealable;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.item.ItemBlockFlowers;
import shetiphian.terraqueous.common.misc.IInteractionHandler;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockFlowers
extends FlowerBlock
implements IBonemealable,
IForgeShearable {
    public static final IntegerProperty SIZE = IntegerProperty.func_177719_a((String)"size", (int)0, (int)1);
    private IInteractionHandler handler = null;

    public BlockFlowers(IInteractionHandler handler) {
        this(Effects.field_76437_t, 4);
        this.handler = handler;
    }

    public BlockFlowers(Effect effect, int effectDuration) {
        super(effect, effectDuration, AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)SIZE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{SIZE});
    }

    public static int maxSize() {
        return 1;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return true;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return Tags.Blocks.DIRT.func_230235_a_((Object)state.func_177230_c()) || state.func_177230_c() == Blocks.field_196658_i || state.func_177230_c() == Values.blockPlanter;
    }

    public boolean canGrow(World world, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((Property)SIZE) < BlockFlowers.maxSize() || Function.getBlockDown((IBlockReader)world, (BlockPos)pos) != Values.blockPlanter;
    }

    public boolean canUseBonemeal(World world, Random random, BlockPos pos, BlockState state) {
        return this.canGrow(world, pos, state, world.field_72995_K) && (double)random.nextFloat() < 0.45;
    }

    public void grow(World world, Random rand, BlockPos pos, BlockState state) {
        if (!world.field_72995_K) {
            if ((Integer)state.func_177229_b((Property)SIZE) < BlockFlowers.maxSize()) {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a((Property)SIZE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)SIZE) + 1))), (boolean)true);
            } else if (Function.getBlockDown((IBlockReader)world, (BlockPos)pos) != Values.blockPlanter) {
                this.spreadFlower(world, rand, pos, state);
            }
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.field_72995_K && world.func_72935_r()) {
            if (this.func_196260_a(state, (IWorldReader)world, pos)) {
                if ((Integer)state.func_177229_b((Property)SIZE) < BlockFlowers.maxSize()) {
                    if (PlantFunctions.canGrow((World)world, pos, PlantAPI.PlantType.FLOWER)) {
                        this.grow((World)world, random, pos, state);
                    }
                } else if (Function.getBlockDown((IBlockReader)world, (BlockPos)pos) != Values.blockPlanter && PlantFunctions.canSpread((World)world, pos, PlantAPI.PlantType.FLOWER)) {
                    this.grow((World)world, random, pos, state);
                }
            } else {
                world.func_175655_b(pos, true);
            }
        }
    }

    private void spreadFlower(World world, Random random, BlockPos pos, BlockState state) {
        byte maxAttempts = PlantFunctions.getMaxPlacementAttempts((IBlockReader)world, pos, PlantAPI.PlantType.FLOWER);
        byte[] spreadRadius = PlantFunctions.getSpreadRadius((IBlockReader)world, pos, PlantAPI.PlantType.FLOWER);
        for (byte attempt = 0; attempt < maxAttempts; attempt = (byte)(attempt + 1)) {
            BlockPos sPos = pos.func_177982_a(this.getOffset(spreadRadius[0], random), this.getOffset(spreadRadius[1], random), this.getOffset(spreadRadius[0], random));
            BlockState sState = world.func_180495_p(sPos);
            if (sState.isAir((IBlockReader)world, sPos) && this.func_196260_a(sState, (IWorldReader)world, sPos) && this.canSpreadHere(world, sPos)) {
                Function.setBlock((IWorld)world, (BlockPos)sPos, (BlockState)((BlockState)state.func_206870_a((Property)SIZE, (Comparable)Integer.valueOf(0))), (boolean)true);
                return;
            }
            pos = sPos;
        }
    }

    private int getOffset(int spreadRadius, Random random) {
        return random.nextInt(spreadRadius) - random.nextInt(spreadRadius);
    }

    private boolean canSpreadHere(World world, BlockPos pos) {
        if (Function.getBlockDown((IBlockReader)world, (BlockPos)pos) == Values.blockPlanter) {
            return false;
        }
        int touching = 0;
        int total = 0;
        int air = 0;
        for (int sX = -2; sX <= 2; sX = (int)((byte)(sX + 1))) {
            for (int sZ = -2; sZ <= 2; sZ = (int)((byte)(sZ + 1))) {
                if (sX == 0 && sZ == 0) continue;
                BlockPos sPos = pos.func_177982_a(sX, 0, sZ);
                if (world.func_175623_d(sPos)) {
                    air = (byte)(air + 1);
                    continue;
                }
                if (world.func_180495_p(sPos).func_177230_c() != this) continue;
                total = (byte)(total + 1);
                if (sZ == 0 && (sX == -1 || sX == 1)) {
                    touching = (byte)(touching + 1);
                }
                if (sX != 0 || sZ != -1 && sZ != 1) continue;
                touching = (byte)(touching + 1);
            }
        }
        return touching < 2 && total < 2 && air > 12;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (Function.getBlockDown((IBlockReader)world, (BlockPos)pos) == Values.blockPlanter) {
            return true;
        }
        Biome biome = world.func_226691_t_(pos);
        if (BiomeDictionary.hasAnyType((Biome)biome) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            return false;
        }
        return Function.getBlockDown((IBlockReader)world, (BlockPos)pos) != Blocks.field_150458_ak && super.func_196260_a(state, world, pos);
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return ItemBlockFlowers.create(new ItemStack((IItemProvider)this), (Integer)state.func_177229_b((Property)SIZE));
    }

    public Effect func_220094_d() {
        Effect effect = this.handler != null ? this.handler.getStewEffect((Block)this) : null;
        return effect != null ? effect : super.func_220094_d();
    }

    public int func_220095_e() {
        int duration = this.handler != null ? this.handler.getStewEffectDuration((Block)this) : -1;
        return duration > -1 ? duration : super.func_220095_e();
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (this.handler != null && !this.handler.onEntityCollision(state, world, pos, entity)) {
            super.func_196262_a(state, world, pos, entity);
        }
    }
}

